# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # The request message for a webhook call.
        # @!attribute [rw] session
        #   @return [::String]
        #     The unique identifier of detectIntent request session.
        #     Can be used to identify end-user inside webhook implementation.
        #     Format: `projects/<Project ID>/agent/sessions/<Session ID>`, or
        #     `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
        #     ID>/sessions/<Session ID>`.
        # @!attribute [rw] response_id
        #   @return [::String]
        #     The unique identifier of the response. Contains the same value as
        #     `[Streaming]DetectIntentResponse.response_id`.
        # @!attribute [rw] query_result
        #   @return [::Google::Cloud::Dialogflow::V2::QueryResult]
        #     The result of the conversational query or event processing. Contains the
        #     same value as `[Streaming]DetectIntentResponse.query_result`.
        # @!attribute [rw] original_detect_intent_request
        #   @return [::Google::Cloud::Dialogflow::V2::OriginalDetectIntentRequest]
        #     Optional. The contents of the original request that was passed to
        #     `[Streaming]DetectIntent` call.
        class WebhookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for a webhook call.
        #
        # This response is validated by the Dialogflow server. If validation fails,
        # an error will be returned in the
        # {::Google::Cloud::Dialogflow::V2::QueryResult#diagnostic_info QueryResult.diagnostic_info}
        # field. Setting JSON fields to an empty value with the wrong type is a common
        # error. To avoid this error:
        #
        # - Use `""` for empty strings
        # - Use `{}` or `null` for empty objects
        # - Use `[]` or `null` for empty arrays
        #
        # For more information, see the
        # [Protocol Buffers Language
        # Guide](https://developers.google.com/protocol-buffers/docs/proto3#json).
        # @!attribute [rw] fulfillment_text
        #   @return [::String]
        #     Optional. The text response message intended for the end-user.
        #     It is recommended to use `fulfillment_messages.text.text[0]` instead.
        #     When provided, Dialogflow uses this field to populate
        #     {::Google::Cloud::Dialogflow::V2::QueryResult#fulfillment_text QueryResult.fulfillment_text}
        #     sent to the integration or API caller.
        # @!attribute [rw] fulfillment_messages
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Intent::Message>]
        #     Optional. The rich response messages intended for the end-user.
        #     When provided, Dialogflow uses this field to populate
        #     {::Google::Cloud::Dialogflow::V2::QueryResult#fulfillment_messages QueryResult.fulfillment_messages}
        #     sent to the integration or API caller.
        # @!attribute [rw] source
        #   @return [::String]
        #     Optional. A custom field used to identify the webhook source.
        #     Arbitrary strings are supported.
        #     When provided, Dialogflow uses this field to populate
        #     {::Google::Cloud::Dialogflow::V2::QueryResult#webhook_source QueryResult.webhook_source}
        #     sent to the integration or API caller.
        # @!attribute [rw] payload
        #   @return [::Google::Protobuf::Struct]
        #     Optional. This field can be used to pass custom data from your webhook to
        #     the integration or API caller. Arbitrary JSON objects are supported. When
        #     provided, Dialogflow uses this field to populate
        #     {::Google::Cloud::Dialogflow::V2::QueryResult#webhook_payload QueryResult.webhook_payload}
        #     sent to the integration or API caller. This field is also used by the
        #     [Google Assistant
        #     integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
        #     for rich response messages.
        #     See the format definition at [Google Assistant Dialogflow webhook
        #     format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
        # @!attribute [rw] output_contexts
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Context>]
        #     Optional. The collection of output contexts that will overwrite currently
        #     active contexts for the session and reset their lifespans.
        #     When provided, Dialogflow uses this field to populate
        #     {::Google::Cloud::Dialogflow::V2::QueryResult#output_contexts QueryResult.output_contexts}
        #     sent to the integration or API caller.
        # @!attribute [rw] followup_event_input
        #   @return [::Google::Cloud::Dialogflow::V2::EventInput]
        #     Optional. Invokes the supplied events.
        #     When this field is set, Dialogflow ignores the `fulfillment_text`,
        #     `fulfillment_messages`, and `payload` fields.
        # @!attribute [rw] session_entity_types
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SessionEntityType>]
        #     Optional. Additional session entity types to replace or extend developer
        #     entity types with. The entity synonyms apply to all languages and persist
        #     for the session. Setting this data from a webhook overwrites
        #     the session entity types that have been set using `detectIntent`,
        #     `streamingDetectIntent` or
        #     {::Google::Cloud::Dialogflow::V2::SessionEntityType SessionEntityType}
        #     management methods.
        class WebhookResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the contents of the original request that was passed to
        # the `[Streaming]DetectIntent` call.
        # @!attribute [rw] source
        #   @return [::String]
        #     The source of this request, e.g., `google`, `facebook`, `slack`. It is set
        #     by Dialogflow-owned servers.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. The version of the protocol used for this request.
        #     This field is AoG-specific.
        # @!attribute [rw] payload
        #   @return [::Google::Protobuf::Struct]
        #     Optional. This field is set to the value of the `QueryParameters.payload`
        #     field passed in the request. Some integrations that query a Dialogflow
        #     agent may provide additional information in the payload.
        #
        #     In particular, for the Dialogflow Phone Gateway integration, this field has
        #     the form:
        #     <pre>{
        #      "telephony": {
        #        "caller_id": "+18558363987"
        #      }
        #     }</pre>
        #     Note: The caller ID field (`caller_id`) will be redacted for Trial
        #     Edition agents and populated with the caller ID in [E.164
        #     format](https://en.wikipedia.org/wiki/E.164) for Essentials Edition agents.
        class OriginalDetectIntentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
