# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Represents a call of a specific tool's action with the specified inputs.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The {::Google::Cloud::Dialogflow::V2::Tool tool} associated with
        #     this call. Format:
        #     `projects/<ProjectID>/locations/<LocationID>/tools/<ToolID>`.
        # @!attribute [rw] tool_display_name
        #   @return [::String]
        #     Optional. A human readable short name of the tool, to be shown on the UI.
        # @!attribute [rw] tool_display_details
        #   @return [::String]
        #     Optional. A human readable description of the tool.
        # @!attribute [rw] action
        #   @return [::String]
        #     Optional. The name of the tool's action associated with this call.
        # @!attribute [rw] input_parameters
        #   @return [::Google::Protobuf::Struct]
        #     Optional. The action's input parameters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time of the tool call.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     Optional. The answer record associated with this tool call.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dialogflow::V2::ToolCall::State]
        #     Output only. State of the tool call.
        class ToolCall
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Tool call states.
          module State
            # Default value.
            STATE_UNSPECIFIED = 0

            # The tool call has been triggered.
            TRIGGERED = 1

            # The tool call requires confirmation from a human.
            NEEDS_CONFIRMATION = 2
          end
        end

        # The result of calling a tool's action.
        # @!attribute [rw] tool
        #   @return [::String]
        #     Optional. The {::Google::Cloud::Dialogflow::V2::Tool tool} associated with
        #     this call. Format:
        #     `projects/<ProjectID>/locations/<LocationID>/tools/<ToolID>`.
        # @!attribute [rw] action
        #   @return [::String]
        #     Optional. The name of the tool's action associated with this call.
        # @!attribute [rw] error
        #   @return [::Google::Cloud::Dialogflow::V2::ToolCallResult::Error]
        #     The tool call's error.
        #
        #     Note: The following fields are mutually exclusive: `error`, `raw_content`, `content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] raw_content
        #   @return [::String]
        #     Only populated if the response content is not utf-8 encoded.
        #     (by definition byte fields are base64 encoded).
        #
        #     Note: The following fields are mutually exclusive: `raw_content`, `error`, `content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] content
        #   @return [::String]
        #     Only populated if the response content is utf-8 encoded.
        #
        #     Note: The following fields are mutually exclusive: `content`, `error`, `raw_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time of the tool call result.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     Optional. The answer record associated with this tool call result.
        class ToolCallResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An error produced by the tool call.
          # @!attribute [rw] message
          #   @return [::String]
          #     Optional. The error message of the function.
          class Error
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
