# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Request message of CreateTool.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project/location to create tool for. Format:
        #     `projects/<Project ID>/locations/<Location ID>`
        # @!attribute [rw] tool
        #   @return [::Google::Cloud::Dialogflow::V2::Tool]
        #     Required. The tool to create.
        # @!attribute [rw] tool_id
        #   @return [::String]
        #     Optional. The ID to use for the tool, which will become the final
        #     component of the tool's resource name.
        #
        #     The tool ID must be compliant with the regression formula
        #     `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
        #     If the field is not provide, an Id will be auto-generated.
        #     If the field is provided, the caller is responsible for
        #     1. the uniqueness of the ID, otherwise the request will be rejected.
        #     2. the consistency for whether to use custom ID or not under a project to
        #     better ensure uniqueness.
        class CreateToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of GetTool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The tool resource name to retrieve. Format:
        #     `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`
        class GetToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of ListTools.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project/location to list tools for. Format:
        #     `projects/<Project ID>/locations/<Location ID>`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of conversation models to return in a single page.
        #     Default to 10.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListToolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of ListTools.
        # @!attribute [rw] tools
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Tool>]
        #     List of tools retrieved.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListToolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of DeleteTool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The tool resource name to delete. Format:
        #     `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`
        class DeleteToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of UpdateTool.
        # @!attribute [rw] tool
        #   @return [::Google::Cloud::Dialogflow::V2::Tool]
        #     Required. The tool to update.
        #     The name field of tool is to identify the tool to
        #     update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateToolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a tool.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the tool. Format:
        #     `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`.
        # @!attribute [rw] tool_key
        #   @return [::String]
        #     Required. A human readable short name of the tool, which should be unique
        #     within the project. It should only contain letters, numbers, and
        #     underscores, and it will be used by LLM to identify the tool.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. A human readable short name of the tool, to be shown on the UI.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A human readable description of the tool.
        # @!attribute [rw] action_confirmation_requirement
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::V2::Tool::ConfirmationRequirement}]
        #     Optional. Confirmation requirement for the actions. Each key is an action
        #     name in the action_schemas. If an action's confirmation requirement is
        #     unspecified (either the key is not present, or its value is
        #     CONFIRMATION_REQUIREMENT_UNSPECIFIED), the requirement is inferred from the
        #     action's method_type - confirmation is not required if and only if
        #     method_type is GET.
        # @!attribute [rw] extension_spec
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Dialogflow::V2::Tool::ExtensionTool]
        #     Vertex extension tool specification.
        #
        #     Note: The following fields are mutually exclusive: `extension_spec`, `function_spec`, `connector_spec`, `open_api_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] function_spec
        #   @return [::Google::Cloud::Dialogflow::V2::Tool::FunctionTool]
        #     Client side executed function specification.
        #
        #     Note: The following fields are mutually exclusive: `function_spec`, `extension_spec`, `connector_spec`, `open_api_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] connector_spec
        #   @return [::Google::Cloud::Dialogflow::V2::Tool::ConnectorTool]
        #     Integration connectors tool specification.
        #
        #     Note: The following fields are mutually exclusive: `connector_spec`, `extension_spec`, `function_spec`, `open_api_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] open_api_spec
        #   @return [::Google::Cloud::Dialogflow::V2::Tool::OpenApiTool]
        #     OpenAPI tool.
        #
        #     Note: The following fields are mutually exclusive: `open_api_spec`, `extension_spec`, `function_spec`, `connector_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this tool.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time of this tool.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. A read only boolean field reflecting Zone Separation
        #     status of the tool. If the field is absent, it means the status is unknown.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. A read only boolean field reflecting Zone Isolation status
        #     of the tool. If the field is absent, it means the status is unknown.
        class Tool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An ExtensionTool is a way to use Vertex Extensions as a tool.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The full name of the referenced vertex extension.
          #     Format:
          #     `projects/{project}/locations/{location}/extensions/{extension}`
          class ExtensionTool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A Function tool describes the functions to be invoked on the client side.
          # @!attribute [rw] input_schema
          #   @return [::Google::Protobuf::Struct]
          #     Optional. The JSON schema is encapsulated in a
          #     {::Google::Protobuf::Struct google.protobuf.Struct} to describe the input of
          #     the function. This input is a JSON object that contains the function's
          #     parameters as properties of the object.
          # @!attribute [rw] output_schema
          #   @return [::Google::Protobuf::Struct]
          #     Optional. The JSON schema is encapsulated in a
          #     {::Google::Protobuf::Struct google.protobuf.Struct} to describe the output
          #     of the function. This output is a JSON object that contains the
          #     function's parameters as properties of the object.
          # @!attribute [rw] method_type
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::MethodType]
          #     Optional. The method type of the function. If not specified, the default
          #     value is GET.
          class FunctionTool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An OpenAPI tool is a way to provide the Tool specifications in the Open API
          # schema format.
          # @!attribute [rw] text_schema
          #   @return [::String]
          #     Required. The OpenAPI schema specified as a text.
          # @!attribute [rw] authentication
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication]
          #     Optional. Authentication information required by the API.
          # @!attribute [rw] tls_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::TLSConfig]
          #     Optional. TLS configuration for the HTTPS verification.
          # @!attribute [rw] service_directory_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::ServiceDirectoryConfig]
          #     Optional. Service Directory configuration.
          class OpenApiTool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A ConnectorTool enabling using Integration Connectors Connections as tools.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The full resource name of the referenced Integration Connectors
          #     Connection. Format: 'projects/*/locations/*/connections/*'
          # @!attribute [rw] actions
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Tool::ConnectorTool::Action>]
          #     Required. Actions for the tool to use.
          class ConnectorTool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration of a Connection operation for the tool to use.
            # @!attribute [rw] connection_action_id
            #   @return [::String]
            #     ID of a Connection action for the tool to use.
            #
            #     Note: The following fields are mutually exclusive: `connection_action_id`, `entity_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] entity_operation
            #   @return [::Google::Cloud::Dialogflow::V2::Tool::ConnectorTool::Action::EntityOperation]
            #     Entity operation configuration for the tool to use.
            #
            #     Note: The following fields are mutually exclusive: `entity_operation`, `connection_action_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] input_fields
            #   @return [::Array<::String>]
            #     Optional. Entity fields to use as inputs for the operation.
            #     If no fields are specified, all fields of the Entity will be used.
            # @!attribute [rw] output_fields
            #   @return [::Array<::String>]
            #     Optional. Entity fields to return from the operation.
            #     If no fields are specified, all fields of the Entity will be returned.
            class Action
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Entity CRUD operation specification.
              # @!attribute [rw] entity_id
              #   @return [::String]
              #     Required. ID of the entity.
              # @!attribute [rw] operation
              #   @return [::Google::Cloud::Dialogflow::V2::Tool::ConnectorTool::Action::EntityOperation::OperationType]
              #     Required. Operation to perform on the entity.
              class EntityOperation
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The operation to perform on the entity.
                module OperationType
                  # Operation type unspecified. Invalid, ConnectorTool create/update
                  # will fail.
                  OPERATION_TYPE_UNSPECIFIED = 0

                  # List operation.
                  LIST = 1

                  # Get operation.
                  GET = 2

                  # Create operation.
                  CREATE = 3

                  # Update operation.
                  UPDATE = 4

                  # Delete operation.
                  DELETE = 5
                end
              end
            end
          end

          # Authentication information required for API calls
          # @!attribute [rw] api_key_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::ApiKeyConfig]
          #     Config for API key auth.
          #
          #     Note: The following fields are mutually exclusive: `api_key_config`, `oauth_config`, `service_agent_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] oauth_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::OAuthConfig]
          #     Config for OAuth.
          #
          #     Note: The following fields are mutually exclusive: `oauth_config`, `api_key_config`, `service_agent_auth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] service_agent_auth_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::ServiceAgentAuthConfig]
          #     Config for [Diglogflow service
          #     agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
          #     auth.
          #
          #     Note: The following fields are mutually exclusive: `service_agent_auth_config`, `api_key_config`, `oauth_config`, `bearer_token_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] bearer_token_config
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::BearerTokenConfig]
          #     Config for bearer token auth.
          #
          #     Note: The following fields are mutually exclusive: `bearer_token_config`, `api_key_config`, `oauth_config`, `service_agent_auth_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Authentication
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Config for authentication with API key.
            # @!attribute [rw] key_name
            #   @return [::String]
            #     Required. The parameter name or the header name of the API key.
            #     E.g., If the API request is "https://example.com/act?X-Api-Key=<API
            #     KEY>", "X-Api-Key" would be the parameter name.
            # @!attribute [rw] api_key
            #   @return [::String]
            #     Optional. The API key. If the `secret_version_for_api_key` field is
            #     set, this field will be ignored.
            # @!attribute [rw] secret_version_for_api_key
            #   @return [::String]
            #     Optional. The name of the SecretManager secret version resource storing
            #     the API key. If this field is set, the `api_key` field will be ignored.
            #     Format: `projects/{project}/secrets/{secret}/versions/{version}`
            # @!attribute [rw] request_location
            #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::RequestLocation]
            #     Required. Key location in the request.
            class ApiKeyConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Config for authentication with OAuth.
            # @!attribute [rw] oauth_grant_type
            #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::OAuthConfig::OauthGrantType]
            #     Required. OAuth grant types.
            # @!attribute [rw] client_id
            #   @return [::String]
            #     Required. The client ID from the OAuth provider.
            # @!attribute [rw] client_secret
            #   @return [::String]
            #     Optional. The client secret from the OAuth provider. If the
            #     `secret_version_for_client_secret` field is set, this field will be
            #     ignored.
            # @!attribute [rw] secret_version_for_client_secret
            #   @return [::String]
            #     Optional. The name of the SecretManager secret version resource storing
            #     the client secret. If this field is set, the `client_secret` field will
            #     be ignored. Format:
            #     `projects/{project}/secrets/{secret}/versions/{version}`
            # @!attribute [rw] token_endpoint
            #   @return [::String]
            #     Required. The token endpoint in the OAuth provider to exchange for an
            #     access token.
            # @!attribute [rw] scopes
            #   @return [::Array<::String>]
            #     Optional. The OAuth scopes to grant.
            class OAuthConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # OAuth grant types. Only [client credential
              # grant](https://oauth.net/2/grant-types/client-credentials) is
              # supported.
              module OauthGrantType
                # Default value. This value is unused.
                OAUTH_GRANT_TYPE_UNSPECIFIED = 0

                # Represents the [client credential
                # flow](https://oauth.net/2/grant-types/client-credentials).
                CLIENT_CREDENTIAL = 1
              end
            end

            # Config for auth using [Dialogflow service
            # agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
            # @!attribute [rw] service_agent_auth
            #   @return [::Google::Cloud::Dialogflow::V2::Tool::Authentication::ServiceAgentAuthConfig::ServiceAgentAuth]
            #     Optional. Indicate the auth token type generated from the [Diglogflow
            #     service
            #     agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
            #     The generated token is sent in the Authorization header.
            class ServiceAgentAuthConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Indicate the auth token type generated from the [Diaglogflow service
              # agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
              module ServiceAgentAuth
                # Service agent auth type unspecified. Default to ID_TOKEN.
                SERVICE_AGENT_AUTH_UNSPECIFIED = 0

                # Use [ID
                # token](https://cloud.google.com/docs/authentication/token-types#id)
                # generated from service agent. This can be used to access Cloud
                # Function and Cloud Run after you grant Invoker role to
                # `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
                ID_TOKEN = 1

                # Use [access
                # token](https://cloud.google.com/docs/authentication/token-types#access)
                # generated from service agent. This can be used to access other Google
                # Cloud APIs after you grant required roles to
                # `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
                ACCESS_TOKEN = 2
              end
            end

            # Config for authentication using bearer token.
            # @!attribute [rw] token
            #   @return [::String]
            #     Optional. The text token appended to the text `Bearer` to the request
            #     Authorization header.
            #     [Session parameters
            #     reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
            #     can be used to pass the token dynamically, e.g.
            #     `$session.params.parameter-id`.
            # @!attribute [rw] secret_version_for_token
            #   @return [::String]
            #     Optional. The name of the SecretManager secret version resource storing
            #     the Bearer token. If this field is set, the `token` field will be
            #     ignored. Format:
            #     `projects/{project}/secrets/{secret}/versions/{version}`
            class BearerTokenConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The location of the API key in the request.
            module RequestLocation
              # Default value. This value is unused.
              REQUEST_LOCATION_UNSPECIFIED = 0

              # Represents the key in http header.
              HEADER = 1

              # Represents the key in query string.
              QUERY_STRING = 2
            end
          end

          # The TLS configuration.
          # @!attribute [rw] ca_certs
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Tool::TLSConfig::CACert>]
          #     Required. Specifies a list of allowed custom CA certificates for HTTPS
          #     verification.
          class TLSConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The CA certificate.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Required. The name of the allowed custom CA certificates. This
            #     can be used to disambiguate the custom CA certificates.
            # @!attribute [rw] cert
            #   @return [::String]
            #     Required. The allowed custom CA certificates (in DER format) for
            #     HTTPS verification. This overrides the default SSL trust store. If this
            #     is empty or unspecified, Dialogflow will use Google's default trust
            #     store to verify certificates. N.B. Make sure the HTTPS server
            #     certificates are signed with "subject alt name". For instance a
            #     certificate can be self-signed using the following command,
            #     ```
            #        openssl x509 -req -days 200 -in example.com.csr \
            #          -signkey example.com.key \
            #          -out example.com.crt \
            #          -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
            #     ```
            class CACert
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Configuration for tools using Service Directory.
          # @!attribute [rw] service
          #   @return [::String]
          #     Required. The name of [Service
          #     Directory](https://cloud.google.com/service-directory) service.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
          #     `LocationID` of the service directory must be the same as the location
          #     of the tool.
          class ServiceDirectoryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dialogflow::V2::Tool::ConfirmationRequirement]
          class ActionConfirmationRequirementEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Types of confirmation requirement.
          module ConfirmationRequirement
            # Unspecified. Whether the action requires confirmation is inferred from
            # method_type.
            CONFIRMATION_REQUIREMENT_UNSPECIFIED = 0

            # Conformation is required.
            REQUIRED = 1

            # Conformation is not required.
            NOT_REQUIRED = 2
          end

          # The method type of the tool.
          module MethodType
            # Unspecified.
            METHOD_TYPE_UNSPECIFIED = 0

            # GET method.
            GET = 1

            # POST method.
            POST = 2

            # PUT method.
            PUT = 3

            # DELETE method.
            DELETE = 4

            # PATCH method.
            PATCH = 5
          end
        end
      end
    end
  end
end
