# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # The request message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#create_sip_trunk SipTrunks.CreateSipTrunk}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location to create a SIP trunk for.
        #     Format: `projects/<Project ID>/locations/<Location ID>`.
        # @!attribute [rw] sip_trunk
        #   @return [::Google::Cloud::Dialogflow::V2::SipTrunk]
        #     Required. The SIP trunk to create.
        class CreateSipTrunkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#delete_sip_trunk SipTrunks.DeleteSipTrunk}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SIP trunk to delete.
        #     Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
        #     ID>`.
        class DeleteSipTrunkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#list_sip_trunks SipTrunks.ListSipTrunks}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location to list SIP trunks from.
        #     Format: `projects/<Project ID>/locations/<Location ID>`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return in a single page. By
        #     default 100 and at most 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListSipTrunksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#list_sip_trunks SipTrunks.ListSipTrunks}.
        # @!attribute [rw] sip_trunks
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SipTrunk>]
        #     The list of SIP trunks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no
        #     more results in the list.
        class ListSipTrunksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#get_sip_trunk SipTrunks.GetSipTrunk}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SIP trunk to delete.
        #     Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
        #     ID>`.
        class GetSipTrunkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::SipTrunks::Client#update_sip_trunk SipTrunks.UpdateSipTrunk}.
        # @!attribute [rw] sip_trunk
        #   @return [::Google::Cloud::Dialogflow::V2::SipTrunk]
        #     Required. The SipTrunk to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The mask to control which fields get updated. If the mask is not
        #     present, all fields will be updated.
        class UpdateSipTrunkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SipTrunk is the resource that represents a SIP trunk to connect to Google
        # Telephony platform SIP trunking service.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The unique identifier of the SIP trunk.
        #     Format: `projects/<Project ID>/locations/<Location ID>/sipTrunks/<SipTrunk
        #     ID>`.
        # @!attribute [rw] expected_hostname
        #   @return [::Array<::String>]
        #     Required. The expected hostnames in the peer certificate from partner that
        #     is used for TLS authentication.
        # @!attribute [r] connections
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Connection>]
        #     Output only. Connections of the SIP trunk.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human readable alias for this trunk.
        class SipTrunk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a connection for SIP Trunk.
        # @!attribute [r] connection_id
        #   @return [::String]
        #     Output only. The unique identifier of the SIP Trunk connection.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dialogflow::V2::Connection::State]
        #     Output only. State of the connection.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the connection status changed.
        # @!attribute [r] error_details
        #   @return [::Google::Cloud::Dialogflow::V2::Connection::ErrorDetails]
        #     Output only. The error details for the connection. Only populated when
        #     authentication errors occur.
        class Connection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The error details of Sip Trunk connection authentication.
          # @!attribute [r] certificate_state
          #   @return [::Google::Cloud::Dialogflow::V2::Connection::CertificateState]
          #     Output only. The status of the certificate authentication.
          # @!attribute [rw] error_message
          #   @return [::String]
          #     The error message provided from SIP trunking auth service
          class ErrorDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of Sip Trunk connection.
          module State
            # SIP Trunk connection state is Not specified.
            STATE_UNSPECIFIED = 0

            # SIP Trunk connection is connected.
            CONNECTED = 1

            # SIP Trunk connection is disconnected.
            DISCONNECTED = 2

            # SIP Trunk connection has authentication error.
            AUTHENTICATION_FAILED = 3

            # SIP Trunk connection is keepalive.
            KEEPALIVE = 4
          end

          # The state of Sip Trunk certificate authentication.
          module CertificateState
            # Certificate state is not specified.
            CERTIFICATE_STATE_UNSPECIFIED = 0

            # Certificate is valid.
            CERTIFICATE_VALID = 1

            # Catch all for any error not specified.
            CERTIFICATE_INVALID = 2

            # Certificate leaf node has expired.
            CERTIFICATE_EXPIRED = 3

            # There is no hostname defined to authenticate in SipTrunkingServer.
            CERTIFICATE_HOSTNAME_NOT_FOUND = 4

            # No path found from the leaf certificate to any root.
            CERTIFICATE_UNAUTHENTICATED = 5

            # Trust store does not exist.
            CERTIFICATE_TRUST_STORE_NOT_FOUND = 6

            # Hostname has invalid format.
            CERTIFICATE_HOSTNAME_INVALID_FORMAT = 7

            # Certificate has exhausted its quota.
            CERTIFICATE_QUOTA_EXCEEDED = 8
          end
        end
      end
    end
  end
end
