# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Represents a conversation participant (human agent, virtual agent, end-user).
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The unique identifier of this participant.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] role
        #   @return [::Google::Cloud::Dialogflow::V2::Participant::Role]
        #     Immutable. The role this participant plays in the conversation. This field
        #     must be set during participant creation and is then immutable.
        # @!attribute [rw] sip_recording_media_label
        #   @return [::String]
        #     Optional. Label applied to streams representing this participant in SIPREC
        #     XML metadata and SDP. This is used to assign transcriptions from that
        #     media stream to this participant. This field can be updated.
        # @!attribute [rw] obfuscated_external_user_id
        #   @return [::String]
        #     Optional. Obfuscated user id that should be associated with the created
        #     participant.
        #
        #     You can specify a user id as follows:
        #
        #     1. If you set this field in
        #        {::Google::Cloud::Dialogflow::V2::CreateParticipantRequest#participant CreateParticipantRequest}
        #        or
        #        {::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest#participant UpdateParticipantRequest},
        #        Dialogflow adds the obfuscated user id with the participant.
        #
        #     2. If you set this field in
        #        {::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest#participant AnalyzeContent}
        #        or
        #        {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#participant StreamingAnalyzeContent},
        #        Dialogflow will update
        #        {::Google::Cloud::Dialogflow::V2::Participant#obfuscated_external_user_id Participant.obfuscated_external_user_id}.
        #
        #     Dialogflow returns an error if you try to add a user id for a
        #     non-{::Google::Cloud::Dialogflow::V2::Participant::Role::END_USER END_USER}
        #     participant.
        #
        #     Dialogflow uses this user id for billing and measurement purposes. For
        #     example, Dialogflow determines whether a user in one conversation returned
        #     in a later conversation.
        #
        #     Note:
        #
        #     * Please never pass raw user ids to Dialogflow. Always obfuscate your user
        #       id first.
        #     * Dialogflow only accepts a UTF-8 encoded string, e.g., a hex digest of a
        #       hash function like SHA-512.
        #     * The length of the user id must be <= 256 characters.
        # @!attribute [rw] documents_metadata_filters
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Key-value filters on the metadata of documents returned by
        #     article suggestion. If specified, article suggestion only returns suggested
        #     documents that match all filters in their
        #     {::Google::Cloud::Dialogflow::V2::Document#metadata Document.metadata}. Multiple
        #     values for a metadata key should be concatenated by comma. For example,
        #     filters to match all documents that have 'US' or 'CA' in their market
        #     metadata values and 'agent' in their user metadata values will be
        #     ```
        #     documents_metadata_filters {
        #       key: "market"
        #       value: "US,CA"
        #     }
        #     documents_metadata_filters {
        #       key: "user"
        #       value: "agent"
        #     }
        #     ```
        # @!attribute [rw] agent_desktop_source
        #   @return [::Google::Cloud::Dialogflow::V2::Participant::AgentDesktopSource]
        #     Optional. For tracking the utilization of prebuilt Agent Assist integration
        #     modules. This field is only inscope for Integration type that include UI
        #     Modules, Backend Modules, and Agent Desktop connector, it is out of scope
        #     for CCaaS and Direct Integration.
        #     For each human agent, prebuilt UI Modules needs to trigger the
        #     UpdateParticipant API to update this field. Both
        #     {::Google::Cloud::Dialogflow::V2::CreateParticipantRequest#participant CreateParticipantRequest}
        #     and
        #     {::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest#participant UpdateParticipantRequest}
        #     will be supported.
        class Participant
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DocumentsMetadataFiltersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of the roles a participant can play in a conversation.
          module Role
            # Participant role not set.
            ROLE_UNSPECIFIED = 0

            # Participant is a human agent.
            HUMAN_AGENT = 1

            # Participant is an automated agent, such as a Dialogflow agent.
            AUTOMATED_AGENT = 2

            # Participant is an end user that has called or chatted with
            # Dialogflow services.
            END_USER = 3
          end

          # Enumeration of the Agent Desktop Source when using prebuilt Agent
          # Assist integration modules.
          module AgentDesktopSource
            # Agent Desktop Source is not specified.
            AGENT_DESKTOP_SOURCE_UNSPECIFIED = 0

            # Agent Desktop Source is Live Person.
            LIVE_PERSON = 1

            # Agent Desktop Source is Genesys Cloud.
            GENESYS_CLOUD = 2

            # Agent Desktop Source is Twilio.
            TWILIO = 3

            # Agent Desktop Source is Salesforce.
            SALESFORCE = 4

            # UI Modules are in use but the desktop is either not currently released or
            # setting this field to the applicable desktop.
            OTHER = 8
          end
        end

        # Represents a message posted into a conversation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The unique identifier of the message.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] content
        #   @return [::String]
        #     Required. The message content.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The message language.
        #     This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
        #     language tag. Example: "en-US".
        # @!attribute [r] participant
        #   @return [::String]
        #     Output only. The participant that sends this message.
        # @!attribute [r] participant_role
        #   @return [::Google::Cloud::Dialogflow::V2::Participant::Role]
        #     Output only. The role of the participant.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the message was created in Contact Center AI.
        # @!attribute [rw] send_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time when the message was sent. For voice messages, this is
        #     the time when an utterance started.
        # @!attribute [r] message_annotation
        #   @return [::Google::Cloud::Dialogflow::V2::MessageAnnotation]
        #     Output only. The annotation for the message.
        # @!attribute [r] sentiment_analysis
        #   @return [::Google::Cloud::Dialogflow::V2::SentimentAnalysisResult]
        #     Output only. The sentiment analysis result for the message.
        class Message
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#create_participant Participants.CreateParticipant}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource identifier of the conversation adding the participant.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] participant
        #   @return [::Google::Cloud::Dialogflow::V2::Participant]
        #     Required. The participant to create.
        class CreateParticipantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#get_participant Participants.GetParticipant}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the participant. Format:
        #     `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
        #     ID>/participants/<Participant ID>`.
        class GetParticipantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#list_participants Participants.ListParticipants}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The conversation to list all participants from.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return in a single page. By
        #     default 100 and at most 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListParticipantsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#list_participants Participants.ListParticipants}.
        # @!attribute [rw] participants
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Participant>]
        #     The list of participants. There is a maximum number of items
        #     returned based on the page_size field in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results or empty if there are no
        #     more results in the list.
        class ListParticipantsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#update_participant Participants.UpdateParticipant}.
        # @!attribute [rw] participant
        #   @return [::Google::Cloud::Dialogflow::V2::Participant]
        #     Required. The participant to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The mask to specify which fields to update.
        class UpdateParticipantRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#analyze_content Participants.AnalyzeContent}.
        # @!attribute [rw] participant
        #   @return [::String]
        #     Required. The name of the participant this text comes from.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] text_input
        #   @return [::Google::Cloud::Dialogflow::V2::TextInput]
        #     The natural language text to be processed.
        #
        #     Note: The following fields are mutually exclusive: `text_input`, `audio_input`, `event_input`, `suggestion_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] audio_input
        #   @return [::Google::Cloud::Dialogflow::V2::AudioInput]
        #     The natural language speech audio to be processed.
        #
        #     Note: The following fields are mutually exclusive: `audio_input`, `text_input`, `event_input`, `suggestion_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] event_input
        #   @return [::Google::Cloud::Dialogflow::V2::EventInput]
        #     An input event to send to Dialogflow.
        #
        #     Note: The following fields are mutually exclusive: `event_input`, `text_input`, `audio_input`, `suggestion_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggestion_input
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestionInput]
        #     An input representing the selection of a suggestion.
        #
        #     Note: The following fields are mutually exclusive: `suggestion_input`, `text_input`, `audio_input`, `event_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] reply_audio_config
        #   @return [::Google::Cloud::Dialogflow::V2::OutputAudioConfig]
        #     Speech synthesis configuration.
        #     The speech synthesis settings for a virtual agent that may be configured
        #     for the associated conversation profile are not used when calling
        #     AnalyzeContent. If this configuration is not supplied, speech synthesis
        #     is disabled.
        # @!attribute [rw] query_params
        #   @return [::Google::Cloud::Dialogflow::V2::QueryParameters]
        #     Parameters for a Dialogflow virtual-agent query.
        # @!attribute [rw] assist_query_params
        #   @return [::Google::Cloud::Dialogflow::V2::AssistQueryParameters]
        #     Parameters for a human assist query.
        # @!attribute [rw] cx_parameters
        #   @return [::Google::Protobuf::Struct]
        #     Additional parameters to be put into Dialogflow CX session parameters. To
        #     remove a parameter from the session, clients should explicitly set the
        #     parameter value to null.
        #
        #     Note: this field should only be used if you are connecting to a Dialogflow
        #     CX agent.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A unique identifier for this request. Restricted to 36 ASCII characters.
        #     A random UUID is recommended.
        #     This request is only idempotent if a `request_id` is provided.
        class AnalyzeContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message in the response that indicates the parameters of DTMF.
        # @!attribute [rw] accepts_dtmf_input
        #   @return [::Boolean]
        #     Indicates whether DTMF input can be handled in the next request.
        class DtmfParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#analyze_content Participants.AnalyzeContent}.
        # @!attribute [rw] reply_text
        #   @return [::String]
        #     The output text content.
        #     This field is set if the automated agent responded with text to show to
        #     the user.
        # @!attribute [rw] reply_audio
        #   @return [::Google::Cloud::Dialogflow::V2::OutputAudio]
        #     The audio data bytes encoded as specified in the request.
        #     This field is set if:
        #
        #      - `reply_audio_config` was specified in the request, or
        #      - The automated agent responded with audio to play to the user. In such
        #        case, `reply_audio.config` contains settings used to synthesize the
        #        speech.
        #
        #     In some scenarios, multiple output audio fields may be present in the
        #     response structure. In these cases, only the top-most-level audio output
        #     has content.
        # @!attribute [rw] automated_agent_reply
        #   @return [::Google::Cloud::Dialogflow::V2::AutomatedAgentReply]
        #     Only set if a Dialogflow automated agent has responded.
        #     Note that in [AutomatedAgentReply.DetectIntentResponse][],
        #     [Sessions.DetectIntentResponse.output_audio][]
        #     and [Sessions.DetectIntentResponse.output_audio_config][]
        #     are always empty, use
        #     {::Google::Cloud::Dialogflow::V2::AnalyzeContentResponse#reply_audio reply_audio}
        #     instead.
        # @!attribute [rw] message
        #   @return [::Google::Cloud::Dialogflow::V2::Message]
        #     Message analyzed by CCAI.
        # @!attribute [rw] human_agent_suggestion_results
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SuggestionResult>]
        #     The suggestions for most recent human agent. The order is the same as
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig::SuggestionConfig#feature_configs HumanAgentAssistantConfig.SuggestionConfig.feature_configs}
        #     of
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig#human_agent_suggestion_config HumanAgentAssistantConfig.human_agent_suggestion_config}.
        #
        #     Note that any failure of Agent Assist features will not lead to the overall
        #     failure of an AnalyzeContent API call. Instead, the features will
        #     fail silently with the error field set in the corresponding
        #     SuggestionResult.
        # @!attribute [rw] end_user_suggestion_results
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SuggestionResult>]
        #     The suggestions for end user. The order is the same as
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig::SuggestionConfig#feature_configs HumanAgentAssistantConfig.SuggestionConfig.feature_configs}
        #     of
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig#end_user_suggestion_config HumanAgentAssistantConfig.end_user_suggestion_config}.
        #
        #     Same as human_agent_suggestion_results, any failure of Agent Assist
        #     features will not lead to the overall failure of an AnalyzeContent API
        #     call. Instead, the features will fail silently with the error field set in
        #     the corresponding SuggestionResult.
        # @!attribute [rw] dtmf_parameters
        #   @return [::Google::Cloud::Dialogflow::V2::DtmfParameters]
        #     Indicates the parameters of DTMF.
        class AnalyzeContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The top-level message sent by the client to the
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#streaming_analyze_content Participants.StreamingAnalyzeContent}
        # method.
        #
        # Multiple request messages should be sent in order:
        #
        # 1.  The first message must contain
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#participant participant},
        #     [config][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest.config]
        #     and optionally
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#query_params query_params}.
        #     If you want to receive an audio response, it should also contain
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#reply_audio_config reply_audio_config}.
        #     The message must not contain
        #     [input][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest.input].
        #
        # 2.  If
        # [config][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest.config] in
        # the first message
        #     was set to
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#audio_config audio_config},
        #     all subsequent messages must contain
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#input_audio input_audio}
        #     to continue with Speech recognition. However, note that:
        #
        #     * Dialogflow will bill you for the audio so far.
        #     * Dialogflow discards all Speech recognition results in favor of the
        #       text input.
        #
        #  3. If
        #  [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest.config]
        #  in the first message was set
        #    to
        #    {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#text_config StreamingAnalyzeContentRequest.text_config},
        #    then the second message must contain only
        #    {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentRequest#input_text input_text}.
        #    Moreover, you must not send more than two messages.
        #
        #  After you sent all input, you must half-close or abort the request stream.
        # @!attribute [rw] participant
        #   @return [::String]
        #     Required. The name of the participant this text comes from.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] audio_config
        #   @return [::Google::Cloud::Dialogflow::V2::InputAudioConfig]
        #     Instructs the speech recognizer how to process the speech audio.
        #
        #     Note: The following fields are mutually exclusive: `audio_config`, `text_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_config
        #   @return [::Google::Cloud::Dialogflow::V2::InputTextConfig]
        #     The natural language text to be processed.
        #
        #     Note: The following fields are mutually exclusive: `text_config`, `audio_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] reply_audio_config
        #   @return [::Google::Cloud::Dialogflow::V2::OutputAudioConfig]
        #     Speech synthesis configuration.
        #     The speech synthesis settings for a virtual agent that may be configured
        #     for the associated conversation profile are not used when calling
        #     StreamingAnalyzeContent. If this configuration is not supplied, speech
        #     synthesis is disabled.
        # @!attribute [rw] input_audio
        #   @return [::String]
        #     The input audio content to be recognized. Must be sent if `audio_config`
        #     is set in the first message. The complete audio over all streaming
        #     messages must not exceed 1 minute.
        #
        #     Note: The following fields are mutually exclusive: `input_audio`, `input_text`, `input_dtmf`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_text
        #   @return [::String]
        #     The UTF-8 encoded natural language text to be processed. Must be sent if
        #     `text_config` is set in the first message. Text length must not exceed
        #     256 bytes for virtual agent interactions. The `input_text` field can be
        #     only sent once, and would cancel the speech recognition if any ongoing.
        #
        #     Note: The following fields are mutually exclusive: `input_text`, `input_audio`, `input_dtmf`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_dtmf
        #   @return [::Google::Cloud::Dialogflow::V2::TelephonyDtmfEvents]
        #     The DTMF digits used to invoke intent and fill in parameter value.
        #
        #     This input is ignored if the previous response indicated that DTMF input
        #     is not accepted.
        #
        #     Note: The following fields are mutually exclusive: `input_dtmf`, `input_audio`, `input_text`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] query_params
        #   @return [::Google::Cloud::Dialogflow::V2::QueryParameters]
        #     Parameters for a Dialogflow virtual-agent query.
        # @!attribute [rw] assist_query_params
        #   @return [::Google::Cloud::Dialogflow::V2::AssistQueryParameters]
        #     Parameters for a human assist query.
        # @!attribute [rw] cx_parameters
        #   @return [::Google::Protobuf::Struct]
        #     Additional parameters to be put into Dialogflow CX session parameters. To
        #     remove a parameter from the session, clients should explicitly set the
        #     parameter value to null.
        #
        #     Note: this field should only be used if you are connecting to a Dialogflow
        #     CX agent.
        # @!attribute [rw] enable_extended_streaming
        #   @return [::Boolean]
        #     Optional. Enable full bidirectional streaming. You can keep streaming the
        #     audio until timeout, and there's no need to half close the stream to get
        #     the response.
        #
        #     Restrictions:
        #
        #     - Timeout: 3 mins.
        #     - Audio Encoding: only supports
        #     {::Google::Cloud::Dialogflow::V2::AudioEncoding::AUDIO_ENCODING_LINEAR_16 AudioEncoding.AUDIO_ENCODING_LINEAR_16}
        #     and
        #     {::Google::Cloud::Dialogflow::V2::AudioEncoding::AUDIO_ENCODING_MULAW AudioEncoding.AUDIO_ENCODING_MULAW}
        #     - Lifecycle: conversation should be in `Assist Stage`, go to
        #       {::Google::Cloud::Dialogflow::V2::Conversations::Client#create_conversation Conversations.CreateConversation}
        #       for more information.
        #
        #     InvalidArgument Error will be returned if the one of restriction checks
        #     failed.
        #
        #     You can find more details in
        #     https://cloud.google.com/agent-assist/docs/extended-streaming
        # @!attribute [rw] enable_partial_automated_agent_reply
        #   @return [::Boolean]
        #     Optional. Enable partial responses from Dialogflow CX agent. If this flag
        #     is not enabled, response stream still contains only one final response even
        #     if some `Fulfillment`s in Dialogflow CX agent have been configured to
        #     return partial responses.
        # @!attribute [rw] enable_debugging_info
        #   @return [::Boolean]
        #     If true, `StreamingAnalyzeContentResponse.debugging_info` will get
        #     populated.
        class StreamingAnalyzeContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The top-level message returned from the `StreamingAnalyzeContent` method.
        #
        # Multiple response messages can be returned in order:
        #
        # 1.  If the input was set to streaming audio, the first one or more messages
        #     contain `recognition_result`. Each `recognition_result` represents a more
        #     complete transcript of what the user said. The last `recognition_result`
        #     has `is_final` set to `true`.
        #
        # 2.  In virtual agent stage: if `enable_partial_automated_agent_reply` is
        #     true, the following N (currently 1 <= N <= 4) messages
        #     contain `automated_agent_reply` and optionally `reply_audio`
        #     returned by the virtual agent. The first (N-1)
        #     `automated_agent_reply`s will have `automated_agent_reply_type` set to
        #     `PARTIAL`. The last `automated_agent_reply` has
        #     `automated_agent_reply_type` set to `FINAL`.
        #     If `enable_partial_automated_agent_reply` is not enabled, response stream
        #     only contains the final reply.
        #
        #     In human assist stage: the following N (N >= 1) messages contain
        #     `human_agent_suggestion_results`, `end_user_suggestion_results` or
        #     `message`.
        # @!attribute [rw] recognition_result
        #   @return [::Google::Cloud::Dialogflow::V2::StreamingRecognitionResult]
        #     The result of speech recognition.
        # @!attribute [rw] reply_text
        #   @return [::String]
        #     The output text content.
        #     This field is set if an automated agent responded with a text for the user.
        # @!attribute [rw] reply_audio
        #   @return [::Google::Cloud::Dialogflow::V2::OutputAudio]
        #     The audio data bytes encoded as specified in the request.
        #     This field is set if:
        #
        #      - The `reply_audio_config` field is specified in the request.
        #      - The automated agent, which this output comes from, responded with audio.
        #        In such case, the `reply_audio.config` field contains settings used to
        #        synthesize the speech.
        #
        #     In some scenarios, multiple output audio fields may be present in the
        #     response structure. In these cases, only the top-most-level audio output
        #     has content.
        # @!attribute [rw] automated_agent_reply
        #   @return [::Google::Cloud::Dialogflow::V2::AutomatedAgentReply]
        #     Note that in [AutomatedAgentReply.DetectIntentResponse][],
        #     [Sessions.DetectIntentResponse.output_audio][]
        #     and [Sessions.DetectIntentResponse.output_audio_config][]
        #     are always empty, use
        #     {::Google::Cloud::Dialogflow::V2::StreamingAnalyzeContentResponse#reply_audio reply_audio}
        #     instead.
        # @!attribute [rw] message
        #   @return [::Google::Cloud::Dialogflow::V2::Message]
        #     Message analyzed by CCAI.
        # @!attribute [rw] human_agent_suggestion_results
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SuggestionResult>]
        #     The suggestions for most recent human agent. The order is the same as
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig::SuggestionConfig#feature_configs HumanAgentAssistantConfig.SuggestionConfig.feature_configs}
        #     of
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig#human_agent_suggestion_config HumanAgentAssistantConfig.human_agent_suggestion_config}.
        # @!attribute [rw] end_user_suggestion_results
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SuggestionResult>]
        #     The suggestions for end user. The order is the same as
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig::SuggestionConfig#feature_configs HumanAgentAssistantConfig.SuggestionConfig.feature_configs}
        #     of
        #     {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantConfig#end_user_suggestion_config HumanAgentAssistantConfig.end_user_suggestion_config}.
        # @!attribute [rw] dtmf_parameters
        #   @return [::Google::Cloud::Dialogflow::V2::DtmfParameters]
        #     Indicates the parameters of DTMF.
        # @!attribute [rw] debugging_info
        #   @return [::Google::Cloud::Dialogflow::V2::CloudConversationDebuggingInfo]
        #     Debugging info that would get populated when
        #     `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
        # @!attribute [rw] speech_model
        #   @return [::String]
        #     The name of the actual Cloud speech model used for speech recognition.
        class StreamingAnalyzeContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_articles Participants.SuggestArticles}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the participant to fetch suggestion for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message to compile suggestion
        #     for. If empty, it will be the latest message of the conversation.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Optional. Max number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest#latest_message latest_message}
        #     to use as context when compiling the suggestion. By default 20 and at
        #     most 50.
        # @!attribute [rw] assist_query_params
        #   @return [::Google::Cloud::Dialogflow::V2::AssistQueryParameters]
        #     Parameters for a human assist query.
        class SuggestArticlesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_articles Participants.SuggestArticles}.
        # @!attribute [rw] article_answers
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::ArticleAnswer>]
        #     Articles ordered by score in descending order.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used to compile
        #     suggestion for.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestArticlesResponse#latest_message latest_message}
        #     to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest#context_size SuggestArticlesRequest.context_size}
        #     field in the request if there aren't that many messages in the
        #     conversation.
        class SuggestArticlesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_faq_answers Participants.SuggestFaqAnswers}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the participant to fetch suggestion for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message to compile suggestion
        #     for. If empty, it will be the latest message of the conversation.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Optional. Max number of messages prior to and including
        #     [latest_message] to use as context when compiling the
        #     suggestion. By default 20 and at most 50.
        # @!attribute [rw] assist_query_params
        #   @return [::Google::Cloud::Dialogflow::V2::AssistQueryParameters]
        #     Parameters for a human assist query.
        class SuggestFaqAnswersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_faq_answers Participants.SuggestFaqAnswers}.
        # @!attribute [rw] faq_answers
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::FaqAnswer>]
        #     Answers extracted from FAQ documents.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used to compile
        #     suggestion for.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse#latest_message latest_message}
        #     to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest#context_size SuggestFaqAnswersRequest.context_size}
        #     field in the request if there aren't that many messages in the
        #     conversation.
        class SuggestFaqAnswersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_suggestions Conversations.GenerateSuggestions}.
        # @!attribute [rw] generator_suggestion_answers
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::GenerateSuggestionsResponse::GeneratorSuggestionAnswer>]
        #     The answers generated for the conversation based on context.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used as context for
        #     compiling suggestion.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        class GenerateSuggestionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A GeneratorSuggestion answer.
          # @!attribute [rw] generator_suggestion
          #   @return [::Google::Cloud::Dialogflow::V2::GeneratorSuggestion]
          #     Suggestion details.
          # @!attribute [rw] source_generator
          #   @return [::String]
          #     The name of the generator used to generate this suggestion. Format:
          #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator
          #     ID>`.
          # @!attribute [rw] answer_record
          #   @return [::String]
          #     Answer record that uniquely identifies the suggestion. This can be used
          #     to provide suggestion feedback.
          class GeneratorSuggestionAnswer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_smart_replies Participants.SuggestSmartReplies}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the participant to fetch suggestion for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] current_text_input
        #   @return [::Google::Cloud::Dialogflow::V2::TextInput]
        #     The current natural language text segment to compile suggestion
        #     for. This provides a way for user to get follow up smart reply suggestion
        #     after a smart reply selection, without sending a text message.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message to compile suggestion
        #     for. If empty, it will be the latest message of the conversation.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Max number of messages prior to and including
        #     [latest_message] to use as context when compiling the
        #     suggestion. By default 20 and at most 50.
        class SuggestSmartRepliesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_smart_replies Participants.SuggestSmartReplies}.
        # @!attribute [r] smart_reply_answers
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SmartReplyAnswer>]
        #     Output only. Multiple reply options provided by smart reply service. The
        #     order is based on the rank of the model prediction.
        #     The maximum number of the returned replies is set in SmartReplyConfig.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used to compile
        #     suggestion for.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse#latest_message latest_message}
        #     to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest#context_size SuggestSmartRepliesRequest.context_size}
        #     field in the request if there aren't that many messages in the
        #     conversation.
        class SuggestSmartRepliesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the natural language speech audio to be processed.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dialogflow::V2::InputAudioConfig]
        #     Required. Instructs the speech recognizer how to process the speech audio.
        # @!attribute [rw] audio
        #   @return [::String]
        #     Required. The natural language speech audio to be processed.
        #     A single request can contain up to 2 minutes of speech audio data.
        #     The transcribed text cannot contain more than 256 bytes for virtual agent
        #     interactions.
        class AudioInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the natural language speech audio to be played to the end user.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dialogflow::V2::OutputAudioConfig]
        #     Instructs the speech synthesizer how to generate the speech
        #     audio.
        # @!attribute [rw] audio
        #   @return [::String]
        #     The natural language speech audio.
        class OutputAudio
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a response from an automated agent.
        # @!attribute [rw] detect_intent_response
        #   @return [::Google::Cloud::Dialogflow::V2::DetectIntentResponse]
        #     Response of the Dialogflow
        #     {::Google::Cloud::Dialogflow::V2::Sessions::Client#detect_intent Sessions.DetectIntent}
        #     call.
        # @!attribute [rw] automated_agent_reply_type
        #   @return [::Google::Cloud::Dialogflow::V2::AutomatedAgentReply::AutomatedAgentReplyType]
        #     AutomatedAgentReply type.
        # @!attribute [rw] allow_cancellation
        #   @return [::Boolean]
        #     Indicates whether the partial automated agent reply is interruptible when a
        #     later reply message arrives. e.g. if the agent specified some music as
        #     partial response, it can be cancelled.
        # @!attribute [rw] cx_current_page
        #   @return [::String]
        #     The unique identifier of the current Dialogflow CX conversation page.
        #     Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
        #     ID>/flows/<Flow ID>/pages/<Page ID>`.
        class AutomatedAgentReply
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents different automated agent reply types.
          module AutomatedAgentReplyType
            # Not specified. This should never happen.
            AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED = 0

            # Partial reply. e.g. Aggregated responses in a `Fulfillment` that enables
            # `return_partial_response` can be returned as partial reply.
            # WARNING: partial reply is not eligible for barge-in.
            PARTIAL = 1

            # Final reply.
            FINAL = 2
          end
        end

        # Represents article answer.
        # @!attribute [rw] title
        #   @return [::String]
        #     The article title.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The article URI.
        # @!attribute [rw] snippets
        #   @return [::Array<::String>]
        #     Article snippets.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     Article match confidence.
        #     The system's confidence score that this article is a good match for this
        #     conversation, as a value from 0.0 (completely uncertain) to 1.0
        #     (completely certain).
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map that contains metadata about the answer and the
        #     document from which it originates.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of answer record, in the format of
        #     "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
        #     ID>"
        class ArticleAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents answer from "frequently asked questions".
        # @!attribute [rw] answer
        #   @return [::String]
        #     The piece of text from the `source` knowledge base document.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     The system's confidence score that this Knowledge answer is a good match
        #     for this conversational query, range from 0.0 (completely uncertain)
        #     to 1.0 (completely certain).
        # @!attribute [rw] question
        #   @return [::String]
        #     The corresponding FAQ question.
        # @!attribute [rw] source
        #   @return [::String]
        #     Indicates which Knowledge Document this answer was extracted
        #     from.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/agent/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map that contains metadata about the answer and the
        #     document from which it originates.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of answer record, in the format of
        #     "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
        #     ID>"
        class FaqAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a smart reply answer.
        # @!attribute [rw] reply
        #   @return [::String]
        #     The content of the reply.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     Smart reply confidence.
        #     The system's confidence score that this reply is a good match for
        #     this conversation, as a value from 0.0 (completely uncertain) to 1.0
        #     (completely certain).
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of answer record, in the format of
        #     "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
        #     ID>"
        class SmartReplyAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an intent suggestion.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the intent.
        # @!attribute [rw] intent_v2
        #   @return [::String]
        #     The unique identifier of this
        #     {::Google::Cloud::Dialogflow::V2::Intent intent}. Format: `projects/<Project
        #     ID>/locations/<Location ID>/agent/intents/<Intent ID>`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Human readable description for better understanding an intent like its
        #     scope, content, result etc. Maximum character limit: 140 characters.
        class IntentSuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dialogflow assist answer.
        # @!attribute [rw] query_result
        #   @return [::Google::Cloud::Dialogflow::V2::QueryResult]
        #     Result from v2 agent.
        #
        #     Note: The following fields are mutually exclusive: `query_result`, `intent_suggestion`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] intent_suggestion
        #   @return [::Google::Cloud::Dialogflow::V2::IntentSuggestion]
        #     An intent suggestion generated from conversation.
        #
        #     Note: The following fields are mutually exclusive: `intent_suggestion`, `query_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of answer record, in the format of
        #     "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
        #     ID>"
        class DialogflowAssistAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One response of different type of suggestion response which is used in
        # the response of
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#analyze_content Participants.AnalyzeContent}
        # and
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#analyze_content Participants.AnalyzeContent},
        # as well as
        # {::Google::Cloud::Dialogflow::V2::HumanAgentAssistantEvent HumanAgentAssistantEvent}.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Error status if the request failed.
        #
        #     Note: The following fields are mutually exclusive: `error`, `suggest_articles_response`, `suggest_knowledge_assist_response`, `suggest_faq_answers_response`, `suggest_smart_replies_response`, `generate_suggestions_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggest_articles_response
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestArticlesResponse]
        #     SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
        #
        #     Note: The following fields are mutually exclusive: `suggest_articles_response`, `error`, `suggest_knowledge_assist_response`, `suggest_faq_answers_response`, `suggest_smart_replies_response`, `generate_suggestions_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggest_knowledge_assist_response
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse]
        #     SuggestKnowledgeAssistResponse if request is for KNOWLEDGE_ASSIST.
        #
        #     Note: The following fields are mutually exclusive: `suggest_knowledge_assist_response`, `error`, `suggest_articles_response`, `suggest_faq_answers_response`, `suggest_smart_replies_response`, `generate_suggestions_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggest_faq_answers_response
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse]
        #     SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
        #
        #     Note: The following fields are mutually exclusive: `suggest_faq_answers_response`, `error`, `suggest_articles_response`, `suggest_knowledge_assist_response`, `suggest_smart_replies_response`, `generate_suggestions_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] suggest_smart_replies_response
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse]
        #     SuggestSmartRepliesResponse if request is for SMART_REPLY.
        #
        #     Note: The following fields are mutually exclusive: `suggest_smart_replies_response`, `error`, `suggest_articles_response`, `suggest_knowledge_assist_response`, `suggest_faq_answers_response`, `generate_suggestions_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generate_suggestions_response
        #   @return [::Google::Cloud::Dialogflow::V2::GenerateSuggestionsResponse]
        #     Suggestions generated using generators triggered by customer or agent
        #     messages.
        #
        #     Note: The following fields are mutually exclusive: `generate_suggestions_response`, `error`, `suggest_articles_response`, `suggest_knowledge_assist_response`, `suggest_faq_answers_response`, `suggest_smart_replies_response`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SuggestionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines the language used in the input text.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Required. The language of this conversational query. See [Language
        #     Support](https://cloud.google.com/dialogflow/docs/reference/language)
        #     for a list of the currently supported language codes.
        class InputTextConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a part of a message possibly annotated with an entity. The part
        # can be an entity or purely a part of the message between two entities or
        # message start/end.
        # @!attribute [rw] text
        #   @return [::String]
        #     A part of a message possibly annotated with an entity.
        # @!attribute [rw] entity_type
        #   @return [::String]
        #     The [Dialogflow system entity
        #     type](https://cloud.google.com/dialogflow/docs/reference/system-entities)
        #     of this message part. If this is empty, Dialogflow could not annotate the
        #     phrase part with a system entity.
        # @!attribute [rw] formatted_value
        #   @return [::Google::Protobuf::Value]
        #     The [Dialogflow system entity formatted value
        #     ](https://cloud.google.com/dialogflow/docs/reference/system-entities) of
        #     this message part. For example for a system entity of type
        #     `@sys.unit-currency`, this may contain:
        #     <pre>
        #     {
        #       "amount": 5,
        #       "currency": "USD"
        #     }
        #     </pre>
        class AnnotatedMessagePart
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the result of annotation for the message.
        # @!attribute [rw] parts
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::AnnotatedMessagePart>]
        #     The collection of annotated message parts ordered by their
        #     position in the message. You can recover the annotated message by
        #     concatenating [AnnotatedMessagePart.text].
        # @!attribute [rw] contain_entities
        #   @return [::Boolean]
        #     Indicates whether the text message contains entities.
        class MessageAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the action to take for a tool call that requires confirmation.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     Required. Format: `projects/<Project ID>/locations/<Location
        #     ID>/answerRecords/<Answer Record ID>`
        #     The answer record associated with the tool call.
        # @!attribute [rw] parameters
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Parameters to be used for the tool call.  If not provided, the
        #     tool will be called without any parameters.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestionInput::Action]
        #     Optional. The type of action to take with the tool.
        # @!attribute [rw] send_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Time when the current suggest input is sent. For tool calls, this
        #     timestamp (along with the answer record) will be included in the
        #     corresponding tool call result so that it can be identified.
        class SuggestionInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicate what type of action to take with the tool call.
          module Action
            # Action not specified.
            ACTION_UNSPECIFIED = 0

            # Indicates the user chooses to not make the tool call. It
            # is only applicable to tool calls that are waiting for user
            # confirmation.
            CANCEL = 1

            # Makes the tool call with provided parameters. This action is intended
            # for tool calls that only read but not write data.
            REVISE = 2

            # Makes the tool call with provided parameters. This action is intended
            # for tool calls that may write data.
            CONFIRM = 3
          end
        end

        # Represents the parameters of human assist query.
        # @!attribute [rw] documents_metadata_filters
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Key-value filters on the metadata of documents returned by article
        #     suggestion. If specified, article suggestion only returns suggested
        #     documents that match all filters in their
        #     {::Google::Cloud::Dialogflow::V2::Document#metadata Document.metadata}. Multiple
        #     values for a metadata key should be concatenated by comma. For example,
        #     filters to match all documents that have 'US' or 'CA' in their market
        #     metadata values and 'agent' in their user metadata values will be
        #     ```
        #     documents_metadata_filters {
        #       key: "market"
        #       value: "US,CA"
        #     }
        #     documents_metadata_filters {
        #       key: "user"
        #       value: "agent"
        #     }
        #     ```
        class AssistQueryParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DocumentsMetadataFiltersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_knowledge_assist Participants.SuggestKnowledgeAssist}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the participant to fetch suggestions for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message to compile
        #     suggestions for. If empty, it will be the latest message of the
        #     conversation. Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Optional. Max number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest#latest_message latest_message}
        #     to use as context when compiling the suggestion. The context size is by
        #     default 100 and at most 100.
        # @!attribute [rw] previous_suggested_query
        #   @return [::String]
        #     Optional. The previously suggested query for the given conversation. This
        #     helps identify whether the next suggestion we generate is reasonably
        #     different from the previous one. This is useful to avoid similar
        #     suggestions within the conversation.
        class SuggestKnowledgeAssistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_knowledge_assist Participants.SuggestKnowledgeAssist}.
        # @!attribute [r] knowledge_assist_answer
        #   @return [::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer]
        #     Output only. Knowledge Assist suggestion.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used to compile suggestion for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse#latest_message latest_message}
        #     to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest#context_size SuggestKnowledgeAssistRequest.context_size}
        #     field in the request if there are fewer messages in the conversation.
        class SuggestKnowledgeAssistResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Knowledge Assist answer.
        # @!attribute [rw] suggested_query
        #   @return [::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer::SuggestedQuery]
        #     The query suggested based on the context. Suggestion is made only if it
        #     is different from the previous suggestion.
        # @!attribute [rw] suggested_query_answer
        #   @return [::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer::KnowledgeAnswer]
        #     The answer generated for the suggested query. Whether or not an answer is
        #     generated depends on how confident we are about the generated query.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of the answer record.
        #     Format: `projects/<Project ID>/locations/<location ID>/answer
        #     Records/<Answer Record ID>`.
        class KnowledgeAssistAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a suggested query.
          # @!attribute [rw] query_text
          #   @return [::String]
          #     Suggested query text.
          class SuggestedQuery
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents an answer from Knowledge. Currently supports FAQ and Generative
          # answers.
          # @!attribute [rw] answer_text
          #   @return [::String]
          #     The piece of text from the `source` that answers this suggested query.
          # @!attribute [rw] faq_source
          #   @return [::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer::KnowledgeAnswer::FaqSource]
          #     Populated if the prediction came from FAQ.
          #
          #     Note: The following fields are mutually exclusive: `faq_source`, `generative_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] generative_source
          #   @return [::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer::KnowledgeAnswer::GenerativeSource]
          #     Populated if the prediction was Generative.
          #
          #     Note: The following fields are mutually exclusive: `generative_source`, `faq_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class KnowledgeAnswer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Details about source of FAQ answer.
            # @!attribute [rw] question
            #   @return [::String]
            #     The corresponding FAQ question.
            class FaqSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Details about source of Generative answer.
            # @!attribute [rw] snippets
            #   @return [::Array<::Google::Cloud::Dialogflow::V2::KnowledgeAssistAnswer::KnowledgeAnswer::GenerativeSource::Snippet>]
            #     All snippets used for this Generative Prediction, with their source URI
            #     and data.
            class GenerativeSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Snippet Source for a Generative Prediction.
              # @!attribute [rw] uri
              #   @return [::String]
              #     URI the data is sourced from.
              # @!attribute [rw] text
              #   @return [::String]
              #     Text taken from that URI.
              # @!attribute [rw] title
              #   @return [::String]
              #     Title of the document.
              # @!attribute [rw] metadata
              #   @return [::Google::Protobuf::Struct]
              #     Metadata of the document.
              class Snippet
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end
      end
    end
  end
end
