# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Request of CreateGeneratorEvaluation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The generator resource name. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        # @!attribute [rw] generator_evaluation
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluation]
        #     Required. The generator evaluation to be created.
        class CreateGeneratorEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of GetGeneratorEvaluation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The generator evaluation resource name. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator
        #     ID>/evaluations/<Evaluation ID>`
        class GetGeneratorEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of ListGeneratorEvaluations.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The generator resource name. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        #     Wildcard value `-` is supported on generator_id to list evaluations across
        #     all generators under same project.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of evaluations to return in a
        #     single page. By default 100 and at most 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListGeneratorEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of ListGeneratorEvaluations.
        # @!attribute [rw] generator_evaluations
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::GeneratorEvaluation>]
        #     The list of evaluations to return.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListGeneratorEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of DeleteGeneratorEvaluation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The generator evaluation resource name. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>/
        #     evaluations/<Evaluation ID>`
        class DeleteGeneratorEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents evaluation result of a generator.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the evaluation. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>/
        #     evaluations/<Evaluation ID>`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the generator evaluation. At most 64 bytes
        #     long.
        # @!attribute [rw] generator_evaluation_config
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig]
        #     Required. The configuration of the evaluation task.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this generator evaluation.
        # @!attribute [r] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Completion time of this generator evaluation.
        # @!attribute [rw] initial_generator
        #   @return [::Google::Cloud::Dialogflow::V2::Generator]
        #     Required. The initial generator that was used when creating this
        #     evaluation. This is a copy of the generator read from storage when creating
        #     the evaluation.
        # @!attribute [r] summarization_metrics
        #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics]
        #     Output only. Only available when the summarization generator is provided.
        # @!attribute [r] evaluation_status
        #   @return [::Google::Cloud::Dialogflow::V2::EvaluationStatus]
        #     Output only. The result status of the evaluation pipeline. Provides the
        #     status information including if the evaluation is still in progress,
        #     completed or failed with certain error and user actionable message.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. A read only boolean field reflecting Zone Separation
        #     status of the model. The field is an aggregated
        #     value of ZS status of its underlying dependencies. See more details in
        #     go/zicy-resource-placement#resource-status
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. A read only boolean field reflecting Zone Isolation status
        #     of the model. The field is an aggregated value of
        #     ZI status of its underlying dependencies. See more details in
        #     go/zicy-resource-placement#resource-status
        class GeneratorEvaluation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Evaluation metrics for summarization generator.
        # @!attribute [r] summarization_evaluation_results
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::SummarizationEvaluationResult>]
        #     Output only. A list of evaluation results per conversation(&summary),
        #     metric and section.
        # @!attribute [r] summarization_evaluation_merged_results_uri
        #   @return [::String]
        #     Output only. User bucket uri for merged evaluation score and aggregation
        #     score csv.
        # @!attribute [r] overall_metrics
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::OverallScoresByMetric>]
        #     Output only. A list of aggregated(average) scores per metric section.
        # @!attribute [r] overall_section_tokens
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::SectionToken>]
        #     Output only. Overall token per section. This is an aggregated(sum) result
        #     of input token of summary acorss all conversations that are selected for
        #     summarization evaluation.
        # @!attribute [r] conversation_details
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::ConversationDetail>]
        #     Output only. List of conversation details.
        class SummarizationEvaluationMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Decomposition details for accuracy.
          # @!attribute [r] point
          #   @return [::String]
          #     Output only. The breakdown point of the summary.
          # @!attribute [r] accuracy_reasoning
          #   @return [::String]
          #     Output only. The accuracy reasoning of the breakdown point.
          # @!attribute [r] is_accurate
          #   @return [::Boolean]
          #     Output only. Whether the breakdown point is accurate or not.
          class AccuracyDecomposition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Decomposition details for adherence.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [r] point
          #   @return [::String]
          #     Output only. The breakdown point of the given instructions.
          # @!attribute [r] adherence_reasoning
          #   @return [::String]
          #     Output only. The adherence reasoning of the breakdown point.
          # @!attribute [r] is_adherent
          #   @return [::Boolean]
          #     Output only. Whether the breakdown point is adherent or not.
          class AdherenceDecomposition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Rubric result of the adherence evaluation. A rubric is ued to determine
          # if the summary adheres to all aspects of the given instructions.
          # @!attribute [r] question
          #   @return [::String]
          #     Output only. The question generated from instruction that used to
          #     evaluate summary.
          # @!attribute [r] reasoning
          #   @return [::String]
          #     Output only. The reasoning of the rubric question is addressed or not.
          # @!attribute [r] is_addressed
          #   @return [::Boolean]
          #     Output only. A boolean that indicates whether the rubric question is
          #     addressed or not.
          class AdherenceRubric
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Rubric details of the completeness evaluation result.
          # @!attribute [r] question
          #   @return [::String]
          #     Output only. The question generated from instruction that used to
          #     evaluate summary.
          # @!attribute [r] is_addressed
          #   @return [::Boolean]
          #     Output only. A boolean that indicates whether the rubric question is
          #     addressed or not.
          class CompletenessRubric
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Decomposition details
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] accuracy_decomposition
          #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::AccuracyDecomposition]
          #     only available for accuracy metric.
          #
          #     Note: The following fields are mutually exclusive: `accuracy_decomposition`, `adherence_decomposition`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] adherence_decomposition
          #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::AdherenceDecomposition]
          #     only available for adherence metric.
          #
          #     Note: The following fields are mutually exclusive: `adherence_decomposition`, `accuracy_decomposition`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Decomposition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Evaluation result that contains one of accuracy, adherence or completeness
          # evaluation result.
          # @!attribute [rw] accuracy_decomposition
          #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::AccuracyDecomposition]
          #     Only available for accuracy metric.
          #
          #     Note: The following fields are mutually exclusive: `accuracy_decomposition`, `adherence_rubric`, `completeness_rubric`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] adherence_rubric
          #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::AdherenceRubric]
          #     Only available for adherence metric.
          #
          #     Note: The following fields are mutually exclusive: `adherence_rubric`, `accuracy_decomposition`, `completeness_rubric`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] completeness_rubric
          #   @return [::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::CompletenessRubric]
          #     Only available for completeness metric.
          #
          #     Note: The following fields are mutually exclusive: `completeness_rubric`, `accuracy_decomposition`, `adherence_rubric`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class EvaluationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Evaluation result per conversation(&summary), metric and section.
          # @!attribute [r] session_id
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Output only. conversation session id
          # @!attribute [r] metric
          #   @return [::String]
          #     Output only. metric name, e.g. accuracy, completeness, adherence, etc.
          # @!attribute [r] section
          #   @return [::String]
          #     Output only. section/task name, e.g. action, situation, etc
          # @!attribute [r] score
          #   @return [::Float]
          #     Output only. score calculated from decompositions
          # @!attribute [r] section_summary
          #   @return [::String]
          #     Output only. Summary of this section
          # @!attribute [r] decompositions
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::Decomposition>]
          #     Output only. List of decompostion details
          # @!attribute [r] evaluation_results
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::EvaluationResult>]
          #     Output only. List of evaluation results.
          class SummarizationEvaluationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Overall performance per metric. This is the aggregated score for each
          # metric across all conversations that are selected for summarization
          # evaluation.
          # @!attribute [r] metric
          #   @return [::String]
          #     Output only. Metric name. e.g. accuracy, adherence, completeness.
          class OverallScoresByMetric
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A pair of section name and input token count of the input summary section.
          # @!attribute [r] section
          #   @return [::String]
          #     Output only. The name of the summary instruction.
          # @!attribute [r] token_count
          #   @return [::Integer]
          #     Output only. Token count.
          class SectionToken
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Aggregated evaluation result on conversation level. This conatins
          # evaluation results of all the metrics and sections.
          # @!attribute [r] message_entries
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::MessageEntry>]
          #     Output only. Conversation transcript that used for summarization
          #     evaluation as a reference.
          # @!attribute [r] summary_sections
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarySuggestion::SummarySection>]
          #     Output only. Summary sections that used for summarization evaluation as a
          #     reference.
          # @!attribute [r] metric_details
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::ConversationDetail::MetricDetail>]
          #     Output only. List of metric details.
          # @!attribute [r] section_tokens
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::SectionToken>]
          #     Output only. Conversation level token count per section. This is an
          #     aggregated(sum) result of input token of summary acorss all metrics for a
          #     single conversation.
          class ConversationDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Aggregated result on metric level. This conatins the evaluation results
            # of all the sections.
            # @!attribute [r] metric
            #   @return [::String]
            #     Output only. Metrics name. e.g. accuracy, adherence, completeness.
            # @!attribute [r] score
            #   @return [::Float]
            #     Output only. Aggregated(average) score on this metric across all
            #     sections.
            # @!attribute [r] section_details
            #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::ConversationDetail::MetricDetail::SectionDetail>]
            #     Output only. List of section details.
            class MetricDetail
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Section level result.
              # @!attribute [r] section
              #   @return [::String]
              #     Output only. The name of the summary instruction.
              # @!attribute [r] score
              #   @return [::Float]
              #     Output only. Aggregated(average) score on this section across all
              #     evaluation results. Either decompositions or rubrics.
              # @!attribute [r] section_summary
              #   @return [::String]
              #     Output only. Summary for this section
              # @!attribute [r] evaluation_results
              #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationEvaluationMetrics::EvaluationResult>]
              #     Output only. List of evaluation result. The list only contains one
              #     kind of the evaluation result.
              class SectionDetail
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end

        # Generator evaluation input config.
        # @!attribute [rw] input_data_config
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::InputDataConfig]
        #     Required. The config/source of input data.
        # @!attribute [rw] output_gcs_bucket_path
        #   @return [::String]
        #     Required. The output Cloud Storage bucket path to store eval files, e.g.
        #     per_summary_accuracy_score report. This path is provided by customer and
        #     files stored in it are visible to customer, no internal data should be
        #     stored in this path.
        # @!attribute [rw] summarization_config
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::SummarizationConfig]
        #     Evaluation configs for summarization generator.
        class GeneratorEvaluationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The distinctive configs for Agent Assist conversations as the conversation
          # source.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The start of the time range for conversations to be evaluated.
          #     Only conversations created at or after this timestamp will be sampled.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The end of the time range for conversations to be evaluated.
          #     Only conversations ended at or before this timestamp will be sampled.
          class AgentAssistInputDataConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The distinctive configs for dataset as the conversation source.
          # @!attribute [rw] dataset
          #   @return [::String]
          #     Required. The identifier of the dataset to be evaluated.
          #     Format:
          #     `projects/<ProjectId>/locations/<LocationID>/datasets/<DatasetID>`.
          class DatasetInputDataConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input data config details
          # @!attribute [rw] input_data_source_type
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::InputDataSourceType]
          #     Required. The source type of input data.
          # @!attribute [rw] start_time
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The start timestamp to fetch conversation data.
          # @!attribute [rw] end_time
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The end timestamp to fetch conversation data.
          # @!attribute [rw] sample_size
          #   @return [::Integer]
          #     Optional. Desired number of conversation-summary pairs to be evaluated.
          # @!attribute [rw] is_summary_generation_allowed
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. Whether the summary generation is allowed when the pre-existing
          #     qualified summaries are insufficient to cover the sample size.
          # @!attribute [rw] summary_generation_option
          #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::InputDataConfig::SummaryGenerationOption]
          #     Optional. Option to control whether summaries are generated during
          #     evaluation.
          # @!attribute [rw] agent_assist_input_data_config
          #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::AgentAssistInputDataConfig]
          #     The distinctive configs for Agent Assist conversations as the
          #     conversation source.
          #
          #     Note: The following fields are mutually exclusive: `agent_assist_input_data_config`, `dataset_input_data_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] dataset_input_data_config
          #   @return [::Google::Cloud::Dialogflow::V2::GeneratorEvaluationConfig::DatasetInputDataConfig]
          #     The distinctive configs for dataset as the conversation source.
          #
          #     Note: The following fields are mutually exclusive: `dataset_input_data_config`, `agent_assist_input_data_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class InputDataConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Summary generation options.
            module SummaryGenerationOption
              # Default option will not be used
              SUMMARY_GENERATION_OPTION_UNSPECIFIED = 0

              # Always Generate summary for all conversations.
              ALWAYS_GENERATE = 1

              # Gnerate only missing summaries.
              GENERATE_IF_MISSING = 2

              # Do not generate new summaries. Only use existing summaries found.
              DO_NOT_GENERATE = 3
            end
          end

          # Evaluation configs for summarization generator.
          # @!attribute [rw] enable_accuracy_evaluation
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. Enable accuracy evaluation.
          # @!attribute [rw] accuracy_evaluation_version
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Optional. Version for summarization accuracy. This will determine the
          #     prompt and model used at backend.
          # @!attribute [rw] enable_completeness_evaluation
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. Enable completeness evaluation.
          # @!attribute [rw] completeness_evaluation_version
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Optional. Version for summarization completeness. This will determine the
          #     prompt and model used at backend.
          # @!attribute [rw] evaluator_version
          #   @return [::String]
          #     Optional. Version for summarization evaluation.
          class SummarizationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of input data source type.
          module InputDataSourceType
            # Unspecified InputDataSourceType. Should not be used.
            INPUT_DATA_SOURCE_TYPE_UNSPECIFIED = 0

            # Fetch data from Agent Assist storage. If this source type is chosen,
            # input_data_config.start_time and input_data_config.end_timestamp must be
            # provided.
            AGENT_ASSIST_CONVERSATIONS = 1

            # Fetch data from Insights storage. If this source type is chosen,
            # input_data_config.start_time and input_data_config.end_timestamp must be
            # provided.
            INSIGHTS_CONVERSATIONS = 2
          end
        end

        # A common evalaution pipeline status.
        # @!attribute [r] done
        #   @return [::Boolean]
        #     Output only. If the value is `false`, it means the evaluation is still in
        #     progress. If `true`, the operation is completed, and either `error` or
        #     `response` is available.
        # @!attribute [r] pipeline_status
        #   @return [::Google::Rpc::Status]
        #     Output only. The error result of the evaluation in case of failure in
        #     evaluation pipeline.
        class EvaluationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
