# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Request message of CreateGenerator.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project/location to create generator for. Format:
        #     `projects/<Project ID>/locations/<Location ID>`
        # @!attribute [rw] generator
        #   @return [::Google::Cloud::Dialogflow::V2::Generator]
        #     Required. The generator to create.
        # @!attribute [rw] generator_id
        #   @return [::String]
        #     Optional. The ID to use for the generator, which will become the final
        #     component of the generator's resource name.
        #
        #     The generator ID must be compliant with the regression formula
        #     `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
        #     If the field is not provided, an Id will be auto-generated.
        #     If the field is provided, the caller is responsible for
        #     1. the uniqueness of the ID, otherwise the request will be rejected.
        #     2. the consistency for whether to use custom ID or not under a project to
        #     better ensure uniqueness.
        class CreateGeneratorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of GetGenerator.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The generator resource name to retrieve. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        class GetGeneratorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of ListGenerators.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project/location to list generators for. Format:
        #     `projects/<Project ID>/locations/<Location ID>`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of conversation models to return in a single page.
        #     Default to 10.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListGeneratorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of ListGenerators.
        # @!attribute [rw] generators
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Generator>]
        #     List of generators retrieved.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListGeneratorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of DeleteGenerator.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The generator resource name to delete. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        class DeleteGeneratorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request of UpdateGenerator.
        # @!attribute [rw] generator
        #   @return [::Google::Cloud::Dialogflow::V2::Generator]
        #     Required. The generator to update.
        #     The name field of generator is to identify the generator to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateGeneratorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a message entry of a conversation.
        # @!attribute [rw] role
        #   @return [::Google::Cloud::Dialogflow::V2::MessageEntry::Role]
        #     Optional. Participant role of the message.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. Transcript content of the message.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The language of the text. See [Language
        #     Support](https://cloud.google.com/dialogflow/docs/reference/language) for a
        #     list of the currently supported language codes.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Create time of the message entry.
        class MessageEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of the roles a participant can play in a conversation.
          module Role
            # Participant role not set.
            ROLE_UNSPECIFIED = 0

            # Participant is a human agent.
            HUMAN_AGENT = 1

            # Participant is an automated agent, such as a Dialogflow agent.
            AUTOMATED_AGENT = 2

            # Participant is an end user that has called or chatted with
            # Dialogflow services.
            END_USER = 3
          end
        end

        # Context of the conversation, including transcripts.
        # @!attribute [rw] message_entries
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::MessageEntry>]
        #     Optional. List of message transcripts in the conversation.
        class ConversationContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of summarization sections.
        # @!attribute [rw] summarization_sections
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationSection>]
        #     Optional. Summarization sections.
        class SummarizationSectionList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Providing examples in the generator (i.e. building a few-shot generator)
        # helps convey the desired format of the LLM response.
        # @!attribute [rw] conversation_context
        #   @return [::Google::Cloud::Dialogflow::V2::ConversationContext]
        #     Optional. Conversation transcripts.
        # @!attribute [rw] extra_info
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Key is the placeholder field name in input, value is the value of
        #     the placeholder. E.g. instruction contains "@price", and ingested data has
        #     <"price", "10">
        # @!attribute [rw] summarization_section_list
        #   @return [::Google::Cloud::Dialogflow::V2::SummarizationSectionList]
        #     Summarization sections.
        # @!attribute [rw] output
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorSuggestion]
        #     Required. Example output of the model.
        class FewShotExample
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ExtraInfoEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The parameters of inference.
        # @!attribute [rw] max_output_tokens
        #   @return [::Integer]
        #     Optional. Maximum number of the output tokens for the generator.
        # @!attribute [rw] temperature
        #   @return [::Float]
        #     Optional. Controls the randomness of LLM predictions.
        #     Low temperature = less random. High temperature = more random.
        #     If unset (or 0), uses a default value of 0.
        # @!attribute [rw] top_k
        #   @return [::Integer]
        #     Optional. Top-k changes how the model selects tokens for output. A top-k of
        #     1 means the selected token is the most probable among all tokens in the
        #     model's vocabulary (also called greedy decoding), while a top-k of 3 means
        #     that the next token is selected from among the 3 most probable tokens
        #     (using temperature). For each token selection step, the top K tokens with
        #     the highest probabilities are sampled. Then tokens are further filtered
        #     based on topP with the final token selected using temperature sampling.
        #     Specify a lower value for less random responses and a higher value for more
        #     random responses. Acceptable value is [1, 40], default to 40.
        # @!attribute [rw] top_p
        #   @return [::Float]
        #     Optional. Top-p changes how the model selects tokens for output. Tokens are
        #     selected from most K (see topK parameter) probable to least until the sum
        #     of their probabilities equals the top-p value. For example, if tokens A, B,
        #     and C have a probability of 0.3, 0.2, and 0.1 and the top-p value is 0.5,
        #     then the model will select either A or B as the next token (using
        #     temperature) and doesn't consider C. The default top-p value is 0.95.
        #     Specify a lower value for less random responses and a higher value for more
        #     random responses. Acceptable value is [0.0, 1.0], default to 0.95.
        class InferenceParameter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Agent Coaching context that customer can configure.
        # @!attribute [rw] overarching_guidance
        #   @return [::String]
        #     Optional. The overarching guidance for the agent coaching. This should be
        #     set only for v1.5 and later versions.
        # @!attribute [rw] instructions
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingInstruction>]
        #     Optional. Customized instructions for agent coaching.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. Version of the feature. If not set, default to latest version.
        #     Current candidates are ["1.2"].
        # @!attribute [rw] output_language_code
        #   @return [::String]
        #     Optional. Output language code.
        class AgentCoachingContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the section of summarization.
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. Name of the section, for example, "situation".
        # @!attribute [rw] definition
        #   @return [::String]
        #     Optional. Definition of the section, for example, "what the customer needs
        #     help with or has question about."
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dialogflow::V2::SummarizationSection::Type]
        #     Optional. Type of the summarization section.
        class SummarizationSection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type enum of the summarization sections.
          module Type
            # Undefined section type, does not return anything.
            TYPE_UNSPECIFIED = 0

            # What the customer needs help with or has question about.
            # Section name: "situation".
            SITUATION = 1

            # What the agent does to help the customer.
            # Section name: "action".
            ACTION = 2

            # Result of the customer service. A single word describing the result
            # of the conversation.
            # Section name: "resolution".
            RESOLUTION = 3

            # Reason for cancellation if the customer requests for a cancellation.
            # "N/A" otherwise.
            # Section name: "reason_for_cancellation".
            REASON_FOR_CANCELLATION = 4

            # "Unsatisfied" or "Satisfied" depending on the customer's feelings at
            # the end of the conversation.
            # Section name: "customer_satisfaction".
            CUSTOMER_SATISFACTION = 5

            # Key entities extracted from the conversation, such as ticket number,
            # order number, dollar amount, etc.
            # Section names are prefixed by "entities/".
            ENTITIES = 6

            # Customer defined sections.
            CUSTOMER_DEFINED = 7

            # Concise version of the situation section. This type is only available if
            # type SITUATION is not selected.
            SITUATION_CONCISE = 9

            # Concise version of the action section. This type is only available if
            # type ACTION is not selected.
            ACTION_CONCISE = 10
          end
        end

        # Summarization context that customer can configure.
        # @!attribute [rw] summarization_sections
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarizationSection>]
        #     Optional. List of sections. Note it contains both predefined section sand
        #     customer defined sections.
        # @!attribute [rw] few_shot_examples
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::FewShotExample>]
        #     Optional. List of few shot examples.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. Version of the feature. If not set, default to latest version.
        #     Current candidates are ["1.0"].
        # @!attribute [rw] output_language_code
        #   @return [::String]
        #     Optional. The target language of the generated summary. The language code
        #     for conversation will be used if this field is empty. Supported 2.0 and
        #     later versions.
        class SummarizationContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Free form generator context that customer can configure.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. Free form text input to LLM.
        class FreeFormContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LLM generator.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the generator. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Human readable description of the generator.
        # @!attribute [rw] free_form_context
        #   @return [::Google::Cloud::Dialogflow::V2::FreeFormContext]
        #     Input of free from generator to LLM.
        #
        #     Note: The following fields are mutually exclusive: `free_form_context`, `agent_coaching_context`, `summarization_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] agent_coaching_context
        #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingContext]
        #     Input of prebuilt Agent Coaching feature.
        #
        #     Note: The following fields are mutually exclusive: `agent_coaching_context`, `free_form_context`, `summarization_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summarization_context
        #   @return [::Google::Cloud::Dialogflow::V2::SummarizationContext]
        #     Input of prebuilt Summarization feature.
        #
        #     Note: The following fields are mutually exclusive: `summarization_context`, `free_form_context`, `agent_coaching_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inference_parameter
        #   @return [::Google::Cloud::Dialogflow::V2::InferenceParameter]
        #     Optional. Inference parameters for this generator.
        # @!attribute [rw] trigger_event
        #   @return [::Google::Cloud::Dialogflow::V2::TriggerEvent]
        #     Optional. The trigger event of the generator. It defines when the generator
        #     is triggered in a conversation.
        # @!attribute [rw] published_model
        #   @return [::String]
        #     Optional. The published Large Language Model name.
        #     * To use the latest model version, specify the model name without version
        #       number. Example: `text-bison`
        #     * To use a stable model version, specify the version number as well.
        #       Example: `text-bison@002`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this generator.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update time of this generator.
        # @!attribute [rw] tools
        #   @return [::Array<::String>]
        #     Optional. Resource names of the tools that the generator can choose from.
        #     Format: `projects/<Project ID>/locations/<Location ID>/tools/<tool ID>`.
        # @!attribute [rw] suggestion_deduping_config
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestionDedupingConfig]
        #     Optional. Configuration for suggestion deduping. This is only applicable to
        #     AI Coach feature.
        class Generator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Suggestion generated using free form generator.
        # @!attribute [rw] response
        #   @return [::String]
        #     Required. Free form suggestion.
        class FreeFormSuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Suggested summary of the conversation.
        # @!attribute [rw] summary_sections
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SummarySuggestion::SummarySection>]
        #     Required. All the parts of generated summary.
        class SummarySuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A component of the generated summary.
          # @!attribute [rw] section
          #   @return [::String]
          #     Required. Name of the section.
          # @!attribute [rw] summary
          #   @return [::String]
          #     Required. Summary text for the section.
          class SummarySection
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Suggestion for coaching agents.
        # @!attribute [rw] applicable_instructions
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingInstruction>]
        #     Optional. Instructions applicable based on the current context.
        # @!attribute [rw] agent_action_suggestions
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::AgentActionSuggestion>]
        #     Optional. Suggested actions for the agent to take.
        # @!attribute [rw] sample_responses
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::SampleResponse>]
        #     Optional. Sample response for the Agent.
        class AgentCoachingSuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Sources for the suggestion.
          # @!attribute [r] instruction_indexes
          #   @return [::Array<::Integer>]
          #     Output only. Source instruction indexes for the suggestion. This is the
          #     index of the applicable_instructions field.
          class Sources
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Duplication check for the suggestion.
          # @!attribute [r] duplicate_suggestions
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::DuplicateCheckResult::DuplicateSuggestion>]
          #     Output only. The duplicate suggestions.
          class DuplicateCheckResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The duplicate suggestion details.
            # Keeping answer_record and sources together as they are identifiers for
            # duplicate suggestions.
            # @!attribute [r] answer_record
            #   @return [::String]
            #     Output only. The answer record id of the past duplicate suggestion.
            # @!attribute [r] sources
            #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::Sources]
            #     Output only. Sources for the suggestion.
            # @!attribute [r] suggestion_index
            #   @return [::Integer]
            #     Output only. The index of the duplicate suggestion in the past
            #     suggestion list.
            # @!attribute [r] similarity_score
            #   @return [::Float]
            #     Output only. The similarity score of between the past and current
            #     suggestion.
            class DuplicateSuggestion
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Actions suggested for the agent. This is based on applicable instructions.
          # @!attribute [rw] agent_action
          #   @return [::String]
          #     Optional. The suggested action for the agent.
          # @!attribute [r] sources
          #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::Sources]
          #     Output only. Sources for the agent action suggestion.
          # @!attribute [r] duplicate_check_result
          #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::DuplicateCheckResult]
          #     Output only. Duplicate check result for the agent action suggestion.
          class AgentActionSuggestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sample response that the agent can use. This could be based on applicable
          # instructions and ingested data from other systems.
          # @!attribute [rw] response_text
          #   @return [::String]
          #     Optional. Sample response for Agent in text.
          # @!attribute [r] sources
          #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::Sources]
          #     Output only. Sources for the Sample Response.
          # @!attribute [r] duplicate_check_result
          #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion::DuplicateCheckResult]
          #     Output only. Duplicate check result for the sample response.
          class SampleResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Suggestion generated using a Generator.
        # @!attribute [rw] free_form_suggestion
        #   @return [::Google::Cloud::Dialogflow::V2::FreeFormSuggestion]
        #     Optional. Free form suggestion.
        #
        #     Note: The following fields are mutually exclusive: `free_form_suggestion`, `summary_suggestion`, `agent_coaching_suggestion`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] summary_suggestion
        #   @return [::Google::Cloud::Dialogflow::V2::SummarySuggestion]
        #     Optional. Suggested summary.
        #
        #     Note: The following fields are mutually exclusive: `summary_suggestion`, `free_form_suggestion`, `agent_coaching_suggestion`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] agent_coaching_suggestion
        #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingSuggestion]
        #     Optional. Suggestion to coach the agent.
        #
        #     Note: The following fields are mutually exclusive: `agent_coaching_suggestion`, `free_form_suggestion`, `summary_suggestion`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tool_call_info
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::GeneratorSuggestion::ToolCallInfo>]
        #     Optional. List of request and response for tool calls executed.
        class GeneratorSuggestion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Request and response for a tool call.
          # @!attribute [rw] tool_call
          #   @return [::Google::Cloud::Dialogflow::V2::ToolCall]
          #     Required. Request for a tool call.
          # @!attribute [rw] tool_call_result
          #   @return [::Google::Cloud::Dialogflow::V2::ToolCallResult]
          #     Required. Response for a tool call.
          class ToolCallInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Config for suggestion deduping.
        # NEXT_ID: 3
        # @!attribute [rw] enable_deduping
        #   @return [::Boolean]
        #     Optional. Whether to enable suggestion deduping.
        # @!attribute [rw] similarity_threshold
        #   @return [::Float]
        #     Optional. The threshold for similarity between two suggestions.
        #     Acceptable value is [0.0, 1.0], default to 0.8
        class SuggestionDedupingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for Responsible AI checks.
        # @!attribute [rw] rai_category_configs
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::RaiSettings::RaiCategoryConfig>]
        #     Configuration for a set of RAI categories.
        class RaiSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for a specific RAI category.
          # @!attribute [rw] category
          #   @return [::Google::Cloud::Dialogflow::V2::RaiSettings::RaiCategoryConfig::RaiCategory]
          #     Optional. The RAI category.
          # @!attribute [rw] sensitivity_level
          #   @return [::Google::Cloud::Dialogflow::V2::RaiSettings::RaiCategoryConfig::SensitivityLevel]
          #     Optional. The sensitivity level for this category.
          class RaiCategoryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum for RAI category.
            module RaiCategory
              # Default value.
              RAI_CATEGORY_UNSPECIFIED = 0

              # Dangerous content.
              DANGEROUS_CONTENT = 1

              # Sexually explicit content.
              SEXUALLY_EXPLICIT = 2

              # Harassment content.
              HARASSMENT = 3

              # Hate speech content.
              HATE_SPEECH = 4
            end

            # Enum for user-configurable sensitivity levels.
            module SensitivityLevel
              # Default value.
              # If unspecified, the default behavior is:
              # - DANGEROUS_CONTENT: BLOCK_FEW
              # - SEXUALLY_EXPLICIT: BLOCK_SOME
              # - HARASSMENT: BLOCK_SOME
              # - HATE_SPEECH: BLOCK_SOME
              SENSITIVITY_LEVEL_UNSPECIFIED = 0

              # Block most potentially sensitive responses.
              BLOCK_MOST = 1

              # Block some potentially sensitive responses.
              BLOCK_SOME = 2

              # Block a few potentially sensitive responses.
              BLOCK_FEW = 3

              # No filtering for this category.
              BLOCK_NONE = 4
            end
          end
        end

        # The event that triggers the generator and LLM execution.
        module TriggerEvent
          # Default value for TriggerEvent.
          TRIGGER_EVENT_UNSPECIFIED = 0

          # Triggers when each chat message or voice utterance ends.
          END_OF_UTTERANCE = 1

          # Triggers on the conversation manually by API calls, such as
          # Conversations.GenerateStatelessSuggestion and
          # Conversations.GenerateSuggestions.
          MANUAL_CALL = 2

          # Triggers after each customer message only.
          CUSTOMER_MESSAGE = 3

          # Triggers after each agent message only.
          AGENT_MESSAGE = 4
        end
      end
    end
  end
end
