# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # By default, your agent responds to a matched intent with a static response.
        # As an alternative, you can provide a more dynamic response by using
        # fulfillment. When you enable fulfillment for an intent, Dialogflow responds
        # to that intent by calling a service that you define. For example, if an
        # end-user wants to schedule a haircut on Friday, your service can check your
        # database and respond to the end-user with availability information for
        # Friday.
        #
        # For more information, see the [fulfillment
        # guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The unique identifier of the fulfillment.
        #     Supported formats:
        #
        #     - `projects/<Project ID>/agent/fulfillment`
        #     - `projects/<Project ID>/locations/<Location ID>/agent/fulfillment`
        #
        #     This field is not used for Fulfillment in an Environment.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The human-readable name of the fulfillment, unique within the
        #     agent.
        #
        #     This field is not used for Fulfillment in an Environment.
        # @!attribute [rw] generic_web_service
        #   @return [::Google::Cloud::Dialogflow::V2::Fulfillment::GenericWebService]
        #     Configuration for a generic web service.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Optional. Whether fulfillment is enabled.
        # @!attribute [rw] features
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Fulfillment::Feature>]
        #     Optional. The field defines whether the fulfillment is enabled for certain
        #     features.
        class Fulfillment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents configuration for a generic web service.
          # Dialogflow supports two mechanisms for authentications:
          #
          # - Basic authentication with username and password.
          # - Authentication with additional authentication headers.
          #
          # More information could be found at:
          # https://cloud.google.com/dialogflow/docs/fulfillment-configure.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. The fulfillment URI for receiving POST requests.
          #     It must use https protocol.
          # @!attribute [rw] username
          #   @return [::String]
          #     Optional. The user name for HTTP Basic authentication.
          # @!attribute [rw] password
          #   @return [::String]
          #     Optional. The password for HTTP Basic authentication.
          # @!attribute [rw] request_headers
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The HTTP request headers to send together with fulfillment
          #     requests.
          # @!attribute [rw] is_cloud_function
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. Indicates if generic web service is created through Cloud
          #     Functions integration. Defaults to false.
          #
          #     is_cloud_function is deprecated. Cloud functions can be configured by
          #     its uri as a regular web service now.
          class GenericWebService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class RequestHeadersEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Whether fulfillment is enabled for the specific feature.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Dialogflow::V2::Fulfillment::Feature::Type]
          #     The type of the feature that enabled for fulfillment.
          class Feature
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the feature.
            module Type
              # Feature type not specified.
              TYPE_UNSPECIFIED = 0

              # Fulfillment is enabled for SmallTalk.
              SMALLTALK = 1
            end
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Fulfillments::Client#get_fulfillment Fulfillments.GetFulfillment}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the fulfillment.
        #     Format: `projects/<Project ID>/agent/fulfillment`.
        class GetFulfillmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Fulfillments::Client#update_fulfillment Fulfillments.UpdateFulfillment}.
        # @!attribute [rw] fulfillment
        #   @return [::Google::Cloud::Dialogflow::V2::Fulfillment]
        #     Required. The fulfillment to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The mask to control which fields get updated. If the mask is not
        #     present, all fields will be updated.
        class UpdateFulfillmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
