# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # The request to get location-level encryption specification.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the encryption spec resource to get.
        class GetEncryptionSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A customer-managed encryption key specification that can be applied to all
        # created resources (e.g. Conversation).
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name of the encryption key specification resource.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/encryptionSpec
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Required. The name of customer-managed encryption key that is used to
        #     secure a resource and its sub-resources. If empty, the resource is secured
        #     by the default Google encryption key. Only the key in the same location as
        #     this resource is allowed to be used for encryption. Format:
        #     `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
        class EncryptionSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request to initialize a location-level encryption specification.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::Dialogflow::V2::EncryptionSpec]
        #     Required. The encryption spec used for CMEK encryption. It is required that
        #     the kms key is in the same region as the endpoint. The same key will be
        #     used for all provisioned resources, if encryption is available. If the
        #     kms_key_name is left empty, no encryption will be enforced.
        class InitializeEncryptionSpecRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to initialize a location-level encryption specification.
        class InitializeEncryptionSpecResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for initializing a location-level encryption specification.
        # @!attribute [r] request
        #   @return [::Google::Cloud::Dialogflow::V2::InitializeEncryptionSpecRequest]
        #     Output only. The original request for initialization.
        class InitializeEncryptionSpecMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
