# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Represents a notification sent to Pub/Sub subscribers for conversation
        # lifecycle events.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     The unique identifier of the conversation this notification
        #     refers to.
        #     Format: `projects/<Project ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dialogflow::V2::ConversationEvent::Type]
        #     The type of the event that this notification refers to.
        # @!attribute [rw] error_status
        #   @return [::Google::Rpc::Status]
        #     More detailed information about an error. Only set for type
        #     UNRECOVERABLE_ERROR_IN_PHONE_CALL.
        # @!attribute [rw] new_message_payload
        #   @return [::Google::Cloud::Dialogflow::V2::Message]
        #     Payload of NEW_MESSAGE event.
        #
        #     Note: The following fields are mutually exclusive: `new_message_payload`, `new_recognition_result_payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] new_recognition_result_payload
        #   @return [::Google::Cloud::Dialogflow::V2::StreamingRecognitionResult]
        #     Payload of NEW_RECOGNITION_RESULT event.
        #
        #     Note: The following fields are mutually exclusive: `new_recognition_result_payload`, `new_message_payload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ConversationEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of the types of events available.
          module Type
            # Type not set.
            TYPE_UNSPECIFIED = 0

            # A new conversation has been opened. This is fired when a telephone call
            # is answered, or a conversation is created via the API.
            CONVERSATION_STARTED = 1

            # An existing conversation has closed. This is fired when a telephone call
            # is terminated, or a conversation is closed via the API.
            # The event is fired for every CompleteConversation call, even if the
            # conversation is already closed.
            CONVERSATION_FINISHED = 2

            # An existing conversation has received notification from Dialogflow that
            # human intervention is required.
            HUMAN_INTERVENTION_NEEDED = 3

            # An existing conversation has received a new message, either from API or
            # telephony. It is configured in
            # {::Google::Cloud::Dialogflow::V2::ConversationProfile#new_message_event_notification_config ConversationProfile.new_message_event_notification_config}
            NEW_MESSAGE = 5

            # An existing conversation has received a new speech recognition result.
            # This is mainly for delivering intermediate transcripts. The notification
            # is configured in
            # [ConversationProfile.new_recognition_event_notification_config][].
            NEW_RECOGNITION_RESULT = 7

            # Unrecoverable error during a telephone call.
            #
            # In general non-recoverable errors only occur if something was
            # misconfigured in the ConversationProfile corresponding to the call. After
            # a non-recoverable error, Dialogflow may stop responding.
            #
            # We don't fire this event:
            #
            # * in an API call because we can directly return the error, or,
            # * when we can recover from an error.
            UNRECOVERABLE_ERROR = 4
          end
        end
      end
    end
  end
end
