# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Represents a conversation.
        # A conversation is an interaction between an agent, including live agents
        # and Dialogflow agents, and a support customer. Conversations can
        # include phone calls and text-based chat sessions.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The unique identifier of this conversation.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        # @!attribute [r] lifecycle_state
        #   @return [::Google::Cloud::Dialogflow::V2::Conversation::LifecycleState]
        #     Output only. The current state of the Conversation.
        # @!attribute [rw] conversation_profile
        #   @return [::String]
        #     Required. The Conversation Profile to be used to configure this
        #     Conversation. This field cannot be updated.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversationProfiles/<Conversation Profile ID>`.
        # @!attribute [r] phone_number
        #   @return [::Google::Cloud::Dialogflow::V2::ConversationPhoneNumber]
        #     Output only. It will not be empty if the conversation is to be connected
        #     over telephony.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the conversation was started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the conversation was finished.
        # @!attribute [rw] conversation_stage
        #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage]
        #     Optional. The stage of a conversation. It indicates whether the virtual
        #     agent or a human agent is handling the conversation.
        #
        #     If the conversation is created with the conversation profile that has
        #     Dialogflow config set, defaults to
        #     {::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage::VIRTUAL_AGENT_STAGE ConversationStage.VIRTUAL_AGENT_STAGE};
        #     Otherwise, defaults to
        #     {::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage::HUMAN_ASSIST_STAGE ConversationStage.HUMAN_ASSIST_STAGE}.
        #
        #     If the conversation is created with the conversation profile that has
        #     Dialogflow config set but explicitly sets conversation_stage to
        #     {::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage::HUMAN_ASSIST_STAGE ConversationStage.HUMAN_ASSIST_STAGE},
        #     it skips
        #     {::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage::VIRTUAL_AGENT_STAGE ConversationStage.VIRTUAL_AGENT_STAGE}
        #     stage and directly goes to
        #     {::Google::Cloud::Dialogflow::V2::Conversation::ConversationStage::HUMAN_ASSIST_STAGE ConversationStage.HUMAN_ASSIST_STAGE}.
        # @!attribute [r] telephony_connection_info
        #   @return [::Google::Cloud::Dialogflow::V2::Conversation::TelephonyConnectionInfo]
        #     Output only. The telephony connection information.
        # @!attribute [r] ingested_context_references
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference}]
        #     Output only. The context reference updates provided by external systems.
        class Conversation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The information about phone calls connected via phone gateway to the
          # conversation.
          # @!attribute [r] dialed_number
          #   @return [::String]
          #     Output only. The number dialed to connect this call in E.164 format.
          # @!attribute [rw] sdp
          #   @return [::String]
          #     Optional. SDP of the call. It's initially the SDP answer to the incoming
          #     call, but maybe later updated for the purpose of making the link active,
          #     etc.
          # @!attribute [r] sip_headers
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Conversation::TelephonyConnectionInfo::SipHeader>]
          #     Output only. The SIP headers from the initial SIP INVITE.
          # @!attribute [r] extra_mime_contents
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Conversation::TelephonyConnectionInfo::MimeContent>]
          #     Output only. The mime content from the initial SIP INVITE.
          class TelephonyConnectionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The SIP headers from the initial SIP INVITE.
            # @!attribute [rw] name
            #   @return [::String]
            #     Optional. The name of the header.
            # @!attribute [rw] value
            #   @return [::String]
            #     Optional. The value of the header.
            class SipHeader
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The mime content from the initial SIP INVITE.
            # @!attribute [rw] mime_type
            #   @return [::String]
            #     Optional. The mime type of the content.
            # @!attribute [rw] content
            #   @return [::String]
            #     Optional. The content payload.
            class MimeContent
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Represents a section of ingested context information.
          # @!attribute [rw] context_contents
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Conversation::ContextReference::ContextContent>]
          #     Required. The list of content updates for a context reference.
          # @!attribute [rw] update_mode
          #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference::UpdateMode]
          #     Required. The mode in which context reference contents are updated.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. The language of the information ingested, defaults to "en-US"
          #     if not set.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the context reference was first created.
          class ContextReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Contents ingested.
            # @!attribute [rw] content
            #   @return [::String]
            #     Required. The information ingested in a single request.
            # @!attribute [rw] content_format
            #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference::ContextContent::ContentFormat]
            #     Required. The format of the ingested string.
            # @!attribute [r] ingestion_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Output only. The time when this information was incorporated into the
            #     relevant context reference.
            # @!attribute [rw] answer_record
            #   @return [::String]
            #     If the context content was generated from a tool call, specify the
            #     answer record associated with the tool call.
            #     Format: `projects/<Project ID>/locations/<Location
            #     ID>/answerRecords/<Answer Record ID>`.
            class ContextContent
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Represents the format of the ingested string.
              module ContentFormat
                # Unspecified content format.
                CONTENT_FORMAT_UNSPECIFIED = 0

                # Content was provided in JSON format.
                JSON = 1

                # Content was provided as plain text.
                PLAIN_TEXT = 2
              end
            end

            # Represents the mode in which context reference contents are updated.
            module UpdateMode
              # Unspecified update mode.
              UPDATE_MODE_UNSPECIFIED = 0

              # Context content updates are applied in append mode.
              APPEND = 1

              # Context content updates are applied in overwrite mode.
              OVERWRITE = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference]
          class IngestedContextReferencesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of the completion status of the conversation.
          module LifecycleState
            # Unknown.
            LIFECYCLE_STATE_UNSPECIFIED = 0

            # Conversation is currently open for media analysis.
            IN_PROGRESS = 1

            # Conversation has been completed.
            COMPLETED = 2
          end

          # Enumeration of the different conversation stages a conversation can be in.
          # Reference:
          # https://cloud.google.com/agent-assist/docs/basics#conversation_stages
          module ConversationStage
            # Unknown. Should never be used after a conversation is successfully
            # created.
            CONVERSATION_STAGE_UNSPECIFIED = 0

            # The conversation should return virtual agent responses into the
            # conversation.
            VIRTUAL_AGENT_STAGE = 1

            # The conversation should not provide responses, just listen and provide
            # suggestions.
            HUMAN_ASSIST_STAGE = 2
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#create_conversation Conversations.CreateConversation}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource identifier of the project creating the conversation.
        #     Format: `projects/<Project ID>/locations/<Location ID>`.
        # @!attribute [rw] conversation
        #   @return [::Google::Cloud::Dialogflow::V2::Conversation]
        #     Required. The conversation to create.
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Optional. Identifier of the conversation. Generally it's auto generated by
        #     Google. Only set it if you cannot wait for the response to return a
        #     auto-generated one to you.
        #
        #     The conversation ID must be compliant with the regression formula
        #     `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
        #     If the field is provided, the caller is responsible for
        #     1. the uniqueness of the ID, otherwise the request will be rejected.
        #     2. the consistency for whether to use custom ID or not under a project to
        #     better ensure uniqueness.
        class CreateConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#list_conversations Conversations.ListConversations}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project from which to list all conversation.
        #     Format: `projects/<Project ID>/locations/<Location ID>`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return in a single page. By
        #     default 100 and at most 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter expression that filters conversations listed in the
        #     response. Only `lifecycle_state` can be filtered on in this way. For
        #     example, the following expression only returns `COMPLETED` conversations:
        #
        #     `lifecycle_state = "COMPLETED"`
        #
        #     For more information about filtering, see
        #     [API Filtering](https://aip.dev/160).
        class ListConversationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#list_conversations Conversations.ListConversations}.
        # @!attribute [rw] conversations
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Conversation>]
        #     The list of conversations. There will be a maximum number of items
        #     returned based on the page_size field in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no
        #     more results in the list.
        class ListConversationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#get_conversation Conversations.GetConversation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the conversation. Format:
        #     `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
        #     ID>`.
        class GetConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#complete_conversation Conversations.CompleteConversation}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource identifier of the conversation to close.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        class CompleteConversationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#list_messages Conversations.ListMessages}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the conversation to list messages for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter on message fields. Currently predicates on `create_time`
        #     and `create_time_epoch_microseconds` are supported. `create_time` only
        #     support milliseconds accuracy. E.g.,
        #     `create_time_epoch_microseconds > 1551790877964485` or
        #     `create_time > 2017-01-15T01:30:15.01Z`.
        #
        #     For more information about filtering, see
        #     [API Filtering](https://aip.dev/160).
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return in a single page. By
        #     default 100 and at most 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value returned from a previous list request.
        class ListMessagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#list_messages Conversations.ListMessages}.
        # @!attribute [rw] messages
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::Message>]
        #     The list of messages. There will be a maximum number of items
        #     returned based on the page_size field in the request.
        #     `messages` is sorted by `create_time` in descending order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are
        #     no more results in the list.
        class ListMessagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a phone number for telephony integration. It allows for connecting
        # a particular conversation over telephony.
        # @!attribute [r] country_code
        #   @return [::Integer]
        #     Output only. Desired country code for the phone number.
        # @!attribute [r] phone_number
        #   @return [::String]
        #     Output only. The phone number to connect to this conversation.
        class ConversationPhoneNumber
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for [ConversationsService.IngestContextReferences][].
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Required. Resource identifier of the conversation to ingest context
        #     information for. Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] context_references
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference}]
        #     Required. The context references to ingest. The key is the name of the
        #     context reference and the value contains the contents of the context
        #     reference. The key is used to incorporate ingested context references to
        #     enhance the generator.
        class IngestContextReferencesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference]
          class ContextReferencesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response message for [ConversationsService.IngestContextReferences][].
        # @!attribute [rw] ingested_context_references
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference}]
        #     All context references ingested.
        class IngestContextReferencesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference]
          class IngestedContextReferencesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#suggest_conversation_summary Conversations.SuggestConversationSummary}.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Required. The conversation to fetch suggestion for.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message used as context for
        #     compiling suggestion. If empty, the latest message of the conversation will
        #     be used.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Optional. Max number of messages prior to and including
        #     [latest_message] to use as context when compiling the
        #     suggestion. By default 500 and at most 1000.
        # @!attribute [rw] assist_query_params
        #   @return [::Google::Cloud::Dialogflow::V2::AssistQueryParameters]
        #     Optional. Parameters for a human assist query. Only used for POC/demo
        #     purpose.
        class SuggestConversationSummaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#suggest_conversation_summary Conversations.SuggestConversationSummary}.
        # @!attribute [rw] summary
        #   @return [::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryResponse::Summary]
        #     Generated summary.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used as context for
        #     compiling suggestion.
        #
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryResponse#latest_message latest_message}
        #     used to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryRequest#context_size SuggestConversationSummaryRequest.context_size}
        #     field in the request if there weren't that many messages in the
        #     conversation.
        class SuggestConversationSummaryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Generated summary for a conversation.
          # @!attribute [rw] text
          #   @return [::String]
          #     The summary content that is concatenated into one string.
          # @!attribute [rw] text_sections
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The summary content that is divided into sections. The key is the
          #     section's name and the value is the section's content. There is no
          #     specific format for the key or value.
          # @!attribute [rw] answer_record
          #   @return [::String]
          #     The name of the answer record. Format:
          #     "projects/<Project ID>/answerRecords/<Answer Record ID>"
          # @!attribute [rw] baseline_model_version
          #   @return [::String]
          #     The baseline model version used to generate this summary. It is empty if
          #     a baseline model was not used to generate this summary.
          class Summary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TextSectionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_stateless_summary Conversations.GenerateStatelessSummary}.
        # @!attribute [rw] stateless_conversation
        #   @return [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest::MinimalConversation]
        #     Required. The conversation to suggest a summary for.
        # @!attribute [rw] conversation_profile
        #   @return [::Google::Cloud::Dialogflow::V2::ConversationProfile]
        #     Required. A ConversationProfile containing information required for Summary
        #     generation.
        #     Required fields: \\{language_code, security_settings}
        #     Optional fields: \\{agent_assistant_config}
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message used as context for
        #     generating a Summary. If empty, the latest message of the conversation will
        #     be used. The format is specific to the user and the names of the messages
        #     provided.
        # @!attribute [rw] max_context_size
        #   @return [::Integer]
        #     Optional. Max number of messages prior to and including
        #     [latest_message] to use as context when compiling the
        #     suggestion. By default 500 and at most 1000.
        class GenerateStatelessSummaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The minimum amount of information required to generate a Summary without
          # having a Conversation resource created.
          # @!attribute [rw] messages
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::Message>]
          #     Required. The messages that the Summary will be generated from. It is
          #     expected that this message content is already redacted and does not
          #     contain any PII. Required fields: {content, language_code, participant,
          #     participant_role} Optional fields: \\{send_time} If send_time is not
          #     provided, then the messages must be provided in chronological order.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource to charge for the Summary's generation.
          #     Format: `projects/<Project ID>/locations/<Location ID>`.
          class MinimalConversation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_stateless_summary Conversations.GenerateStatelessSummary}.
        # @!attribute [rw] summary
        #   @return [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryResponse::Summary]
        #     Generated summary.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     The name of the latest conversation message used as context for
        #     compiling suggestion. The format is specific to the user and the names of
        #     the messages provided.
        # @!attribute [rw] context_size
        #   @return [::Integer]
        #     Number of messages prior to and including
        #     {::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryResponse#latest_message latest_message}
        #     used to compile the suggestion. It may be smaller than the
        #     {::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest#max_context_size GenerateStatelessSummaryRequest.max_context_size}
        #     field in the request if there weren't that many messages in the
        #     conversation.
        class GenerateStatelessSummaryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Generated summary for a conversation.
          # @!attribute [rw] text
          #   @return [::String]
          #     The summary content that is concatenated into one string.
          # @!attribute [rw] text_sections
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The summary content that is divided into sections. The key is the
          #     section's name and the value is the section's content. There is no
          #     specific format for the key or value.
          # @!attribute [rw] baseline_model_version
          #   @return [::String]
          #     The baseline model version used to generate this summary. It is empty if
          #     a baseline model was not used to generate this summary.
          class Summary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TextSectionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_stateless_suggestion Conversations.GenerateStatelessSuggestion}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource to charge for the Suggestion's generation.
        #     Format: `projects/<Project ID>/locations/<Location ID>`.
        # @!attribute [rw] generator
        #   @return [::Google::Cloud::Dialogflow::V2::Generator]
        #     Uncreated generator. It should be a complete generator that includes all
        #     information about the generator.
        #
        #     Note: The following fields are mutually exclusive: `generator`, `generator_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] generator_name
        #   @return [::String]
        #     The resource name of the existing created generator. Format:
        #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
        #
        #     Note: The following fields are mutually exclusive: `generator_name`, `generator`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] context_references
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference}]
        #     Optional. A section of ingested context information. The key is the name of
        #     the context reference and the value contains the contents of the context
        #     reference. The key is used to incorporate ingested context references to
        #     enhance the generator.
        # @!attribute [rw] conversation_context
        #   @return [::Google::Cloud::Dialogflow::V2::ConversationContext]
        #     Optional. Context of the conversation, including transcripts.
        # @!attribute [rw] trigger_events
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::TriggerEvent>]
        #     Optional. A list of trigger events. Generator will be triggered only if
        #     it's trigger event is included here.
        # @!attribute [rw] security_settings
        #   @return [::String]
        #     Optional. Name of the CX SecuritySettings which is used to redact generated
        #     response. If this field is empty, try to fetch v2 security_settings, which
        #     is a project level setting. If this field is empty and no v2
        #     security_settings set up in this project, no redaction will be done.
        #
        #     Format:
        #     `projects/<Project ID>/locations/<Location ID>/securitySettings/<Security
        #     Settings ID>`.
        class GenerateStatelessSuggestionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dialogflow::V2::Conversation::ContextReference]
          class ContextReferencesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_stateless_suggestion Conversations.GenerateStatelessSuggestion}.
        # @!attribute [rw] generator_suggestion
        #   @return [::Google::Cloud::Dialogflow::V2::GeneratorSuggestion]
        #     Required. Generated suggestion for a conversation.
        class GenerateStatelessSuggestionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#search_knowledge Conversations.SearchKnowledge}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource contains the conversation profile
        #     Format: 'projects/<Project ID>' or `projects/<Project
        #     ID>/locations/<Location ID>`.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::Dialogflow::V2::TextInput]
        #     Required. The natural language text query for knowledge search.
        # @!attribute [rw] conversation_profile
        #   @return [::String]
        #     Required. The conversation profile used to configure the search.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversationProfiles/<Conversation Profile ID>`.
        # @!attribute [rw] session_id
        #   @return [::String]
        #     Required. The ID of the search session.
        #     The session_id can be combined with Dialogflow V3 Agent ID retrieved from
        #     conversation profile or on its own to identify a search session. The search
        #     history of the same session will impact the search result. It's up to the
        #     API caller to choose an appropriate `Session ID`. It can be a random number
        #     or some type of session identifiers (preferably hashed). The length must
        #     not exceed 36 characters.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Optional. The conversation (between human agent and end user) where the
        #     search request is triggered. Format: `projects/<Project
        #     ID>/locations/<Location ID>/conversations/<Conversation ID>`.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message when the request is
        #     triggered.
        #     Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] query_source
        #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::QuerySource]
        #     Optional. The source of the query in the request.
        # @!attribute [rw] end_user_metadata
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Information about the end-user to improve the relevance and
        #     accuracy of generative answers.
        #
        #     This will be interpreted and used by a language model, so, for good
        #     results, the data should be self-descriptive, and in a simple structure.
        #
        #     Example:
        #
        #     ```json
        #     {
        #       "subscription plan": "Business Premium Plus",
        #       "devices owned": [
        #         \\{"model": "Google Pixel 7"},
        #         \\{"model": "Google Pixel Tablet"}
        #       ]
        #     }
        #     ```
        # @!attribute [rw] search_config
        #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig]
        #     Optional. Configuration specific to search queries with data stores.
        # @!attribute [rw] exact_search
        #   @return [::Boolean]
        #     Optional. Whether to search the query exactly without query rewrite.
        class SearchKnowledgeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration specific to search queries with data stores.
          # @!attribute [rw] boost_specs
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs>]
          #     Optional. Boost specifications for data stores.
          #
          #     Maps from datastore name to their boost configuration. Do not specify
          #     more than one BoostSpecs for each datastore name. If multiple BoostSpecs
          #     are provided for the same datastore name, the behavior is undefined.
          # @!attribute [rw] filter_specs
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::FilterSpecs>]
          #     Optional. Filter specification for data store queries.
          #
          #     TMaps from datastore name to the filter expression for that datastore. Do
          #     not specify more than one FilterSpecs for each datastore name. If
          #     multiple FilterSpecs are provided for the same datastore name, the
          #     behavior is undefined.
          class SearchConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Boost specifications for data stores.
            # @!attribute [rw] data_stores
            #   @return [::Array<::String>]
            #     Optional. Data Stores where the boosting configuration is applied. The
            #     full names of the referenced data stores. Formats:
            #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
            #     `projects/{project}/locations/{location}/dataStores/{data_store}`
            # @!attribute [rw] spec
            #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec>]
            #     Optional. A list of boosting specifications.
            class BoostSpecs
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Boost specification to boost certain documents.
              # A copy of google.cloud.discoveryengine.v1main.BoostSpec, field
              # documentation is available at
              # https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
              # @!attribute [rw] condition_boost_specs
              #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec::ConditionBoostSpec>]
              #     Optional. Condition boost specifications. If a document matches
              #     multiple conditions in the specifications, boost scores from these
              #     specifications are all applied and combined in a non-linear way.
              #     Maximum number of specifications is 20.
              class BoostSpec
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Boost applies to documents which match a condition.
                # @!attribute [rw] condition
                #   @return [::String]
                #     Optional. An expression which specifies a boost condition. The
                #     syntax and supported fields are the same as a filter expression.
                #     Examples:
                #
                #     * To boost documents with document ID "doc_1" or "doc_2", and
                #     color
                #       "Red" or "Blue":
                #         * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
                # @!attribute [rw] boost
                #   @return [::Float]
                #     Optional. Strength of the condition boost, which should be in [-1,
                #     1]. Negative boost means demotion. Default is 0.0.
                #
                #     Setting to 1.0 gives the document a big promotion. However, it does
                #     not necessarily mean that the boosted document will be the top
                #     result at all times, nor that other documents will be excluded.
                #     Results could still be shown even when none of them matches the
                #     condition. And results that are significantly more relevant to the
                #     search query can still trump your heavily favored but irrelevant
                #     documents.
                #
                #     Setting to -1.0 gives the document a big demotion. However, results
                #     that are deeply relevant might still be shown. The document will
                #     have an upstream battle to get a fairly high ranking, but it is not
                #     blocked out completely.
                #
                #     Setting to 0.0 means no boost applied. The boosting condition is
                #     ignored.
                # @!attribute [rw] boost_control_spec
                #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec::ConditionBoostSpec::BoostControlSpec]
                #     Optional. Complex specification for custom ranking based on
                #     customer defined attribute value.
                class ConditionBoostSpec
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods

                  # Specification for custom ranking based on customer specified
                  # attribute
                  # value. It provides more controls for customized ranking than the
                  # simple (condition, boost) combination above.
                  # @!attribute [rw] field_name
                  #   @return [::String]
                  #     Optional. The name of the field whose value will be used to
                  #     determine the boost amount.
                  # @!attribute [rw] attribute_type
                  #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec::ConditionBoostSpec::BoostControlSpec::AttributeType]
                  #     Optional. The attribute type to be used to determine the boost
                  #     amount. The attribute value can be derived from the field value
                  #     of the specified field_name. In the case of numerical it is
                  #     straightforward i.e. attribute_value = numerical_field_value. In
                  #     the case of freshness however, attribute_value = (time.now() -
                  #     datetime_field_value).
                  # @!attribute [rw] interpolation_type
                  #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec::ConditionBoostSpec::BoostControlSpec::InterpolationType]
                  #     Optional. The interpolation type to be applied to connect the
                  #     control points listed below.
                  # @!attribute [rw] control_points
                  #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig::BoostSpecs::BoostSpec::ConditionBoostSpec::BoostControlSpec::ControlPoint>]
                  #     Optional. The control points used to define the curve. The
                  #     monotonic function (defined through the interpolation_type above)
                  #     passes through the control points listed here.
                  class BoostControlSpec
                    include ::Google::Protobuf::MessageExts
                    extend ::Google::Protobuf::MessageExts::ClassMethods

                    # The control points used to define the curve. The curve defined
                    # through these control points can only be monotonically increasing
                    # or decreasing(constant values are acceptable).
                    # @!attribute [rw] attribute_value
                    #   @return [::String]
                    #     Optional. Can be one of:
                    #     1. The numerical field value.
                    #     2. The duration spec for freshness:
                    #     The value must be formatted as an XSD `dayTimeDuration` value
                    #     (a restricted subset of an ISO 8601 duration value). The
                    #     pattern for this is: `[nD][T[nH][nM][nS]]`.
                    # @!attribute [rw] boost_amount
                    #   @return [::Float]
                    #     Optional. The value between -1 to 1 by which to boost the score
                    #     if the attribute_value evaluates to the value specified above.
                    class ControlPoint
                      include ::Google::Protobuf::MessageExts
                      extend ::Google::Protobuf::MessageExts::ClassMethods
                    end

                    # The attribute(or function) for which the custom ranking is to be
                    # applied.
                    module AttributeType
                      # Unspecified AttributeType.
                      ATTRIBUTE_TYPE_UNSPECIFIED = 0

                      # The value of the numerical field will be used to dynamically
                      # update the boost amount. In this case, the attribute_value (the
                      # x value) of the control point will be the actual value of the
                      # numerical field for which the boost_amount is specified.
                      NUMERICAL = 1

                      # For the freshness use case the attribute value will be the
                      # duration between the current time and the date in the datetime
                      # field specified. The value must be formatted as an XSD
                      # `dayTimeDuration` value (a restricted subset of an ISO 8601
                      # duration value). The pattern for this is:
                      # `[nD][T[nH][nM][nS]]`. E.g. `5D`, `3DT12H30M`, `T24H`.
                      FRESHNESS = 2
                    end

                    # The interpolation type to be applied. Default will be linear
                    # (Piecewise Linear).
                    module InterpolationType
                      # Interpolation type is unspecified. In this case, it defaults to
                      # Linear.
                      INTERPOLATION_TYPE_UNSPECIFIED = 0

                      # Piecewise linear interpolation will be applied.
                      LINEAR = 1
                    end
                  end
                end
              end
            end

            # Filter specification for data store queries.
            # @!attribute [rw] data_stores
            #   @return [::Array<::String>]
            #     Optional. The data store where the filter configuration is applied.
            #     Full resource name of data store, such as
            #     projects/\\{project}/locations/\\{location}/collections/\\{collectionId}/
            #     dataStores/\\{dataStoreId}.
            # @!attribute [rw] filter
            #   @return [::String]
            #     Optional. The filter expression to be applied.
            #     Expression syntax is documented at
            #     https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax
            class FilterSpecs
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The source of the query. We use QuerySource to distinguish queries directly
          # entered by agents and suggested queries from
          # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_knowledge_assist Participants.SuggestKnowledgeAssist}.
          # If SUGGESTED_QUERY source is specified, we will treat it as a continuation
          # of a SuggestKnowledgeAssist call.
          module QuerySource
            # Unknown query source.
            QUERY_SOURCE_UNSPECIFIED = 0

            # The query is from agents.
            AGENT_QUERY = 1

            # The query is a suggested query from
            # {::Google::Cloud::Dialogflow::V2::Participants::Client#suggest_knowledge_assist Participants.SuggestKnowledgeAssist}.
            SUGGESTED_QUERY = 2
          end
        end

        # The response message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#search_knowledge Conversations.SearchKnowledge}.
        # @!attribute [rw] answers
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeAnswer>]
        #     Most relevant snippets extracted from articles in the given knowledge base,
        #     ordered by confidence.
        # @!attribute [rw] rewritten_query
        #   @return [::String]
        #     The rewritten query used to search knowledge.
        class SearchKnowledgeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a SearchKnowledge answer.
        # @!attribute [rw] answer
        #   @return [::String]
        #     The piece of text from the knowledge base documents that answers
        #     the search query
        # @!attribute [rw] answer_type
        #   @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeAnswer::AnswerType]
        #     The type of the answer.
        # @!attribute [rw] answer_sources
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::SearchKnowledgeAnswer::AnswerSource>]
        #     All sources used to generate the answer.
        # @!attribute [rw] answer_record
        #   @return [::String]
        #     The name of the answer record.
        #     Format: `projects/<Project ID>/locations/<location ID>/answer
        #     Records/<Answer Record ID>`
        class SearchKnowledgeAnswer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The sources of the answers.
          # @!attribute [rw] title
          #   @return [::String]
          #     The title of the article.
          # @!attribute [rw] uri
          #   @return [::String]
          #     The URI of the article.
          # @!attribute [rw] snippet
          #   @return [::String]
          #     The relevant snippet of the article.
          # @!attribute [rw] metadata
          #   @return [::Google::Protobuf::Struct]
          #     Metadata associated with the article.
          class AnswerSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of the answer.
          module AnswerType
            # The answer has a unspecified type.
            ANSWER_TYPE_UNSPECIFIED = 0

            # The answer is from FAQ documents.
            FAQ = 1

            # The answer is from generative model.
            GENERATIVE = 2

            # The answer is from intent matching.
            INTENT = 3
          end
        end

        # The request message for
        # {::Google::Cloud::Dialogflow::V2::Conversations::Client#generate_suggestions Conversations.GenerateSuggestions}.
        # @!attribute [rw] conversation
        #   @return [::String]
        #     Required. The conversation for which the suggestions are generated. Format:
        #     `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>`.
        #
        #     The conversation must be created with a conversation profile which has
        #     generators configured in it to be able to get suggestions.
        # @!attribute [rw] latest_message
        #   @return [::String]
        #     Optional. The name of the latest conversation message for which the request
        #     is triggered. Format: `projects/<Project ID>/locations/<Location
        #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
        # @!attribute [rw] trigger_events
        #   @return [::Array<::Google::Cloud::Dialogflow::V2::TriggerEvent>]
        #     Optional. A list of trigger events. Only generators configured in the
        #     conversation_profile whose trigger_event is listed here will be triggered.
        class GenerateSuggestionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
