# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        # Agent Coaching instructions that customer can configure.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name for the instruction.
        # @!attribute [rw] display_details
        #   @return [::String]
        #     Optional. The detailed description of this instruction.
        # @!attribute [rw] condition
        #   @return [::String]
        #     Optional. The condition of the instruction. For example, "the customer
        #     wants to cancel an order".  If the users want the instruction to be
        #     triggered unconditionally, the condition can be empty.
        # @!attribute [rw] agent_action
        #   @return [::String]
        #     Optional. The action that human agent should take. For example, "apologize
        #     for the slow shipping". If the users only want to use agent coaching for
        #     intent detection, agent_action can be empty
        # @!attribute [rw] system_action
        #   @return [::String]
        #     Optional. The action that system should take. For example,
        #     "call GetOrderTime with order_number={order number provided by the
        #     customer}". If the users don't have plugins or don't want to trigger
        #     plugins, the system_action can be empty
        # @!attribute [r] duplicate_check_result
        #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingInstruction::DuplicateCheckResult]
        #     Output only. Duplication check for the AgentCoachingInstruction.
        # @!attribute [rw] triggering_event
        #   @return [::Google::Cloud::Dialogflow::V2::AgentCoachingInstruction::TriggerEvent]
        #     Optional. The event that should trigger this instruction.
        #     If UNSPECIFIED, the instruction triggering will be same as the generator's
        #     trigger_event.
        class AgentCoachingInstruction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Duplication check for the suggestion.
          # @!attribute [r] duplicate_suggestions
          #   @return [::Array<::Google::Cloud::Dialogflow::V2::AgentCoachingInstruction::DuplicateCheckResult::DuplicateSuggestion>]
          #     Output only. The duplicate suggestions.
          class DuplicateCheckResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The duplicate suggestion details.
            # @!attribute [r] answer_record
            #   @return [::String]
            #     Output only. The answer record id of the past duplicate suggestion.
            # @!attribute [r] suggestion_index
            #   @return [::Integer]
            #     Output only. The index of the duplicate suggestion in the past
            #     suggestion list.
            # @!attribute [r] similarity_score
            #   @return [::Float]
            #     Output only. The similarity score of between the past and current
            #     suggestion.
            class DuplicateSuggestion
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The event that should trigger this instruction.
          module TriggerEvent
            # Default value for TriggerEvent.
            TRIGGER_EVENT_UNSPECIFIED = 0

            # Triggers when each chat message or voice utterance ends.
            END_OF_UTTERANCE = 1

            # Triggers on the conversation manually by API calls.
            MANUAL_CALL = 2

            # Triggers after each customer message.
            CUSTOMER_MESSAGE = 3

            # Triggers after each agent message.
            AGENT_MESSAGE = 4

            # Triggers on tool call completion.
            TOOL_CALL_COMPLETION = 5
          end
        end
      end
    end
  end
end
