# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/v2/participant_pb"
require "google/cloud/dialogflow/v2/participants/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module V2
        module Participants
          module Rest
            ##
            # REST client for the Participants service.
            #
            # Service for managing {::Google::Cloud::Dialogflow::V2::Participant Participants}.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :participants_stub

              ##
              # Configure the Participants Client class.
              #
              # See {::Google::Cloud::Dialogflow::V2::Participants::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Participants clients
              #   ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dialogflow", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.analyze_content.timeout = 220.0
                  default_config.rpcs.analyze_content.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Participants Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dialogflow::V2::Participants::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @participants_stub.universe_domain
              end

              ##
              # Create a new Participants REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Participants client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @participants_stub = ::Google::Cloud::Dialogflow::V2::Participants::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @participants_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @participants_stub.endpoint
                  config.universe_domain = @participants_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @participants_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @participants_stub.logger
              end

              # Service calls

              ##
              # Creates a new participant in a conversation.
              #
              # @overload create_participant(request, options = nil)
              #   Pass arguments to `create_participant` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::CreateParticipantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::CreateParticipantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_participant(parent: nil, participant: nil)
              #   Pass arguments to `create_participant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource identifier of the conversation adding the participant.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              #   @param participant [::Google::Cloud::Dialogflow::V2::Participant, ::Hash]
              #     Required. The participant to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Participant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Participant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::CreateParticipantRequest.new
              #
              #   # Call the create_participant method.
              #   result = client.create_participant request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Participant.
              #   p result
              #
              def create_participant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::CreateParticipantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_participant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_participant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_participant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.create_participant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a conversation participant.
              #
              # @overload get_participant(request, options = nil)
              #   Pass arguments to `get_participant` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GetParticipantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GetParticipantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_participant(name: nil)
              #   Pass arguments to `get_participant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the participant. Format:
              #     `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
              #     ID>/participants/<Participant ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Participant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Participant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GetParticipantRequest.new
              #
              #   # Call the get_participant method.
              #   result = client.get_participant request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Participant.
              #   p result
              #
              def get_participant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GetParticipantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_participant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_participant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_participant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.get_participant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the list of all participants in the specified conversation.
              #
              # @overload list_participants(request, options = nil)
              #   Pass arguments to `list_participants` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ListParticipantsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ListParticipantsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_participants(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_participants` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The conversation to list all participants from.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return in a single page. By
              #     default 100 and at most 1000.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous list request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Participant>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Participant>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ListParticipantsRequest.new
              #
              #   # Call the list_participants method.
              #   result = client.list_participants request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dialogflow::V2::Participant.
              #     p item
              #   end
              #
              def list_participants request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ListParticipantsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_participants.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_participants.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_participants.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.list_participants request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @participants_stub, :list_participants, "participants", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified participant.
              #
              # @overload update_participant(request, options = nil)
              #   Pass arguments to `update_participant` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_participant(participant: nil, update_mask: nil)
              #   Pass arguments to `update_participant` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param participant [::Google::Cloud::Dialogflow::V2::Participant, ::Hash]
              #     Required. The participant to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The mask to specify which fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Participant]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Participant]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::UpdateParticipantRequest.new
              #
              #   # Call the update_participant method.
              #   result = client.update_participant request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Participant.
              #   p result
              #
              def update_participant request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::UpdateParticipantRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_participant.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_participant.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_participant.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.update_participant request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a text (chat, for example), or audio (phone recording, for example)
              # message from a participant into the conversation.
              #
              # Note: Always use agent versions for production traffic
              # sent to virtual agents. See [Versions and
              # environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
              #
              # @overload analyze_content(request, options = nil)
              #   Pass arguments to `analyze_content` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload analyze_content(participant: nil, text_input: nil, audio_input: nil, event_input: nil, suggestion_input: nil, reply_audio_config: nil, query_params: nil, assist_query_params: nil, cx_parameters: nil, request_id: nil)
              #   Pass arguments to `analyze_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param participant [::String]
              #     Required. The name of the participant this text comes from.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
              #   @param text_input [::Google::Cloud::Dialogflow::V2::TextInput, ::Hash]
              #     The natural language text to be processed.
              #
              #     Note: The following parameters are mutually exclusive: `text_input`, `audio_input`, `event_input`, `suggestion_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param audio_input [::Google::Cloud::Dialogflow::V2::AudioInput, ::Hash]
              #     The natural language speech audio to be processed.
              #
              #     Note: The following parameters are mutually exclusive: `audio_input`, `text_input`, `event_input`, `suggestion_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param event_input [::Google::Cloud::Dialogflow::V2::EventInput, ::Hash]
              #     An input event to send to Dialogflow.
              #
              #     Note: The following parameters are mutually exclusive: `event_input`, `text_input`, `audio_input`, `suggestion_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param suggestion_input [::Google::Cloud::Dialogflow::V2::SuggestionInput, ::Hash]
              #     An input representing the selection of a suggestion.
              #
              #     Note: The following parameters are mutually exclusive: `suggestion_input`, `text_input`, `audio_input`, `event_input`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param reply_audio_config [::Google::Cloud::Dialogflow::V2::OutputAudioConfig, ::Hash]
              #     Speech synthesis configuration.
              #     The speech synthesis settings for a virtual agent that may be configured
              #     for the associated conversation profile are not used when calling
              #     AnalyzeContent. If this configuration is not supplied, speech synthesis
              #     is disabled.
              #   @param query_params [::Google::Cloud::Dialogflow::V2::QueryParameters, ::Hash]
              #     Parameters for a Dialogflow virtual-agent query.
              #   @param assist_query_params [::Google::Cloud::Dialogflow::V2::AssistQueryParameters, ::Hash]
              #     Parameters for a human assist query.
              #   @param cx_parameters [::Google::Protobuf::Struct, ::Hash]
              #     Additional parameters to be put into Dialogflow CX session parameters. To
              #     remove a parameter from the session, clients should explicitly set the
              #     parameter value to null.
              #
              #     Note: this field should only be used if you are connecting to a Dialogflow
              #     CX agent.
              #   @param request_id [::String]
              #     A unique identifier for this request. Restricted to 36 ASCII characters.
              #     A random UUID is recommended.
              #     This request is only idempotent if a `request_id` is provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::AnalyzeContentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::AnalyzeContentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::AnalyzeContentRequest.new
              #
              #   # Call the analyze_content method.
              #   result = client.analyze_content request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::AnalyzeContentResponse.
              #   p result
              #
              def analyze_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::AnalyzeContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.analyze_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.analyze_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.analyze_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.analyze_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets suggested articles for a participant based on specific historical
              # messages.
              #
              # @overload suggest_articles(request, options = nil)
              #   Pass arguments to `suggest_articles` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_articles(parent: nil, latest_message: nil, context_size: nil, assist_query_params: nil)
              #   Pass arguments to `suggest_articles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the participant to fetch suggestion for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message to compile suggestion
              #     for. If empty, it will be the latest message of the conversation.
              #
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param context_size [::Integer]
              #     Optional. Max number of messages prior to and including
              #     {::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest#latest_message latest_message}
              #     to use as context when compiling the suggestion. By default 20 and at
              #     most 50.
              #   @param assist_query_params [::Google::Cloud::Dialogflow::V2::AssistQueryParameters, ::Hash]
              #     Parameters for a human assist query.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SuggestArticlesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SuggestArticlesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SuggestArticlesRequest.new
              #
              #   # Call the suggest_articles method.
              #   result = client.suggest_articles request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SuggestArticlesResponse.
              #   p result
              #
              def suggest_articles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SuggestArticlesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_articles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_articles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_articles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.suggest_articles request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets suggested faq answers for a participant based on specific historical
              # messages.
              #
              # @overload suggest_faq_answers(request, options = nil)
              #   Pass arguments to `suggest_faq_answers` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_faq_answers(parent: nil, latest_message: nil, context_size: nil, assist_query_params: nil)
              #   Pass arguments to `suggest_faq_answers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the participant to fetch suggestion for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message to compile suggestion
              #     for. If empty, it will be the latest message of the conversation.
              #
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param context_size [::Integer]
              #     Optional. Max number of messages prior to and including
              #     [latest_message] to use as context when compiling the
              #     suggestion. By default 20 and at most 50.
              #   @param assist_query_params [::Google::Cloud::Dialogflow::V2::AssistQueryParameters, ::Hash]
              #     Parameters for a human assist query.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest.new
              #
              #   # Call the suggest_faq_answers method.
              #   result = client.suggest_faq_answers request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SuggestFaqAnswersResponse.
              #   p result
              #
              def suggest_faq_answers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SuggestFaqAnswersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_faq_answers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_faq_answers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_faq_answers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.suggest_faq_answers request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets smart replies for a participant based on specific historical
              # messages.
              #
              # @overload suggest_smart_replies(request, options = nil)
              #   Pass arguments to `suggest_smart_replies` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_smart_replies(parent: nil, current_text_input: nil, latest_message: nil, context_size: nil)
              #   Pass arguments to `suggest_smart_replies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the participant to fetch suggestion for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
              #   @param current_text_input [::Google::Cloud::Dialogflow::V2::TextInput, ::Hash]
              #     The current natural language text segment to compile suggestion
              #     for. This provides a way for user to get follow up smart reply suggestion
              #     after a smart reply selection, without sending a text message.
              #   @param latest_message [::String]
              #     The name of the latest conversation message to compile suggestion
              #     for. If empty, it will be the latest message of the conversation.
              #
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param context_size [::Integer]
              #     Max number of messages prior to and including
              #     [latest_message] to use as context when compiling the
              #     suggestion. By default 20 and at most 50.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest.new
              #
              #   # Call the suggest_smart_replies method.
              #   result = client.suggest_smart_replies request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SuggestSmartRepliesResponse.
              #   p result
              #
              def suggest_smart_replies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SuggestSmartRepliesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_smart_replies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_smart_replies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_smart_replies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.suggest_smart_replies request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets knowledge assist suggestions based on historical messages.
              #
              # @overload suggest_knowledge_assist(request, options = nil)
              #   Pass arguments to `suggest_knowledge_assist` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_knowledge_assist(parent: nil, latest_message: nil, context_size: nil, previous_suggested_query: nil)
              #   Pass arguments to `suggest_knowledge_assist` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the participant to fetch suggestions for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message to compile
              #     suggestions for. If empty, it will be the latest message of the
              #     conversation. Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param context_size [::Integer]
              #     Optional. Max number of messages prior to and including
              #     {::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest#latest_message latest_message}
              #     to use as context when compiling the suggestion. The context size is by
              #     default 100 and at most 100.
              #   @param previous_suggested_query [::String]
              #     Optional. The previously suggested query for the given conversation. This
              #     helps identify whether the next suggestion we generate is reasonably
              #     different from the previous one. This is useful to avoid similar
              #     suggestions within the conversation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest.new
              #
              #   # Call the suggest_knowledge_assist method.
              #   result = client.suggest_knowledge_assist request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistResponse.
              #   p result
              #
              def suggest_knowledge_assist request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SuggestKnowledgeAssistRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_knowledge_assist.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_knowledge_assist.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_knowledge_assist.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @participants_stub.suggest_knowledge_assist request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Participants REST API.
              #
              # This class represents the configuration for Participants REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dialogflow::V2::Participants::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_participant to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_participant.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dialogflow::V2::Participants::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_participant.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Participants API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_participant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_participant
                  ##
                  # RPC-specific configuration for `get_participant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_participant
                  ##
                  # RPC-specific configuration for `list_participants`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_participants
                  ##
                  # RPC-specific configuration for `update_participant`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_participant
                  ##
                  # RPC-specific configuration for `analyze_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :analyze_content
                  ##
                  # RPC-specific configuration for `suggest_articles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_articles
                  ##
                  # RPC-specific configuration for `suggest_faq_answers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_faq_answers
                  ##
                  # RPC-specific configuration for `suggest_smart_replies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_smart_replies
                  ##
                  # RPC-specific configuration for `suggest_knowledge_assist`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_knowledge_assist

                  # @private
                  def initialize parent_rpcs = nil
                    create_participant_config = parent_rpcs.create_participant if parent_rpcs.respond_to? :create_participant
                    @create_participant = ::Gapic::Config::Method.new create_participant_config
                    get_participant_config = parent_rpcs.get_participant if parent_rpcs.respond_to? :get_participant
                    @get_participant = ::Gapic::Config::Method.new get_participant_config
                    list_participants_config = parent_rpcs.list_participants if parent_rpcs.respond_to? :list_participants
                    @list_participants = ::Gapic::Config::Method.new list_participants_config
                    update_participant_config = parent_rpcs.update_participant if parent_rpcs.respond_to? :update_participant
                    @update_participant = ::Gapic::Config::Method.new update_participant_config
                    analyze_content_config = parent_rpcs.analyze_content if parent_rpcs.respond_to? :analyze_content
                    @analyze_content = ::Gapic::Config::Method.new analyze_content_config
                    suggest_articles_config = parent_rpcs.suggest_articles if parent_rpcs.respond_to? :suggest_articles
                    @suggest_articles = ::Gapic::Config::Method.new suggest_articles_config
                    suggest_faq_answers_config = parent_rpcs.suggest_faq_answers if parent_rpcs.respond_to? :suggest_faq_answers
                    @suggest_faq_answers = ::Gapic::Config::Method.new suggest_faq_answers_config
                    suggest_smart_replies_config = parent_rpcs.suggest_smart_replies if parent_rpcs.respond_to? :suggest_smart_replies
                    @suggest_smart_replies = ::Gapic::Config::Method.new suggest_smart_replies_config
                    suggest_knowledge_assist_config = parent_rpcs.suggest_knowledge_assist if parent_rpcs.respond_to? :suggest_knowledge_assist
                    @suggest_knowledge_assist = ::Gapic::Config::Method.new suggest_knowledge_assist_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
