# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        module Participants
          # Path helper methods for the Participants API.
          module Paths
            ##
            # Create a fully-qualified Context resource string.
            #
            # @overload context_path(project:, session:, context:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent/sessions/{session}/contexts/{context}`
            #
            #   @param project [String]
            #   @param session [String]
            #   @param context [String]
            #
            # @overload context_path(project:, environment:, user:, session:, context:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}`
            #
            #   @param project [String]
            #   @param environment [String]
            #   @param user [String]
            #   @param session [String]
            #   @param context [String]
            #
            # @overload context_path(project:, location:, session:, context:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param session [String]
            #   @param context [String]
            #
            # @overload context_path(project:, location:, environment:, user:, session:, context:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param environment [String]
            #   @param user [String]
            #   @param session [String]
            #   @param context [String]
            #
            # @return [::String]
            def context_path **args
              resources = {
                "context:project:session" => (proc do |project:, session:, context:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/agent/sessions/#{session}/contexts/#{context}"
                end),
                "context:environment:project:session:user" => (proc do |project:, environment:, user:, session:, context:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"
                  raise ::ArgumentError, "user cannot contain /" if user.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/agent/environments/#{environment}/users/#{user}/sessions/#{session}/contexts/#{context}"
                end),
                "context:location:project:session" => (proc do |project:, location:, session:, context:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent/sessions/#{session}/contexts/#{context}"
                end),
                "context:environment:location:project:session:user" => (proc do |project:, location:, environment:, user:, session:, context:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"
                  raise ::ArgumentError, "user cannot contain /" if user.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent/environments/#{environment}/users/#{user}/sessions/#{session}/contexts/#{context}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Conversation resource string.
            #
            # @overload conversation_path(project:, conversation:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/conversations/{conversation}`
            #
            #   @param project [String]
            #   @param conversation [String]
            #
            # @overload conversation_path(project:, location:, conversation:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/conversations/{conversation}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param conversation [String]
            #
            # @return [::String]
            def conversation_path **args
              resources = {
                "conversation:project" => (proc do |project:, conversation:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/conversations/#{conversation}"
                end),
                "conversation:location:project" => (proc do |project:, location:, conversation:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/conversations/#{conversation}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Message resource string.
            #
            # @overload message_path(project:, conversation:, message:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/conversations/{conversation}/messages/{message}`
            #
            #   @param project [String]
            #   @param conversation [String]
            #   @param message [String]
            #
            # @overload message_path(project:, location:, conversation:, message:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/conversations/{conversation}/messages/{message}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param conversation [String]
            #   @param message [String]
            #
            # @return [::String]
            def message_path **args
              resources = {
                "conversation:message:project" => (proc do |project:, conversation:, message:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "conversation cannot contain /" if conversation.to_s.include? "/"

                  "projects/#{project}/conversations/#{conversation}/messages/#{message}"
                end),
                "conversation:location:message:project" => (proc do |project:, location:, conversation:, message:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "conversation cannot contain /" if conversation.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/conversations/#{conversation}/messages/#{message}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Participant resource string.
            #
            # @overload participant_path(project:, conversation:, participant:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/conversations/{conversation}/participants/{participant}`
            #
            #   @param project [String]
            #   @param conversation [String]
            #   @param participant [String]
            #
            # @overload participant_path(project:, location:, conversation:, participant:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param conversation [String]
            #   @param participant [String]
            #
            # @return [::String]
            def participant_path **args
              resources = {
                "conversation:participant:project" => (proc do |project:, conversation:, participant:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "conversation cannot contain /" if conversation.to_s.include? "/"

                  "projects/#{project}/conversations/#{conversation}/participants/#{participant}"
                end),
                "conversation:location:participant:project" => (proc do |project:, location:, conversation:, participant:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "conversation cannot contain /" if conversation.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/conversations/#{conversation}/participants/#{participant}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified PhraseSet resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
            #
            # @param project [String]
            # @param location [String]
            # @param phrase_set [String]
            #
            # @return [::String]
            def phrase_set_path project:, location:, phrase_set:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/phraseSets/#{phrase_set}"
            end

            ##
            # Create a fully-qualified SessionEntityType resource string.
            #
            # @overload session_entity_type_path(project:, session:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param session [String]
            #   @param entity_type [String]
            #
            # @overload session_entity_type_path(project:, environment:, user:, session:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param environment [String]
            #   @param user [String]
            #   @param session [String]
            #   @param entity_type [String]
            #
            # @overload session_entity_type_path(project:, location:, session:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param session [String]
            #   @param entity_type [String]
            #
            # @overload session_entity_type_path(project:, location:, environment:, user:, session:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param environment [String]
            #   @param user [String]
            #   @param session [String]
            #   @param entity_type [String]
            #
            # @return [::String]
            def session_entity_type_path **args
              resources = {
                "entity_type:project:session" => (proc do |project:, session:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/agent/sessions/#{session}/entityTypes/#{entity_type}"
                end),
                "entity_type:environment:project:session:user" => (proc do |project:, environment:, user:, session:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"
                  raise ::ArgumentError, "user cannot contain /" if user.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/agent/environments/#{environment}/users/#{user}/sessions/#{session}/entityTypes/#{entity_type}"
                end),
                "entity_type:location:project:session" => (proc do |project:, location:, session:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent/sessions/#{session}/entityTypes/#{entity_type}"
                end),
                "entity_type:environment:location:project:session:user" => (proc do |project:, location:, environment:, user:, session:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                  raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"
                  raise ::ArgumentError, "user cannot contain /" if user.to_s.include? "/"
                  raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent/environments/#{environment}/users/#{user}/sessions/#{session}/entityTypes/#{entity_type}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
