# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/v2/intent_pb"
require "google/cloud/dialogflow/v2/intents/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module V2
        module Intents
          module Rest
            ##
            # REST client for the Intents service.
            #
            # Service for managing {::Google::Cloud::Dialogflow::V2::Intent Intents}.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :intents_stub

              ##
              # Configure the Intents Client class.
              #
              # See {::Google::Cloud::Dialogflow::V2::Intents::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Intents clients
              #   ::Google::Cloud::Dialogflow::V2::Intents::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dialogflow", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Intents Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dialogflow::V2::Intents::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @intents_stub.universe_domain
              end

              ##
              # Create a new Intents REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Intents client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dialogflow::V2::Intents::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @intents_stub = ::Google::Cloud::Dialogflow::V2::Intents::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @intents_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @intents_stub.endpoint
                  config.universe_domain = @intents_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @intents_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dialogflow::V2::Intents::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @intents_stub.logger
              end

              # Service calls

              ##
              # Returns the list of all intents in the specified agent.
              #
              # @overload list_intents(request, options = nil)
              #   Pass arguments to `list_intents` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ListIntentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ListIntentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_intents(parent: nil, language_code: nil, intent_view: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_intents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The agent to list all intents from.
              #     Format: `projects/<Project ID>/agent` or `projects/<Project
              #     ID>/locations/<Location ID>/agent`.
              #
              #     Alternatively, you can specify the environment to list intents for.
              #     Format: `projects/<Project ID>/agent/environments/<Environment ID>`
              #     or `projects/<Project ID>/locations/<Location
              #     ID>/agent/environments/<Environment ID>`.
              #     Note: training phrases of the intents will not be returned for non-draft
              #     environment.
              #   @param language_code [::String]
              #     Optional. The language used to access language-specific data.
              #     If not specified, the agent's default language is used.
              #     For more information, see
              #     [Multilingual intent and entity
              #     data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
              #   @param intent_view [::Google::Cloud::Dialogflow::V2::IntentView]
              #     Optional. The resource view to apply to the returned intent.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return in a single page. By
              #     default 100 and at most 1000.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous list request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Intent>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Intent>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ListIntentsRequest.new
              #
              #   # Call the list_intents method.
              #   result = client.list_intents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dialogflow::V2::Intent.
              #     p item
              #   end
              #
              def list_intents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ListIntentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_intents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_intents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_intents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.list_intents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @intents_stub, :list_intents, "intents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the specified intent.
              #
              # @overload get_intent(request, options = nil)
              #   Pass arguments to `get_intent` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GetIntentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GetIntentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_intent(name: nil, language_code: nil, intent_view: nil)
              #   Pass arguments to `get_intent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the intent.
              #     Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
              #   @param language_code [::String]
              #     Optional. The language used to access language-specific data.
              #     If not specified, the agent's default language is used.
              #     For more information, see
              #     [Multilingual intent and entity
              #     data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
              #   @param intent_view [::Google::Cloud::Dialogflow::V2::IntentView]
              #     Optional. The resource view to apply to the returned intent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Intent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Intent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GetIntentRequest.new
              #
              #   # Call the get_intent method.
              #   result = client.get_intent request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Intent.
              #   p result
              #
              def get_intent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GetIntentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_intent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_intent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_intent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.get_intent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an intent in the specified agent.
              #
              # Note: You should always train an agent prior to sending it queries. See the
              # [training
              # documentation](https://cloud.google.com/dialogflow/es/docs/training).
              #
              # @overload create_intent(request, options = nil)
              #   Pass arguments to `create_intent` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::CreateIntentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::CreateIntentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_intent(parent: nil, intent: nil, language_code: nil, intent_view: nil)
              #   Pass arguments to `create_intent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The agent to create a intent for.
              #     Format: `projects/<Project ID>/agent`.
              #   @param intent [::Google::Cloud::Dialogflow::V2::Intent, ::Hash]
              #     Required. The intent to create.
              #   @param language_code [::String]
              #     Optional. The language used to access language-specific data.
              #     If not specified, the agent's default language is used.
              #     For more information, see
              #     [Multilingual intent and entity
              #     data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
              #   @param intent_view [::Google::Cloud::Dialogflow::V2::IntentView]
              #     Optional. The resource view to apply to the returned intent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Intent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Intent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::CreateIntentRequest.new
              #
              #   # Call the create_intent method.
              #   result = client.create_intent request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Intent.
              #   p result
              #
              def create_intent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::CreateIntentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_intent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_intent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_intent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.create_intent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified intent.
              #
              # Note: You should always train an agent prior to sending it queries. See the
              # [training
              # documentation](https://cloud.google.com/dialogflow/es/docs/training).
              #
              # @overload update_intent(request, options = nil)
              #   Pass arguments to `update_intent` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::UpdateIntentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::UpdateIntentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_intent(intent: nil, language_code: nil, update_mask: nil, intent_view: nil)
              #   Pass arguments to `update_intent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param intent [::Google::Cloud::Dialogflow::V2::Intent, ::Hash]
              #     Required. The intent to update.
              #   @param language_code [::String]
              #     Optional. The language used to access language-specific data.
              #     If not specified, the agent's default language is used.
              #     For more information, see
              #     [Multilingual intent and entity
              #     data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The mask to control which fields get updated.
              #   @param intent_view [::Google::Cloud::Dialogflow::V2::IntentView]
              #     Optional. The resource view to apply to the returned intent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Intent]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Intent]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::UpdateIntentRequest.new
              #
              #   # Call the update_intent method.
              #   result = client.update_intent request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Intent.
              #   p result
              #
              def update_intent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::UpdateIntentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_intent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_intent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_intent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.update_intent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified intent and its direct or indirect followup intents.
              #
              # Note: You should always train an agent prior to sending it queries. See the
              # [training
              # documentation](https://cloud.google.com/dialogflow/es/docs/training).
              #
              # @overload delete_intent(request, options = nil)
              #   Pass arguments to `delete_intent` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::DeleteIntentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::DeleteIntentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_intent(name: nil)
              #   Pass arguments to `delete_intent` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the intent to delete. If this intent has direct or
              #     indirect followup intents, we also delete them.
              #     Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::DeleteIntentRequest.new
              #
              #   # Call the delete_intent method.
              #   result = client.delete_intent request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_intent request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::DeleteIntentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_intent.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_intent.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_intent.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.delete_intent request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates/Creates multiple intents in the specified agent.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`: An empty [Struct
              #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
              # - `response`:
              # {::Google::Cloud::Dialogflow::V2::BatchUpdateIntentsResponse BatchUpdateIntentsResponse}
              #
              # Note: You should always train an agent prior to sending it queries. See the
              # [training
              # documentation](https://cloud.google.com/dialogflow/es/docs/training).
              #
              # @overload batch_update_intents(request, options = nil)
              #   Pass arguments to `batch_update_intents` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::BatchUpdateIntentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::BatchUpdateIntentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_update_intents(parent: nil, intent_batch_uri: nil, intent_batch_inline: nil, language_code: nil, update_mask: nil, intent_view: nil)
              #   Pass arguments to `batch_update_intents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the agent to update or create intents in.
              #     Format: `projects/<Project ID>/agent`.
              #   @param intent_batch_uri [::String]
              #     The URI to a Google Cloud Storage file containing intents to update or
              #     create. The file format can either be a serialized proto (of IntentBatch
              #     type) or JSON object. Note: The URI must start with "gs://".
              #
              #     Note: The following parameters are mutually exclusive: `intent_batch_uri`, `intent_batch_inline`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param intent_batch_inline [::Google::Cloud::Dialogflow::V2::IntentBatch, ::Hash]
              #     The collection of intents to update or create.
              #
              #     Note: The following parameters are mutually exclusive: `intent_batch_inline`, `intent_batch_uri`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param language_code [::String]
              #     Optional. The language used to access language-specific data.
              #     If not specified, the agent's default language is used.
              #     For more information, see
              #     [Multilingual intent and entity
              #     data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. The mask to control which fields get updated.
              #   @param intent_view [::Google::Cloud::Dialogflow::V2::IntentView]
              #     Optional. The resource view to apply to the returned intent.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::BatchUpdateIntentsRequest.new
              #
              #   # Call the batch_update_intents method.
              #   result = client.batch_update_intents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_update_intents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::BatchUpdateIntentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_update_intents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_update_intents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_update_intents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.batch_update_intents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes intents in the specified agent.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`: An empty [Struct
              #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
              # - `response`: An [Empty
              #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
              #
              # Note: You should always train an agent prior to sending it queries. See the
              # [training
              # documentation](https://cloud.google.com/dialogflow/es/docs/training).
              #
              # @overload batch_delete_intents(request, options = nil)
              #   Pass arguments to `batch_delete_intents` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::BatchDeleteIntentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::BatchDeleteIntentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_delete_intents(parent: nil, intents: nil)
              #   Pass arguments to `batch_delete_intents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the agent to delete all entities types for. Format:
              #     `projects/<Project ID>/agent`.
              #   @param intents [::Array<::Google::Cloud::Dialogflow::V2::Intent, ::Hash>]
              #     Required. The collection of intents to delete. Only intent `name` must be
              #     filled in.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::BatchDeleteIntentsRequest.new
              #
              #   # Call the batch_delete_intents method.
              #   result = client.batch_delete_intents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_delete_intents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::BatchDeleteIntentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_delete_intents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_delete_intents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_delete_intents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @intents_stub.batch_delete_intents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Intents REST API.
              #
              # This class represents the configuration for Intents REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dialogflow::V2::Intents::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_intents to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dialogflow::V2::Intents::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_intents.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dialogflow::V2::Intents::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_intents.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Intents API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_intents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_intents
                  ##
                  # RPC-specific configuration for `get_intent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_intent
                  ##
                  # RPC-specific configuration for `create_intent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_intent
                  ##
                  # RPC-specific configuration for `update_intent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_intent
                  ##
                  # RPC-specific configuration for `delete_intent`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_intent
                  ##
                  # RPC-specific configuration for `batch_update_intents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_update_intents
                  ##
                  # RPC-specific configuration for `batch_delete_intents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_delete_intents

                  # @private
                  def initialize parent_rpcs = nil
                    list_intents_config = parent_rpcs.list_intents if parent_rpcs.respond_to? :list_intents
                    @list_intents = ::Gapic::Config::Method.new list_intents_config
                    get_intent_config = parent_rpcs.get_intent if parent_rpcs.respond_to? :get_intent
                    @get_intent = ::Gapic::Config::Method.new get_intent_config
                    create_intent_config = parent_rpcs.create_intent if parent_rpcs.respond_to? :create_intent
                    @create_intent = ::Gapic::Config::Method.new create_intent_config
                    update_intent_config = parent_rpcs.update_intent if parent_rpcs.respond_to? :update_intent
                    @update_intent = ::Gapic::Config::Method.new update_intent_config
                    delete_intent_config = parent_rpcs.delete_intent if parent_rpcs.respond_to? :delete_intent
                    @delete_intent = ::Gapic::Config::Method.new delete_intent_config
                    batch_update_intents_config = parent_rpcs.batch_update_intents if parent_rpcs.respond_to? :batch_update_intents
                    @batch_update_intents = ::Gapic::Config::Method.new batch_update_intents_config
                    batch_delete_intents_config = parent_rpcs.batch_delete_intents if parent_rpcs.respond_to? :batch_delete_intents
                    @batch_delete_intents = ::Gapic::Config::Method.new batch_delete_intents_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
