# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        module Generators
          # Path helper methods for the Generators API.
          module Paths
            ##
            # Create a fully-qualified Generator resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/generators/{generator}`
            #
            # @param project [String]
            # @param location [String]
            # @param generator [String]
            #
            # @return [::String]
            def generator_path project:, location:, generator:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/generators/#{generator}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Tool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/tools/{tool}`
            #
            # @param project [String]
            # @param location [String]
            # @param tool [String]
            #
            # @return [::String]
            def tool_path project:, location:, tool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/tools/#{tool}"
            end

            extend self
          end
        end
      end
    end
  end
end
