# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module V2
        module EntityTypes
          # Path helper methods for the EntityTypes API.
          module Paths
            ##
            # Create a fully-qualified Agent resource string.
            #
            # @overload agent_path(project:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent`
            #
            #   @param project [String]
            #
            # @overload agent_path(project:, location:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent`
            #
            #   @param project [String]
            #   @param location [String]
            #
            # @return [::String]
            def agent_path **args
              resources = {
                "project" => (proc do |project:|
                  "projects/#{project}/agent"
                end),
                "location:project" => (proc do |project:, location:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified EntityType resource string.
            #
            # @overload entity_type_path(project:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/agent/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param entity_type [String]
            #
            # @overload entity_type_path(project:, location:, entity_type:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/agent/entityTypes/{entity_type}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param entity_type [String]
            #
            # @return [::String]
            def entity_type_path **args
              resources = {
                "entity_type:project" => (proc do |project:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/agent/entityTypes/#{entity_type}"
                end),
                "entity_type:location:project" => (proc do |project:, location:, entity_type:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/agent/entityTypes/#{entity_type}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
