# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/v2/document_pb"
require "google/cloud/dialogflow/v2/documents/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module V2
        module Documents
          module Rest
            ##
            # REST client for the Documents service.
            #
            # Service for managing knowledge
            # {::Google::Cloud::Dialogflow::V2::Document Documents}.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :documents_stub

              ##
              # Configure the Documents Client class.
              #
              # See {::Google::Cloud::Dialogflow::V2::Documents::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Documents clients
              #   ::Google::Cloud::Dialogflow::V2::Documents::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dialogflow", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Documents Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dialogflow::V2::Documents::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @documents_stub.universe_domain
              end

              ##
              # Create a new Documents REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Documents client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dialogflow::V2::Documents::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @documents_stub = ::Google::Cloud::Dialogflow::V2::Documents::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @documents_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @documents_stub.endpoint
                  config.universe_domain = @documents_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @documents_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dialogflow::V2::Documents::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @documents_stub.logger
              end

              # Service calls

              ##
              # Returns the list of all documents of the knowledge base.
              #
              # @overload list_documents(request, options = nil)
              #   Pass arguments to `list_documents` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ListDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ListDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_documents(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The knowledge base to list all documents for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return in a single page. By
              #     default 10 and at most 100.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous list request.
              #   @param filter [::String]
              #     The filter expression used to filter documents returned by the list method.
              #     The expression has the following syntax:
              #
              #       <field> <operator> <value> [AND <field> <operator> <value>] ...
              #
              #     The following fields and operators are supported:
              #
              #     * knowledge_types with has(:) operator
              #     * display_name with has(:) operator
              #     * state with equals(=) operator
              #
              #     Examples:
              #
              #     * "knowledge_types:FAQ" matches documents with FAQ knowledge type.
              #     * "display_name:customer" matches documents whose display name contains
              #       "customer".
              #     * "state=ACTIVE" matches documents with ACTIVE state.
              #     * "knowledge_types:FAQ AND state=ACTIVE" matches all active FAQ documents.
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Document>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Document>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ListDocumentsRequest.new
              #
              #   # Call the list_documents method.
              #   result = client.list_documents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dialogflow::V2::Document.
              #     p item
              #   end
              #
              def list_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ListDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.list_documents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @documents_stub, :list_documents, "documents", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the specified document.
              #
              # @overload get_document(request, options = nil)
              #   Pass arguments to `get_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GetDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GetDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_document(name: nil)
              #   Pass arguments to `get_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the document to retrieve.
              #     Format `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Document]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Document]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GetDocumentRequest.new
              #
              #   # Call the get_document method.
              #   result = client.get_document request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Document.
              #   p result
              #
              def get_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GetDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.get_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new document.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`: {::Google::Cloud::Dialogflow::V2::Document Document}
              #
              # @overload create_document(request, options = nil)
              #   Pass arguments to `create_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::CreateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::CreateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_document(parent: nil, document: nil)
              #   Pass arguments to `create_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The knowledge base to create a document for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>`.
              #   @param document [::Google::Cloud::Dialogflow::V2::Document, ::Hash]
              #     Required. The document to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::CreateDocumentRequest.new
              #
              #   # Call the create_document method.
              #   result = client.create_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::CreateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.create_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates documents by importing data from external sources.
              # Dialogflow supports up to 350 documents in each request. If you try to
              # import more, Dialogflow will return an error.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`:
              # {::Google::Cloud::Dialogflow::V2::ImportDocumentsResponse ImportDocumentsResponse}
              #
              # @overload import_documents(request, options = nil)
              #   Pass arguments to `import_documents` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ImportDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ImportDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_documents(parent: nil, gcs_source: nil, document_template: nil, import_gcs_custom_metadata: nil)
              #   Pass arguments to `import_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The knowledge base to import documents into.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>`.
              #   @param gcs_source [::Google::Cloud::Dialogflow::V2::GcsSources, ::Hash]
              #     Optional. The Google Cloud Storage location for the documents.
              #     The path can include a wildcard.
              #
              #     These URIs may have the forms
              #     `gs://<bucket-name>/<object-name>`.
              #     `gs://<bucket-name>/<object-path>/*.<extension>`.
              #   @param document_template [::Google::Cloud::Dialogflow::V2::ImportDocumentTemplate, ::Hash]
              #     Required. Document template used for importing all the documents.
              #   @param import_gcs_custom_metadata [::Boolean]
              #     Whether to import custom metadata from Google Cloud Storage.
              #     Only valid when the document source is Google Cloud Storage URI.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ImportDocumentsRequest.new
              #
              #   # Call the import_documents method.
              #   result = client.import_documents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ImportDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.import_documents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified document.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`: An [Empty
              #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
              #
              # @overload delete_document(request, options = nil)
              #   Pass arguments to `delete_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::DeleteDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::DeleteDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_document(name: nil)
              #   Pass arguments to `delete_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the document to delete.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::DeleteDocumentRequest.new
              #
              #   # Call the delete_document method.
              #   result = client.delete_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::DeleteDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.delete_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified document.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`: {::Google::Cloud::Dialogflow::V2::Document Document}
              #
              # @overload update_document(request, options = nil)
              #   Pass arguments to `update_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::UpdateDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::UpdateDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_document(document: nil, update_mask: nil)
              #   Pass arguments to `update_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param document [::Google::Cloud::Dialogflow::V2::Document, ::Hash]
              #     Required. The document to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Not specified means `update all`.
              #     Currently, only `display_name` can be updated, an InvalidArgument will be
              #     returned for attempting to update other fields.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::UpdateDocumentRequest.new
              #
              #   # Call the update_document method.
              #   result = client.update_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::UpdateDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.update_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reloads the specified document from its specified source, content_uri or
              # content. The previously loaded content of the document will be deleted.
              # Note: Even when the content of the document has not changed, there still
              # may be side effects because of internal implementation changes.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`: {::Google::Cloud::Dialogflow::V2::Document Document}
              #
              # Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
              # only use `projects.knowledgeBases.documents`.
              #
              # @overload reload_document(request, options = nil)
              #   Pass arguments to `reload_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ReloadDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ReloadDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reload_document(name: nil, content_uri: nil, import_gcs_custom_metadata: nil, smart_messaging_partial_update: nil)
              #   Pass arguments to `reload_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the document to reload.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`
              #   @param content_uri [::String]
              #     Optional. The path of gcs source file for reloading document content. For
              #     now, only gcs uri is supported.
              #
              #     For documents stored in Google Cloud Storage, these URIs must have
              #     the form `gs://<bucket-name>/<object-name>`.
              #   @param import_gcs_custom_metadata [::Boolean]
              #     Optional. Whether to import custom metadata from Google Cloud Storage.
              #     Only valid when the document source is Google Cloud Storage URI.
              #   @param smart_messaging_partial_update [::Boolean]
              #     Optional. When enabled, the reload request is to apply partial update to
              #     the smart messaging allowlist.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ReloadDocumentRequest.new
              #
              #   # Call the reload_document method.
              #   result = client.reload_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reload_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ReloadDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reload_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reload_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reload_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.reload_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports a smart messaging candidate document into the specified
              # destination.
              #
              # This method is a [long-running
              # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
              # The returned `Operation` type has the following method-specific fields:
              #
              # - `metadata`:
              # {::Google::Cloud::Dialogflow::V2::KnowledgeOperationMetadata KnowledgeOperationMetadata}
              # - `response`: {::Google::Cloud::Dialogflow::V2::Document Document}
              #
              # @overload export_document(request, options = nil)
              #   Pass arguments to `export_document` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ExportDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ExportDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_document(name: nil, gcs_destination: nil, export_full_content: nil, smart_messaging_partial_update: nil)
              #   Pass arguments to `export_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the document to export.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
              #   @param gcs_destination [::Google::Cloud::Dialogflow::V2::GcsDestination, ::Hash]
              #     Cloud Storage file path to export the document.
              #   @param export_full_content [::Boolean]
              #     When enabled, export the full content of the document including empirical
              #     probability.
              #   @param smart_messaging_partial_update [::Boolean]
              #     When enabled, export the smart messaging allowlist document for partial
              #     update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ExportDocumentRequest.new
              #
              #   # Call the export_document method.
              #   result = client.export_document request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ExportDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @documents_stub.export_document request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Documents REST API.
              #
              # This class represents the configuration for Documents REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dialogflow::V2::Documents::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_documents to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dialogflow::V2::Documents::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_documents.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dialogflow::V2::Documents::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_documents.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Documents API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_documents
                  ##
                  # RPC-specific configuration for `get_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_document
                  ##
                  # RPC-specific configuration for `create_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_document
                  ##
                  # RPC-specific configuration for `import_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_documents
                  ##
                  # RPC-specific configuration for `delete_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_document
                  ##
                  # RPC-specific configuration for `update_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_document
                  ##
                  # RPC-specific configuration for `reload_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reload_document
                  ##
                  # RPC-specific configuration for `export_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_document

                  # @private
                  def initialize parent_rpcs = nil
                    list_documents_config = parent_rpcs.list_documents if parent_rpcs.respond_to? :list_documents
                    @list_documents = ::Gapic::Config::Method.new list_documents_config
                    get_document_config = parent_rpcs.get_document if parent_rpcs.respond_to? :get_document
                    @get_document = ::Gapic::Config::Method.new get_document_config
                    create_document_config = parent_rpcs.create_document if parent_rpcs.respond_to? :create_document
                    @create_document = ::Gapic::Config::Method.new create_document_config
                    import_documents_config = parent_rpcs.import_documents if parent_rpcs.respond_to? :import_documents
                    @import_documents = ::Gapic::Config::Method.new import_documents_config
                    delete_document_config = parent_rpcs.delete_document if parent_rpcs.respond_to? :delete_document
                    @delete_document = ::Gapic::Config::Method.new delete_document_config
                    update_document_config = parent_rpcs.update_document if parent_rpcs.respond_to? :update_document
                    @update_document = ::Gapic::Config::Method.new update_document_config
                    reload_document_config = parent_rpcs.reload_document if parent_rpcs.respond_to? :reload_document
                    @reload_document = ::Gapic::Config::Method.new reload_document_config
                    export_document_config = parent_rpcs.export_document if parent_rpcs.respond_to? :export_document
                    @export_document = ::Gapic::Config::Method.new export_document_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
