# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/v2/conversation_pb"
require "google/cloud/dialogflow/v2/conversations/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module V2
        module Conversations
          module Rest
            ##
            # REST client for the Conversations service.
            #
            # Service for managing
            # {::Google::Cloud::Dialogflow::V2::Conversation Conversations}.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :conversations_stub

              ##
              # Configure the Conversations Client class.
              #
              # See {::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Conversations clients
              #   ::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dialogflow", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Conversations Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @conversations_stub.universe_domain
              end

              ##
              # Create a new Conversations REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Conversations client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @conversations_stub = ::Google::Cloud::Dialogflow::V2::Conversations::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @conversations_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @conversations_stub.endpoint
                  config.universe_domain = @conversations_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @conversations_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @conversations_stub.logger
              end

              # Service calls

              ##
              # Creates a new conversation. Conversations are auto-completed after 24
              # hours.
              #
              # Conversation Lifecycle:
              # There are two stages during a conversation: Automated Agent Stage and
              # Assist Stage.
              #
              # For Automated Agent Stage, there will be a dialogflow agent responding to
              # user queries.
              #
              # For Assist Stage, there's no dialogflow agent responding to user queries.
              # But we will provide suggestions which are generated from conversation.
              #
              # If
              # {::Google::Cloud::Dialogflow::V2::Conversation#conversation_profile Conversation.conversation_profile}
              # is configured for a dialogflow agent, conversation will start from
              # `Automated Agent Stage`, otherwise, it will start from `Assist Stage`. And
              # during `Automated Agent Stage`, once an
              # {::Google::Cloud::Dialogflow::V2::Intent Intent} with
              # {::Google::Cloud::Dialogflow::V2::Intent#live_agent_handoff Intent.live_agent_handoff}
              # is triggered, conversation will transfer to Assist Stage.
              #
              # @overload create_conversation(request, options = nil)
              #   Pass arguments to `create_conversation` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::CreateConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::CreateConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_conversation(parent: nil, conversation: nil, conversation_id: nil)
              #   Pass arguments to `create_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource identifier of the project creating the conversation.
              #     Format: `projects/<Project ID>/locations/<Location ID>`.
              #   @param conversation [::Google::Cloud::Dialogflow::V2::Conversation, ::Hash]
              #     Required. The conversation to create.
              #   @param conversation_id [::String]
              #     Optional. Identifier of the conversation. Generally it's auto generated by
              #     Google. Only set it if you cannot wait for the response to return a
              #     auto-generated one to you.
              #
              #     The conversation ID must be compliant with the regression formula
              #     `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
              #     If the field is provided, the caller is responsible for
              #     1. the uniqueness of the ID, otherwise the request will be rejected.
              #     2. the consistency for whether to use custom ID or not under a project to
              #     better ensure uniqueness.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::CreateConversationRequest.new
              #
              #   # Call the create_conversation method.
              #   result = client.create_conversation request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Conversation.
              #   p result
              #
              def create_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::CreateConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.create_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the list of all conversations in the specified project.
              #
              # @overload list_conversations(request, options = nil)
              #   Pass arguments to `list_conversations` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ListConversationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ListConversationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_conversations(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_conversations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project from which to list all conversation.
              #     Format: `projects/<Project ID>/locations/<Location ID>`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return in a single page. By
              #     default 100 and at most 1000.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous list request.
              #   @param filter [::String]
              #     Optional. A filter expression that filters conversations listed in the
              #     response. Only `lifecycle_state` can be filtered on in this way. For
              #     example, the following expression only returns `COMPLETED` conversations:
              #
              #     `lifecycle_state = "COMPLETED"`
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Conversation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Conversation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ListConversationsRequest.new
              #
              #   # Call the list_conversations method.
              #   result = client.list_conversations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dialogflow::V2::Conversation.
              #     p item
              #   end
              #
              def list_conversations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ListConversationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_conversations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_conversations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_conversations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.list_conversations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @conversations_stub, :list_conversations, "conversations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves the specific conversation.
              #
              # @overload get_conversation(request, options = nil)
              #   Pass arguments to `get_conversation` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GetConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GetConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_conversation(name: nil)
              #   Pass arguments to `get_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the conversation. Format:
              #     `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
              #     ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GetConversationRequest.new
              #
              #   # Call the get_conversation method.
              #   result = client.get_conversation request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Conversation.
              #   p result
              #
              def get_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GetConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.get_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Completes the specified conversation. Finished conversations are purged
              # from the database after 30 days.
              #
              # @overload complete_conversation(request, options = nil)
              #   Pass arguments to `complete_conversation` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::CompleteConversationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::CompleteConversationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload complete_conversation(name: nil)
              #   Pass arguments to `complete_conversation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource identifier of the conversation to close.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::Conversation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::Conversation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::CompleteConversationRequest.new
              #
              #   # Call the complete_conversation method.
              #   result = client.complete_conversation request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::Conversation.
              #   p result
              #
              def complete_conversation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::CompleteConversationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.complete_conversation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.complete_conversation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.complete_conversation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.complete_conversation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Data ingestion API.
              # Ingests context references for an existing conversation.
              #
              # @overload ingest_context_references(request, options = nil)
              #   Pass arguments to `ingest_context_references` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::IngestContextReferencesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::IngestContextReferencesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload ingest_context_references(conversation: nil, context_references: nil)
              #   Pass arguments to `ingest_context_references` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation [::String]
              #     Required. Resource identifier of the conversation to ingest context
              #     information for. Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              #   @param context_references [::Hash{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference, ::Hash}]
              #     Required. The context references to ingest. The key is the name of the
              #     context reference and the value contains the contents of the context
              #     reference. The key is used to incorporate ingested context references to
              #     enhance the generator.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::IngestContextReferencesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::IngestContextReferencesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::IngestContextReferencesRequest.new
              #
              #   # Call the ingest_context_references method.
              #   result = client.ingest_context_references request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::IngestContextReferencesResponse.
              #   p result
              #
              def ingest_context_references request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::IngestContextReferencesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.ingest_context_references.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.ingest_context_references.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.ingest_context_references.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.ingest_context_references request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists messages that belong to a given conversation.
              # `messages` are ordered by `create_time` in descending order. To fetch
              # updates without duplication, send request with filter
              # `create_time_epoch_microseconds >
              # [first item's create_time of previous request]` and empty page_token.
              #
              # @overload list_messages(request, options = nil)
              #   Pass arguments to `list_messages` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::ListMessagesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::ListMessagesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_messages(parent: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_messages` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the conversation to list messages for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`
              #   @param filter [::String]
              #     Optional. Filter on message fields. Currently predicates on `create_time`
              #     and `create_time_epoch_microseconds` are supported. `create_time` only
              #     support milliseconds accuracy. E.g.,
              #     `create_time_epoch_microseconds > 1551790877964485` or
              #     `create_time > 2017-01-15T01:30:15.01Z`.
              #
              #     For more information about filtering, see
              #     [API Filtering](https://aip.dev/160).
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return in a single page. By
              #     default 100 and at most 1000.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous list request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Message>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::V2::Message>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::ListMessagesRequest.new
              #
              #   # Call the list_messages method.
              #   result = client.list_messages request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dialogflow::V2::Message.
              #     p item
              #   end
              #
              def list_messages request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::ListMessagesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_messages.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_messages.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_messages.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.list_messages request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @conversations_stub, :list_messages, "messages", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Suggests summary for a conversation based on specific historical messages.
              # The range of the messages to be used for summary can be specified in the
              # request.
              #
              # @overload suggest_conversation_summary(request, options = nil)
              #   Pass arguments to `suggest_conversation_summary` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suggest_conversation_summary(conversation: nil, latest_message: nil, context_size: nil, assist_query_params: nil)
              #   Pass arguments to `suggest_conversation_summary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation [::String]
              #     Required. The conversation to fetch suggestion for.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message used as context for
              #     compiling suggestion. If empty, the latest message of the conversation will
              #     be used.
              #
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param context_size [::Integer]
              #     Optional. Max number of messages prior to and including
              #     [latest_message] to use as context when compiling the
              #     suggestion. By default 500 and at most 1000.
              #   @param assist_query_params [::Google::Cloud::Dialogflow::V2::AssistQueryParameters, ::Hash]
              #     Optional. Parameters for a human assist query. Only used for POC/demo
              #     purpose.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SuggestConversationSummaryRequest.new
              #
              #   # Call the suggest_conversation_summary method.
              #   result = client.suggest_conversation_summary request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SuggestConversationSummaryResponse.
              #   p result
              #
              def suggest_conversation_summary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SuggestConversationSummaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suggest_conversation_summary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suggest_conversation_summary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suggest_conversation_summary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.suggest_conversation_summary request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates and returns a summary for a conversation that does not have a
              # resource created for it.
              #
              # @overload generate_stateless_summary(request, options = nil)
              #   Pass arguments to `generate_stateless_summary` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_stateless_summary(stateless_conversation: nil, conversation_profile: nil, latest_message: nil, max_context_size: nil)
              #   Pass arguments to `generate_stateless_summary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param stateless_conversation [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest::MinimalConversation, ::Hash]
              #     Required. The conversation to suggest a summary for.
              #   @param conversation_profile [::Google::Cloud::Dialogflow::V2::ConversationProfile, ::Hash]
              #     Required. A ConversationProfile containing information required for Summary
              #     generation.
              #     Required fields: \\{language_code, security_settings}
              #     Optional fields: \\{agent_assistant_config}
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message used as context for
              #     generating a Summary. If empty, the latest message of the conversation will
              #     be used. The format is specific to the user and the names of the messages
              #     provided.
              #   @param max_context_size [::Integer]
              #     Optional. Max number of messages prior to and including
              #     [latest_message] to use as context when compiling the
              #     suggestion. By default 500 and at most 1000.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest.new
              #
              #   # Call the generate_stateless_summary method.
              #   result = client.generate_stateless_summary request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryResponse.
              #   p result
              #
              def generate_stateless_summary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GenerateStatelessSummaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_stateless_summary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_stateless_summary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_stateless_summary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.generate_stateless_summary request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates and returns a suggestion for a conversation that does not have a
              # resource created for it.
              #
              # @overload generate_stateless_suggestion(request, options = nil)
              #   Pass arguments to `generate_stateless_suggestion` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_stateless_suggestion(parent: nil, generator: nil, generator_name: nil, context_references: nil, conversation_context: nil, trigger_events: nil, security_settings: nil)
              #   Pass arguments to `generate_stateless_suggestion` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource to charge for the Suggestion's generation.
              #     Format: `projects/<Project ID>/locations/<Location ID>`.
              #   @param generator [::Google::Cloud::Dialogflow::V2::Generator, ::Hash]
              #     Uncreated generator. It should be a complete generator that includes all
              #     information about the generator.
              #
              #     Note: The following parameters are mutually exclusive: `generator`, `generator_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param generator_name [::String]
              #     The resource name of the existing created generator. Format:
              #     `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
              #
              #     Note: The following parameters are mutually exclusive: `generator_name`, `generator`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param context_references [::Hash{::String => ::Google::Cloud::Dialogflow::V2::Conversation::ContextReference, ::Hash}]
              #     Optional. A section of ingested context information. The key is the name of
              #     the context reference and the value contains the contents of the context
              #     reference. The key is used to incorporate ingested context references to
              #     enhance the generator.
              #   @param conversation_context [::Google::Cloud::Dialogflow::V2::ConversationContext, ::Hash]
              #     Optional. Context of the conversation, including transcripts.
              #   @param trigger_events [::Array<::Google::Cloud::Dialogflow::V2::TriggerEvent>]
              #     Optional. A list of trigger events. Generator will be triggered only if
              #     it's trigger event is included here.
              #   @param security_settings [::String]
              #     Optional. Name of the CX SecuritySettings which is used to redact generated
              #     response. If this field is empty, try to fetch v2 security_settings, which
              #     is a project level setting. If this field is empty and no v2
              #     security_settings set up in this project, no redaction will be done.
              #
              #     Format:
              #     `projects/<Project ID>/locations/<Location ID>/securitySettings/<Security
              #     Settings ID>`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionRequest.new
              #
              #   # Call the generate_stateless_suggestion method.
              #   result = client.generate_stateless_suggestion request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionResponse.
              #   p result
              #
              def generate_stateless_suggestion request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GenerateStatelessSuggestionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_stateless_suggestion.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_stateless_suggestion.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_stateless_suggestion.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.generate_stateless_suggestion request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get answers for the given query based on knowledge documents.
              #
              # @overload search_knowledge(request, options = nil)
              #   Pass arguments to `search_knowledge` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_knowledge(parent: nil, query: nil, conversation_profile: nil, session_id: nil, conversation: nil, latest_message: nil, query_source: nil, end_user_metadata: nil, search_config: nil, exact_search: nil)
              #   Pass arguments to `search_knowledge` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource contains the conversation profile
              #     Format: 'projects/<Project ID>' or `projects/<Project
              #     ID>/locations/<Location ID>`.
              #   @param query [::Google::Cloud::Dialogflow::V2::TextInput, ::Hash]
              #     Required. The natural language text query for knowledge search.
              #   @param conversation_profile [::String]
              #     Required. The conversation profile used to configure the search.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversationProfiles/<Conversation Profile ID>`.
              #   @param session_id [::String]
              #     Required. The ID of the search session.
              #     The session_id can be combined with Dialogflow V3 Agent ID retrieved from
              #     conversation profile or on its own to identify a search session. The search
              #     history of the same session will impact the search result. It's up to the
              #     API caller to choose an appropriate `Session ID`. It can be a random number
              #     or some type of session identifiers (preferably hashed). The length must
              #     not exceed 36 characters.
              #   @param conversation [::String]
              #     Optional. The conversation (between human agent and end user) where the
              #     search request is triggered. Format: `projects/<Project
              #     ID>/locations/<Location ID>/conversations/<Conversation ID>`.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message when the request is
              #     triggered.
              #     Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param query_source [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::QuerySource]
              #     Optional. The source of the query in the request.
              #   @param end_user_metadata [::Google::Protobuf::Struct, ::Hash]
              #     Optional. Information about the end-user to improve the relevance and
              #     accuracy of generative answers.
              #
              #     This will be interpreted and used by a language model, so, for good
              #     results, the data should be self-descriptive, and in a simple structure.
              #
              #     Example:
              #
              #     ```json
              #     {
              #       "subscription plan": "Business Premium Plus",
              #       "devices owned": [
              #         \\{"model": "Google Pixel 7"},
              #         \\{"model": "Google Pixel Tablet"}
              #       ]
              #     }
              #     ```
              #   @param search_config [::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest::SearchConfig, ::Hash]
              #     Optional. Configuration specific to search queries with data stores.
              #   @param exact_search [::Boolean]
              #     Optional. Whether to search the query exactly without query rewrite.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::SearchKnowledgeResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::SearchKnowledgeResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest.new
              #
              #   # Call the search_knowledge method.
              #   result = client.search_knowledge request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::SearchKnowledgeResponse.
              #   p result
              #
              def search_knowledge request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::SearchKnowledgeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_knowledge.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_knowledge.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_knowledge.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.search_knowledge request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates all the suggestions using generators configured in the
              # conversation profile. A generator is used only if its trigger event is
              # matched.
              #
              # @overload generate_suggestions(request, options = nil)
              #   Pass arguments to `generate_suggestions` via a request object, either of type
              #   {::Google::Cloud::Dialogflow::V2::GenerateSuggestionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dialogflow::V2::GenerateSuggestionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_suggestions(conversation: nil, latest_message: nil, trigger_events: nil)
              #   Pass arguments to `generate_suggestions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param conversation [::String]
              #     Required. The conversation for which the suggestions are generated. Format:
              #     `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>`.
              #
              #     The conversation must be created with a conversation profile which has
              #     generators configured in it to be able to get suggestions.
              #   @param latest_message [::String]
              #     Optional. The name of the latest conversation message for which the request
              #     is triggered. Format: `projects/<Project ID>/locations/<Location
              #     ID>/conversations/<Conversation ID>/messages/<Message ID>`.
              #   @param trigger_events [::Array<::Google::Cloud::Dialogflow::V2::TriggerEvent>]
              #     Optional. A list of trigger events. Only generators configured in the
              #     conversation_profile whose trigger_event is listed here will be triggered.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dialogflow::V2::GenerateSuggestionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dialogflow::V2::GenerateSuggestionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dialogflow/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dialogflow::V2::GenerateSuggestionsRequest.new
              #
              #   # Call the generate_suggestions method.
              #   result = client.generate_suggestions request
              #
              #   # The returned object is of type Google::Cloud::Dialogflow::V2::GenerateSuggestionsResponse.
              #   p result
              #
              def generate_suggestions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::V2::GenerateSuggestionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_suggestions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dialogflow::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_suggestions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_suggestions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @conversations_stub.generate_suggestions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Conversations REST API.
              #
              # This class represents the configuration for Conversations REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_conversation to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_conversation.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dialogflow::V2::Conversations::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_conversation.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Conversations API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_conversation
                  ##
                  # RPC-specific configuration for `list_conversations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_conversations
                  ##
                  # RPC-specific configuration for `get_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_conversation
                  ##
                  # RPC-specific configuration for `complete_conversation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :complete_conversation
                  ##
                  # RPC-specific configuration for `ingest_context_references`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :ingest_context_references
                  ##
                  # RPC-specific configuration for `list_messages`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_messages
                  ##
                  # RPC-specific configuration for `suggest_conversation_summary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suggest_conversation_summary
                  ##
                  # RPC-specific configuration for `generate_stateless_summary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_stateless_summary
                  ##
                  # RPC-specific configuration for `generate_stateless_suggestion`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_stateless_suggestion
                  ##
                  # RPC-specific configuration for `search_knowledge`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_knowledge
                  ##
                  # RPC-specific configuration for `generate_suggestions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_suggestions

                  # @private
                  def initialize parent_rpcs = nil
                    create_conversation_config = parent_rpcs.create_conversation if parent_rpcs.respond_to? :create_conversation
                    @create_conversation = ::Gapic::Config::Method.new create_conversation_config
                    list_conversations_config = parent_rpcs.list_conversations if parent_rpcs.respond_to? :list_conversations
                    @list_conversations = ::Gapic::Config::Method.new list_conversations_config
                    get_conversation_config = parent_rpcs.get_conversation if parent_rpcs.respond_to? :get_conversation
                    @get_conversation = ::Gapic::Config::Method.new get_conversation_config
                    complete_conversation_config = parent_rpcs.complete_conversation if parent_rpcs.respond_to? :complete_conversation
                    @complete_conversation = ::Gapic::Config::Method.new complete_conversation_config
                    ingest_context_references_config = parent_rpcs.ingest_context_references if parent_rpcs.respond_to? :ingest_context_references
                    @ingest_context_references = ::Gapic::Config::Method.new ingest_context_references_config
                    list_messages_config = parent_rpcs.list_messages if parent_rpcs.respond_to? :list_messages
                    @list_messages = ::Gapic::Config::Method.new list_messages_config
                    suggest_conversation_summary_config = parent_rpcs.suggest_conversation_summary if parent_rpcs.respond_to? :suggest_conversation_summary
                    @suggest_conversation_summary = ::Gapic::Config::Method.new suggest_conversation_summary_config
                    generate_stateless_summary_config = parent_rpcs.generate_stateless_summary if parent_rpcs.respond_to? :generate_stateless_summary
                    @generate_stateless_summary = ::Gapic::Config::Method.new generate_stateless_summary_config
                    generate_stateless_suggestion_config = parent_rpcs.generate_stateless_suggestion if parent_rpcs.respond_to? :generate_stateless_suggestion
                    @generate_stateless_suggestion = ::Gapic::Config::Method.new generate_stateless_suggestion_config
                    search_knowledge_config = parent_rpcs.search_knowledge if parent_rpcs.respond_to? :search_knowledge
                    @search_knowledge = ::Gapic::Config::Method.new search_knowledge_config
                    generate_suggestions_config = parent_rpcs.generate_suggestions if parent_rpcs.respond_to? :generate_suggestions
                    @generate_suggestions = ::Gapic::Config::Method.new generate_suggestions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
