# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/dialogflow/v2/version"

require "google/cloud/dialogflow/v2/contexts/credentials"
require "google/cloud/dialogflow/v2/contexts/paths"
require "google/cloud/dialogflow/v2/contexts/client"
require "google/cloud/dialogflow/v2/contexts/rest"

module Google
  module Cloud
    module Dialogflow
      module V2
        ##
        # Service for managing {::Google::Cloud::Dialogflow::V2::Context Contexts}.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/dialogflow/v2/contexts"
        #     client = ::Google::Cloud::Dialogflow::V2::Contexts::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/dialogflow/v2/contexts/rest"
        #     client = ::Google::Cloud::Dialogflow::V2::Contexts::Rest::Client.new
        #
        module Contexts
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "contexts", "helpers.rb"
require "google/cloud/dialogflow/v2/contexts/helpers" if ::File.file? helper_path
