# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/dialogflow/cx/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :dialogflow_cx do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module Dialogflow
      module CX
        ##
        # Create a new client object for Pages.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Pages::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Pages-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Pages service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Pages service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.pages_available?}.
        #
        # ## About Pages
        #
        # Service for managing Pages.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.pages version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Pages)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Pages service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.pages}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Pages service,
        # or if the versioned client gem needs an update to support the Pages service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.pages_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Pages
          service_module = service_module.const_get :Pages
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Flows.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Flows::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Flows-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Flows service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Flows service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.flows_available?}.
        #
        # ## About Flows
        #
        # Service for managing Flows.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.flows version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Flows)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Flows service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.flows}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Flows service,
        # or if the versioned client gem needs an update to support the Flows service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.flows_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Flows
          service_module = service_module.const_get :Flows
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Agents.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Agents::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Agents-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Agents service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Agents service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.agents_available?}.
        #
        # ## About Agents
        #
        # Service for managing Agents.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.agents version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Agents)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Agents service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.agents}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Agents service,
        # or if the versioned client gem needs an update to support the Agents service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.agents_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Agents
          service_module = service_module.const_get :Agents
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Changelogs.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Changelogs::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Changelogs-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Changelogs service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Changelogs service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.changelogs_available?}.
        #
        # ## About Changelogs
        #
        # Service for managing Changelogs.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.changelogs version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Changelogs)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Changelogs service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.changelogs}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Changelogs service,
        # or if the versioned client gem needs an update to support the Changelogs service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.changelogs_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Changelogs
          service_module = service_module.const_get :Changelogs
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Deployments.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Deployments::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Deployments-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Deployments service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Deployments service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.deployments_available?}.
        #
        # ## About Deployments
        #
        # Service for managing Deployments.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.deployments version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Deployments)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Deployments service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.deployments}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Deployments service,
        # or if the versioned client gem needs an update to support the Deployments service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.deployments_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Deployments
          service_module = service_module.const_get :Deployments
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for EntityTypes.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-EntityTypes-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the EntityTypes service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the EntityTypes service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.entity_types_available?}.
        #
        # ## About EntityTypes
        #
        # Service for managing EntityTypes.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.entity_types version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:EntityTypes)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the EntityTypes service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.entity_types}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the EntityTypes service,
        # or if the versioned client gem needs an update to support the EntityTypes service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.entity_types_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :EntityTypes
          service_module = service_module.const_get :EntityTypes
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Intents.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Intents::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Intents-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Intents service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Intents service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.intents_available?}.
        #
        # ## About Intents
        #
        # Service for managing Intents.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.intents version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Intents)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Intents service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.intents}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Intents service,
        # or if the versioned client gem needs an update to support the Intents service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.intents_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Intents
          service_module = service_module.const_get :Intents
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for SessionEntityTypes.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-SessionEntityTypes-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the SessionEntityTypes service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the SessionEntityTypes service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.session_entity_types_available?}.
        #
        # ## About SessionEntityTypes
        #
        # Service for managing
        # SessionEntityTypes.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.session_entity_types version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:SessionEntityTypes)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the SessionEntityTypes service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.session_entity_types}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the SessionEntityTypes service,
        # or if the versioned client gem needs an update to support the SessionEntityTypes service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.session_entity_types_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :SessionEntityTypes
          service_module = service_module.const_get :SessionEntityTypes
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Sessions.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Sessions::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Sessions-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Sessions service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Sessions service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.sessions_available?}.
        #
        # ## About Sessions
        #
        # A session represents an interaction with a user. You retrieve user input
        # and pass it to the
        # DetectIntent method to
        # determine user intent and respond.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.sessions version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Sessions)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Sessions service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.sessions}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Sessions service,
        # or if the versioned client gem needs an update to support the Sessions service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.sessions_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Sessions
          service_module = service_module.const_get :Sessions
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for TransitionRouteGroups.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::TransitionRouteGroups::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-TransitionRouteGroups-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the TransitionRouteGroups service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the TransitionRouteGroups service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.transition_route_groups_available?}.
        #
        # ## About TransitionRouteGroups
        #
        # Service for managing
        # TransitionRouteGroups.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.transition_route_groups version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:TransitionRouteGroups)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the TransitionRouteGroups service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.transition_route_groups}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the TransitionRouteGroups service,
        # or if the versioned client gem needs an update to support the TransitionRouteGroups service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.transition_route_groups_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :TransitionRouteGroups
          service_module = service_module.const_get :TransitionRouteGroups
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for TestCases.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::TestCases::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-TestCases-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the TestCases service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the TestCases service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.test_cases_available?}.
        #
        # ## About TestCases
        #
        # Service for managing Test Cases and
        # Test Case Results.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.test_cases version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:TestCases)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the TestCases service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.test_cases}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the TestCases service,
        # or if the versioned client gem needs an update to support the TestCases service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.test_cases_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :TestCases
          service_module = service_module.const_get :TestCases
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Webhooks.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Webhooks::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Webhooks-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Webhooks service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Webhooks service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.webhooks_available?}.
        #
        # ## About Webhooks
        #
        # Service for managing Webhooks.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.webhooks version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Webhooks)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Webhooks service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.webhooks}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Webhooks service,
        # or if the versioned client gem needs an update to support the Webhooks service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.webhooks_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Webhooks
          service_module = service_module.const_get :Webhooks
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Environments.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Environments::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Environments-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Environments service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Environments service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.environments_available?}.
        #
        # ## About Environments
        #
        # Service for managing
        # Environments.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.environments version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Environments)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Environments service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.environments}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Environments service,
        # or if the versioned client gem needs an update to support the Environments service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.environments_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Environments
          service_module = service_module.const_get :Environments
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Experiments.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Experiments::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Experiments-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Experiments service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Experiments service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.experiments_available?}.
        #
        # ## About Experiments
        #
        # Service for managing Experiments.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.experiments version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Experiments)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Experiments service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.experiments}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Experiments service,
        # or if the versioned client gem needs an update to support the Experiments service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.experiments_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Experiments
          service_module = service_module.const_get :Experiments
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Generators.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Generators::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Generators-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Generators service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Generators service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.generators_available?}.
        #
        # ## About Generators
        #
        # Service for managing Generators
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.generators version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Generators)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Generators service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.generators}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Generators service,
        # or if the versioned client gem needs an update to support the Generators service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.generators_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Generators
          service_module = service_module.const_get :Generators
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for SecuritySettingsService.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::SecuritySettingsService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-SecuritySettingsService-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the SecuritySettingsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the SecuritySettingsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.security_settings_service_available?}.
        #
        # ## About SecuritySettingsService
        #
        # Service for managing security settings for Dialogflow.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.security_settings_service version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:SecuritySettingsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the SecuritySettingsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.security_settings_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the SecuritySettingsService service,
        # or if the versioned client gem needs an update to support the SecuritySettingsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.security_settings_service_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :SecuritySettingsService
          service_module = service_module.const_get :SecuritySettingsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for Versions.
        #
        # By default, this returns an instance of
        # [Google::Cloud::Dialogflow::CX::V3::Versions::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dialogflow-cx-v3/latest/Google-Cloud-Dialogflow-CX-V3-Versions-Client)
        # for a gRPC client for version V3 of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the Versions service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the Versions service.
        # You can determine whether the method will succeed by calling
        # {Google::Cloud::Dialogflow::CX.versions_available?}.
        #
        # ## About Versions
        #
        # Service for managing Versions.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.versions version: :v3, transport: :grpc, &block
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"

          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Cloud::Dialogflow::CX.const_get(package_name).const_get(:Versions)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the Versions service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Cloud::Dialogflow::CX.versions}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the Versions service,
        # or if the versioned client gem needs an update to support the Versions service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v3`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.versions_available? version: :v3, transport: :grpc
          require "google/cloud/dialogflow/cx/#{version.to_s.downcase}"
          package_name = Google::Cloud::Dialogflow::CX
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Cloud::Dialogflow::CX.const_get package_name
          return false unless service_module.const_defined? :Versions
          service_module = service_module.const_get :Versions
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Configure the google-cloud-dialogflow-cx library.
        #
        # The following configuration parameters are supported:
        #
        # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
        #   The path to the keyfile as a String, the contents of the keyfile as a
        #   Hash, or a Google::Auth::Credentials object.
        # * `lib_name` (*type:* `String`) -
        #   The library name as recorded in instrumentation and logging.
        # * `lib_version` (*type:* `String`) -
        #   The library version as recorded in instrumentation and logging.
        # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
        #   An array of interceptors that are run before calls are executed.
        # * `timeout` (*type:* `Numeric`) -
        #   Default timeout in seconds.
        # * `metadata` (*type:* `Hash{Symbol=>String}`) -
        #   Additional headers to be sent with the call.
        # * `retry_policy` (*type:* `Hash`) -
        #   The retry policy. The value is a hash with the following keys:
        #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
        #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
        #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
        #     * `:retry_codes` (*type:* `Array<String>`) -
        #       The error codes that should trigger a retry.
        #
        # @return [::Google::Cloud::Config] The default configuration used by this library
        #
        def self.configure
          yield ::Google::Cloud.configure.dialogflow_cx if block_given?

          ::Google::Cloud.configure.dialogflow_cx
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "cx", "helpers.rb"
require "google/cloud/dialogflow/cx/helpers" if ::File.file? helper_path
