# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dialogflow/cx/v3/test_case_pb"
require "google/cloud/dialogflow/cx/v3/test_cases"

class ::Google::Cloud::Dialogflow::CX::V3::TestCases::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_test_cases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::ListTestCasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :TEST_CASE_VIEW_UNSPECIFIED

    list_test_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_test_cases, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ListTestCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :TEST_CASE_VIEW_UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_test_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_test_cases({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_test_cases parent: parent, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_test_cases ::Google::Cloud::Dialogflow::CX::V3::ListTestCasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_test_cases({ parent: parent, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_test_cases(::Google::Cloud::Dialogflow::CX::V3::ListTestCasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_test_cases_client_stub.call_rpc_count
    end
  end

  def test_batch_delete_test_cases
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_delete_test_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_delete_test_cases, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::BatchDeleteTestCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["names"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_delete_test_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_delete_test_cases({ parent: parent, names: names }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_delete_test_cases parent: parent, names: names do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_delete_test_cases ::Google::Cloud::Dialogflow::CX::V3::BatchDeleteTestCasesRequest.new(parent: parent, names: names) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_delete_test_cases({ parent: parent, names: names }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_delete_test_cases(::Google::Cloud::Dialogflow::CX::V3::BatchDeleteTestCasesRequest.new(parent: parent, names: names), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_delete_test_cases_client_stub.call_rpc_count
    end
  end

  def test_get_test_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_test_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_test_case, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_test_case_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_test_case({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_test_case name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_test_case ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_test_case({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_test_case(::Google::Cloud::Dialogflow::CX::V3::GetTestCaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_test_case_client_stub.call_rpc_count
    end
  end

  def test_create_test_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    test_case = {}

    create_test_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_test_case, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::CreateTestCaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::CX::V3::TestCase), request["test_case"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_test_case_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_test_case({ parent: parent, test_case: test_case }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_test_case parent: parent, test_case: test_case do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_test_case ::Google::Cloud::Dialogflow::CX::V3::CreateTestCaseRequest.new(parent: parent, test_case: test_case) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_test_case({ parent: parent, test_case: test_case }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_test_case(::Google::Cloud::Dialogflow::CX::V3::CreateTestCaseRequest.new(parent: parent, test_case: test_case), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_test_case_client_stub.call_rpc_count
    end
  end

  def test_update_test_case
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    test_case = {}
    update_mask = {}

    update_test_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_test_case, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::UpdateTestCaseRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::CX::V3::TestCase), request["test_case"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_test_case_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_test_case({ test_case: test_case, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_test_case test_case: test_case, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_test_case ::Google::Cloud::Dialogflow::CX::V3::UpdateTestCaseRequest.new(test_case: test_case, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_test_case({ test_case: test_case, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_test_case(::Google::Cloud::Dialogflow::CX::V3::UpdateTestCaseRequest.new(test_case: test_case, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_test_case_client_stub.call_rpc_count
    end
  end

  def test_run_test_case
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    environment = "hello world"

    run_test_case_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_test_case, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::RunTestCaseRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["environment"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_test_case_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_test_case({ name: name, environment: environment }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_test_case name: name, environment: environment do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_test_case ::Google::Cloud::Dialogflow::CX::V3::RunTestCaseRequest.new(name: name, environment: environment) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_test_case({ name: name, environment: environment }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_test_case(::Google::Cloud::Dialogflow::CX::V3::RunTestCaseRequest.new(name: name, environment: environment), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_test_case_client_stub.call_rpc_count
    end
  end

  def test_batch_run_test_cases
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment = "hello world"
    test_cases = ["hello world"]

    batch_run_test_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_run_test_cases, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::BatchRunTestCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["environment"]
      assert_equal ["hello world"], request["test_cases"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_run_test_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_run_test_cases({ parent: parent, environment: environment, test_cases: test_cases }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_run_test_cases parent: parent, environment: environment, test_cases: test_cases do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_run_test_cases ::Google::Cloud::Dialogflow::CX::V3::BatchRunTestCasesRequest.new(parent: parent, environment: environment, test_cases: test_cases) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_run_test_cases({ parent: parent, environment: environment, test_cases: test_cases }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_run_test_cases(::Google::Cloud::Dialogflow::CX::V3::BatchRunTestCasesRequest.new(parent: parent, environment: environment, test_cases: test_cases), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_run_test_cases_client_stub.call_rpc_count
    end
  end

  def test_calculate_coverage
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    agent = "hello world"
    type = :COVERAGE_TYPE_UNSPECIFIED

    calculate_coverage_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :calculate_coverage, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageRequest, request
      assert_equal "hello world", request["agent"]
      assert_equal :COVERAGE_TYPE_UNSPECIFIED, request["type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, calculate_coverage_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.calculate_coverage({ agent: agent, type: type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.calculate_coverage agent: agent, type: type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.calculate_coverage ::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageRequest.new(agent: agent, type: type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.calculate_coverage({ agent: agent, type: type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.calculate_coverage(::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageRequest.new(agent: agent, type: type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, calculate_coverage_client_stub.call_rpc_count
    end
  end

  def test_import_test_cases
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcs_uri = "hello world"

    import_test_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_test_cases, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ImportTestCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["gcs_uri"]
      assert_equal :gcs_uri, request.source
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_test_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_test_cases({ parent: parent, gcs_uri: gcs_uri }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_test_cases parent: parent, gcs_uri: gcs_uri do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_test_cases ::Google::Cloud::Dialogflow::CX::V3::ImportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_test_cases({ parent: parent, gcs_uri: gcs_uri }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_test_cases(::Google::Cloud::Dialogflow::CX::V3::ImportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_test_cases_client_stub.call_rpc_count
    end
  end

  def test_export_test_cases
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcs_uri = "hello world"
    data_format = :DATA_FORMAT_UNSPECIFIED
    filter = "hello world"

    export_test_cases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_test_cases, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ExportTestCasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["gcs_uri"]
      assert_equal :gcs_uri, request.destination
      assert_equal :DATA_FORMAT_UNSPECIFIED, request["data_format"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_test_cases_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_test_cases({ parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_test_cases parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_test_cases ::Google::Cloud::Dialogflow::CX::V3::ExportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_test_cases({ parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_test_cases(::Google::Cloud::Dialogflow::CX::V3::ExportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_test_cases_client_stub.call_rpc_count
    end
  end

  def test_list_test_case_results
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_test_case_results_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_test_case_results, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_test_case_results_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_test_case_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_test_case_results parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_test_case_results ::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_test_case_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_test_case_results(::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_test_case_results_client_stub.call_rpc_count
    end
  end

  def test_get_test_case_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::TestCaseResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_test_case_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_test_case_result, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_test_case_result_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_test_case_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_test_case_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_test_case_result ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_test_case_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_test_case_result(::Google::Cloud::Dialogflow::CX::V3::GetTestCaseResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_test_case_result_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::TestCases::Operations, client.operations_client
  end
end
