# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dialogflow/cx/v3/test_case_pb"
require "google/cloud/dialogflow/cx/v3/test_cases/rest"


class ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_test_cases
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListTestCasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :TEST_CASE_VIEW_UNSPECIFIED

    list_test_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_list_test_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_test_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_test_cases({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_test_cases parent: parent, page_size: page_size, page_token: page_token, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_test_cases ::Google::Cloud::Dialogflow::CX::V3::ListTestCasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_test_cases({ parent: parent, page_size: page_size, page_token: page_token, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_test_cases(::Google::Cloud::Dialogflow::CX::V3::ListTestCasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_test_cases_client_stub.call_count
      end
    end
  end

  def test_batch_delete_test_cases
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_delete_test_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_batch_delete_test_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_test_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_test_cases({ parent: parent, names: names }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_test_cases parent: parent, names: names do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_test_cases ::Google::Cloud::Dialogflow::CX::V3::BatchDeleteTestCasesRequest.new(parent: parent, names: names) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_test_cases({ parent: parent, names: names }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_test_cases(::Google::Cloud::Dialogflow::CX::V3::BatchDeleteTestCasesRequest.new(parent: parent, names: names), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_test_cases_client_stub.call_count
      end
    end
  end

  def test_get_test_case
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_test_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_get_test_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_test_case_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_test_case({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_test_case name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_test_case ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_test_case({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_test_case(::Google::Cloud::Dialogflow::CX::V3::GetTestCaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_test_case_client_stub.call_count
      end
    end
  end

  def test_create_test_case
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    test_case = {}

    create_test_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_create_test_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_test_case_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_test_case({ parent: parent, test_case: test_case }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_test_case parent: parent, test_case: test_case do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_test_case ::Google::Cloud::Dialogflow::CX::V3::CreateTestCaseRequest.new(parent: parent, test_case: test_case) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_test_case({ parent: parent, test_case: test_case }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_test_case(::Google::Cloud::Dialogflow::CX::V3::CreateTestCaseRequest.new(parent: parent, test_case: test_case), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_test_case_client_stub.call_count
      end
    end
  end

  def test_update_test_case
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::TestCase.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    test_case = {}
    update_mask = {}

    update_test_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_update_test_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_test_case_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_test_case({ test_case: test_case, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_test_case test_case: test_case, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_test_case ::Google::Cloud::Dialogflow::CX::V3::UpdateTestCaseRequest.new(test_case: test_case, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_test_case({ test_case: test_case, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_test_case(::Google::Cloud::Dialogflow::CX::V3::UpdateTestCaseRequest.new(test_case: test_case, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_test_case_client_stub.call_count
      end
    end
  end

  def test_run_test_case
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    environment = "hello world"

    run_test_case_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_run_test_case_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_test_case_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_test_case({ name: name, environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_test_case name: name, environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_test_case ::Google::Cloud::Dialogflow::CX::V3::RunTestCaseRequest.new(name: name, environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_test_case({ name: name, environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_test_case(::Google::Cloud::Dialogflow::CX::V3::RunTestCaseRequest.new(name: name, environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_test_case_client_stub.call_count
      end
    end
  end

  def test_batch_run_test_cases
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment = "hello world"
    test_cases = ["hello world"]

    batch_run_test_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_batch_run_test_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_run_test_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_run_test_cases({ parent: parent, environment: environment, test_cases: test_cases }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_run_test_cases parent: parent, environment: environment, test_cases: test_cases do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_run_test_cases ::Google::Cloud::Dialogflow::CX::V3::BatchRunTestCasesRequest.new(parent: parent, environment: environment, test_cases: test_cases) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_run_test_cases({ parent: parent, environment: environment, test_cases: test_cases }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_run_test_cases(::Google::Cloud::Dialogflow::CX::V3::BatchRunTestCasesRequest.new(parent: parent, environment: environment, test_cases: test_cases), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_run_test_cases_client_stub.call_count
      end
    end
  end

  def test_calculate_coverage
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    agent = "hello world"
    type = :COVERAGE_TYPE_UNSPECIFIED

    calculate_coverage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_calculate_coverage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, calculate_coverage_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.calculate_coverage({ agent: agent, type: type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.calculate_coverage agent: agent, type: type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.calculate_coverage ::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageRequest.new(agent: agent, type: type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.calculate_coverage({ agent: agent, type: type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.calculate_coverage(::Google::Cloud::Dialogflow::CX::V3::CalculateCoverageRequest.new(agent: agent, type: type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, calculate_coverage_client_stub.call_count
      end
    end
  end

  def test_import_test_cases
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcs_uri = "hello world"

    import_test_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_import_test_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_test_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_test_cases({ parent: parent, gcs_uri: gcs_uri }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_test_cases parent: parent, gcs_uri: gcs_uri do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_test_cases ::Google::Cloud::Dialogflow::CX::V3::ImportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_test_cases({ parent: parent, gcs_uri: gcs_uri }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_test_cases(::Google::Cloud::Dialogflow::CX::V3::ImportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_test_cases_client_stub.call_count
      end
    end
  end

  def test_export_test_cases
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcs_uri = "hello world"
    data_format = :DATA_FORMAT_UNSPECIFIED
    filter = "hello world"

    export_test_cases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_export_test_cases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_test_cases_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_test_cases({ parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_test_cases parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_test_cases ::Google::Cloud::Dialogflow::CX::V3::ExportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_test_cases({ parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_test_cases(::Google::Cloud::Dialogflow::CX::V3::ExportTestCasesRequest.new(parent: parent, gcs_uri: gcs_uri, data_format: data_format, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_test_cases_client_stub.call_count
      end
    end
  end

  def test_list_test_case_results
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_test_case_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_list_test_case_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_test_case_results_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_test_case_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_test_case_results parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_test_case_results ::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_test_case_results({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_test_case_results(::Google::Cloud::Dialogflow::CX::V3::ListTestCaseResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_test_case_results_client_stub.call_count
      end
    end
  end

  def test_get_test_case_result
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::TestCaseResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_test_case_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::ServiceStub.stub :transcode_get_test_case_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_test_case_result_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_test_case_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_test_case_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_test_case_result ::Google::Cloud::Dialogflow::CX::V3::GetTestCaseResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_test_case_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_test_case_result(::Google::Cloud::Dialogflow::CX::V3::GetTestCaseResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_test_case_result_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client::Configuration, config
  end
end
