# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dialogflow/cx/v3/session_entity_type_pb"
require "google/cloud/dialogflow/cx/v3/session_entity_types/rest"


class ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_session_entity_types
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListSessionEntityTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_session_entity_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ServiceStub.stub :transcode_list_session_entity_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_session_entity_types_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_session_entity_types({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_session_entity_types parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_session_entity_types ::Google::Cloud::Dialogflow::CX::V3::ListSessionEntityTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_session_entity_types({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_session_entity_types(::Google::Cloud::Dialogflow::CX::V3::ListSessionEntityTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_session_entity_types_client_stub.call_count
      end
    end
  end

  def test_get_session_entity_type
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_session_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ServiceStub.stub :transcode_get_session_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_session_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_session_entity_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_session_entity_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_session_entity_type ::Google::Cloud::Dialogflow::CX::V3::GetSessionEntityTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_session_entity_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_session_entity_type(::Google::Cloud::Dialogflow::CX::V3::GetSessionEntityTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_session_entity_type_client_stub.call_count
      end
    end
  end

  def test_create_session_entity_type
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    session_entity_type = {}

    create_session_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ServiceStub.stub :transcode_create_session_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_session_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_session_entity_type({ parent: parent, session_entity_type: session_entity_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_session_entity_type parent: parent, session_entity_type: session_entity_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_session_entity_type ::Google::Cloud::Dialogflow::CX::V3::CreateSessionEntityTypeRequest.new(parent: parent, session_entity_type: session_entity_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_session_entity_type({ parent: parent, session_entity_type: session_entity_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_session_entity_type(::Google::Cloud::Dialogflow::CX::V3::CreateSessionEntityTypeRequest.new(parent: parent, session_entity_type: session_entity_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_session_entity_type_client_stub.call_count
      end
    end
  end

  def test_update_session_entity_type
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    session_entity_type = {}
    update_mask = {}

    update_session_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ServiceStub.stub :transcode_update_session_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_session_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_session_entity_type({ session_entity_type: session_entity_type, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_session_entity_type session_entity_type: session_entity_type, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_session_entity_type ::Google::Cloud::Dialogflow::CX::V3::UpdateSessionEntityTypeRequest.new(session_entity_type: session_entity_type, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_session_entity_type({ session_entity_type: session_entity_type, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_session_entity_type(::Google::Cloud::Dialogflow::CX::V3::UpdateSessionEntityTypeRequest.new(session_entity_type: session_entity_type, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_session_entity_type_client_stub.call_count
      end
    end
  end

  def test_delete_session_entity_type
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_session_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::ServiceStub.stub :transcode_delete_session_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_session_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_session_entity_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_session_entity_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_session_entity_type ::Google::Cloud::Dialogflow::CX::V3::DeleteSessionEntityTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_session_entity_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_session_entity_type(::Google::Cloud::Dialogflow::CX::V3::DeleteSessionEntityTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_session_entity_type_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::SessionEntityTypes::Rest::Client::Configuration, config
  end
end
