# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dialogflow/cx/v3/flow_pb"
require "google/cloud/dialogflow/cx/v3/flows/rest"


class ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_flow
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::Flow.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    flow = {}
    language_code = "hello world"

    create_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_create_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_flow({ parent: parent, flow: flow, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_flow parent: parent, flow: flow, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_flow ::Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest.new(parent: parent, flow: flow, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_flow({ parent: parent, flow: flow, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_flow(::Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest.new(parent: parent, flow: flow, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_flow_client_stub.call_count
      end
    end
  end

  def test_delete_flow
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_delete_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_flow({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_flow name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_flow ::Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_flow({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_flow(::Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_flow_client_stub.call_count
      end
    end
  end

  def test_list_flows
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListFlowsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_flows_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_list_flows_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_flows_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_flows({ parent: parent, page_size: page_size, page_token: page_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_flows parent: parent, page_size: page_size, page_token: page_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_flows ::Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest.new(parent: parent, page_size: page_size, page_token: page_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_flows({ parent: parent, page_size: page_size, page_token: page_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_flows(::Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest.new(parent: parent, page_size: page_size, page_token: page_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_flows_client_stub.call_count
      end
    end
  end

  def test_get_flow
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::Flow.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"

    get_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_get_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_flow({ name: name, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_flow name: name, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_flow ::Google::Cloud::Dialogflow::CX::V3::GetFlowRequest.new(name: name, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_flow({ name: name, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_flow(::Google::Cloud::Dialogflow::CX::V3::GetFlowRequest.new(name: name, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_flow_client_stub.call_count
      end
    end
  end

  def test_update_flow
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::Flow.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    flow = {}
    update_mask = {}
    language_code = "hello world"

    update_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_update_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_flow({ flow: flow, update_mask: update_mask, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_flow flow: flow, update_mask: update_mask, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_flow ::Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest.new(flow: flow, update_mask: update_mask, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_flow({ flow: flow, update_mask: update_mask, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_flow(::Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest.new(flow: flow, update_mask: update_mask, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_flow_client_stub.call_count
      end
    end
  end

  def test_train_flow
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    train_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_train_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, train_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.train_flow({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.train_flow name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.train_flow ::Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.train_flow({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.train_flow(::Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, train_flow_client_stub.call_count
      end
    end
  end

  def test_validate_flow
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"

    validate_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_validate_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, validate_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.validate_flow({ name: name, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.validate_flow name: name, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.validate_flow ::Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest.new(name: name, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.validate_flow({ name: name, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.validate_flow(::Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest.new(name: name, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, validate_flow_client_stub.call_count
      end
    end
  end

  def test_get_flow_validation_result
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"

    get_flow_validation_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_get_flow_validation_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_flow_validation_result_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_flow_validation_result({ name: name, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_flow_validation_result name: name, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_flow_validation_result ::Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest.new(name: name, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_flow_validation_result({ name: name, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_flow_validation_result(::Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest.new(name: name, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_flow_validation_result_client_stub.call_count
      end
    end
  end

  def test_import_flow
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    flow_uri = "hello world"
    import_option = :IMPORT_OPTION_UNSPECIFIED
    flow_import_strategy = {}

    import_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_import_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_flow({ parent: parent, flow_uri: flow_uri, import_option: import_option, flow_import_strategy: flow_import_strategy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_flow parent: parent, flow_uri: flow_uri, import_option: import_option, flow_import_strategy: flow_import_strategy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_flow ::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest.new(parent: parent, flow_uri: flow_uri, import_option: import_option, flow_import_strategy: flow_import_strategy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_flow({ parent: parent, flow_uri: flow_uri, import_option: import_option, flow_import_strategy: flow_import_strategy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_flow(::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest.new(parent: parent, flow_uri: flow_uri, import_option: import_option, flow_import_strategy: flow_import_strategy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_flow_client_stub.call_count
      end
    end
  end

  def test_export_flow
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    flow_uri = "hello world"
    include_referenced_flows = true

    export_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.stub :transcode_export_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_flow({ name: name, flow_uri: flow_uri, include_referenced_flows: include_referenced_flows }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_flow name: name, flow_uri: flow_uri, include_referenced_flows: include_referenced_flows do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_flow ::Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest.new(name: name, flow_uri: flow_uri, include_referenced_flows: include_referenced_flows) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_flow({ name: name, flow_uri: flow_uri, include_referenced_flows: include_referenced_flows }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_flow(::Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest.new(name: name, flow_uri: flow_uri, include_referenced_flows: include_referenced_flows), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_flow_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client::Configuration, config
  end
end
