# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dialogflow/cx/v3/environment_pb"
require "google/cloud/dialogflow/cx/v3/environments/rest"


class ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_environments
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListEnvironmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_environments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_list_environments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_environments_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_environments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_environments ::Google::Cloud::Dialogflow::CX::V3::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_environments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_environments(::Google::Cloud::Dialogflow::CX::V3::ListEnvironmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_environments_client_stub.call_count
      end
    end
  end

  def test_get_environment
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::Environment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_get_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_environment ::Google::Cloud::Dialogflow::CX::V3::GetEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_environment(::Google::Cloud::Dialogflow::CX::V3::GetEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_environment_client_stub.call_count
      end
    end
  end

  def test_create_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    environment = {}

    create_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_create_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_environment({ parent: parent, environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_environment parent: parent, environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_environment ::Google::Cloud::Dialogflow::CX::V3::CreateEnvironmentRequest.new(parent: parent, environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_environment({ parent: parent, environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_environment(::Google::Cloud::Dialogflow::CX::V3::CreateEnvironmentRequest.new(parent: parent, environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_environment_client_stub.call_count
      end
    end
  end

  def test_update_environment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = {}
    update_mask = {}

    update_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_update_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_environment({ environment: environment, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_environment environment: environment, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_environment ::Google::Cloud::Dialogflow::CX::V3::UpdateEnvironmentRequest.new(environment: environment, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_environment({ environment: environment, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_environment(::Google::Cloud::Dialogflow::CX::V3::UpdateEnvironmentRequest.new(environment: environment, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_environment_client_stub.call_count
      end
    end
  end

  def test_delete_environment
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_environment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_delete_environment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_environment_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_environment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_environment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_environment ::Google::Cloud::Dialogflow::CX::V3::DeleteEnvironmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_environment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_environment(::Google::Cloud::Dialogflow::CX::V3::DeleteEnvironmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_environment_client_stub.call_count
      end
    end
  end

  def test_lookup_environment_history
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::LookupEnvironmentHistoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    lookup_environment_history_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_lookup_environment_history_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_environment_history_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_environment_history({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_environment_history name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_environment_history ::Google::Cloud::Dialogflow::CX::V3::LookupEnvironmentHistoryRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_environment_history({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_environment_history(::Google::Cloud::Dialogflow::CX::V3::LookupEnvironmentHistoryRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_environment_history_client_stub.call_count
      end
    end
  end

  def test_run_continuous_test
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"

    run_continuous_test_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_run_continuous_test_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_continuous_test_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_continuous_test({ environment: environment }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_continuous_test environment: environment do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_continuous_test ::Google::Cloud::Dialogflow::CX::V3::RunContinuousTestRequest.new(environment: environment) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_continuous_test({ environment: environment }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_continuous_test(::Google::Cloud::Dialogflow::CX::V3::RunContinuousTestRequest.new(environment: environment), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_continuous_test_client_stub.call_count
      end
    end
  end

  def test_list_continuous_test_results
    # Create test objects.
    client_result = ::Google::Cloud::Dialogflow::CX::V3::ListContinuousTestResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_continuous_test_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_list_continuous_test_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_continuous_test_results_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_continuous_test_results({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_continuous_test_results parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_continuous_test_results ::Google::Cloud::Dialogflow::CX::V3::ListContinuousTestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_continuous_test_results({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_continuous_test_results(::Google::Cloud::Dialogflow::CX::V3::ListContinuousTestResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_continuous_test_results_client_stub.call_count
      end
    end
  end

  def test_deploy_flow
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    environment = "hello world"
    flow_version = "hello world"

    deploy_flow_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::ServiceStub.stub :transcode_deploy_flow_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_flow_client_stub do
        # Create client
        client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_flow({ environment: environment, flow_version: flow_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_flow environment: environment, flow_version: flow_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_flow ::Google::Cloud::Dialogflow::CX::V3::DeployFlowRequest.new(environment: environment, flow_version: flow_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_flow({ environment: environment, flow_version: flow_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_flow(::Google::Cloud::Dialogflow::CX::V3::DeployFlowRequest.new(environment: environment, flow_version: flow_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_flow_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::Environments::Rest::Client::Configuration, config
  end
end
