# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dialogflow/cx/v3/entity_type_pb"
require "google/cloud/dialogflow/cx/v3/entity_types"

class ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::EntityType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"

    get_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entity_type, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::GetEntityTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entity_type({ name: name, language_code: language_code }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entity_type name: name, language_code: language_code do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entity_type ::Google::Cloud::Dialogflow::CX::V3::GetEntityTypeRequest.new(name: name, language_code: language_code) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entity_type({ name: name, language_code: language_code }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entity_type(::Google::Cloud::Dialogflow::CX::V3::GetEntityTypeRequest.new(name: name, language_code: language_code), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entity_type_client_stub.call_rpc_count
    end
  end

  def test_create_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::EntityType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entity_type = {}
    language_code = "hello world"

    create_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entity_type, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::CreateEntityTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::CX::V3::EntityType), request["entity_type"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entity_type({ parent: parent, entity_type: entity_type, language_code: language_code }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entity_type parent: parent, entity_type: entity_type, language_code: language_code do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entity_type ::Google::Cloud::Dialogflow::CX::V3::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, language_code: language_code) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entity_type({ parent: parent, entity_type: entity_type, language_code: language_code }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entity_type(::Google::Cloud::Dialogflow::CX::V3::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, language_code: language_code), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entity_type_client_stub.call_rpc_count
    end
  end

  def test_update_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::EntityType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entity_type = {}
    language_code = "hello world"
    update_mask = {}

    update_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entity_type, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::UpdateEntityTypeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dialogflow::CX::V3::EntityType), request["entity_type"]
      assert_equal "hello world", request["language_code"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entity_type({ entity_type: entity_type, language_code: language_code, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entity_type entity_type: entity_type, language_code: language_code, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entity_type ::Google::Cloud::Dialogflow::CX::V3::UpdateEntityTypeRequest.new(entity_type: entity_type, language_code: language_code, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entity_type({ entity_type: entity_type, language_code: language_code, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entity_type(::Google::Cloud::Dialogflow::CX::V3::UpdateEntityTypeRequest.new(entity_type: entity_type, language_code: language_code, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entity_type_client_stub.call_rpc_count
    end
  end

  def test_delete_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entity_type, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::DeleteEntityTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entity_type({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entity_type name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entity_type ::Google::Cloud::Dialogflow::CX::V3::DeleteEntityTypeRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entity_type({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entity_type(::Google::Cloud::Dialogflow::CX::V3::DeleteEntityTypeRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entity_type_client_stub.call_rpc_count
    end
  end

  def test_list_entity_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dialogflow::CX::V3::ListEntityTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    language_code = "hello world"
    page_size = 42
    page_token = "hello world"

    list_entity_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entity_types, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ListEntityTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["language_code"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entity_types_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entity_types({ parent: parent, language_code: language_code, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entity_types parent: parent, language_code: language_code, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entity_types ::Google::Cloud::Dialogflow::CX::V3::ListEntityTypesRequest.new(parent: parent, language_code: language_code, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entity_types({ parent: parent, language_code: language_code, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entity_types(::Google::Cloud::Dialogflow::CX::V3::ListEntityTypesRequest.new(parent: parent, language_code: language_code, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entity_types_client_stub.call_rpc_count
    end
  end

  def test_export_entity_types
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entity_types = ["hello world"]
    entity_types_uri = "hello world"
    data_format = :DATA_FORMAT_UNSPECIFIED
    language_code = "hello world"

    export_entity_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_entity_types, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal ["hello world"], request["entity_types"]
      assert_equal "hello world", request["entity_types_uri"]
      assert_equal :entity_types_uri, request.destination
      assert_equal :DATA_FORMAT_UNSPECIFIED, request["data_format"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_entity_types_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_entity_types({ parent: parent, entity_types: entity_types, entity_types_uri: entity_types_uri, data_format: data_format, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_entity_types parent: parent, entity_types: entity_types, entity_types_uri: entity_types_uri, data_format: data_format, language_code: language_code do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_entity_types ::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest.new(parent: parent, entity_types: entity_types, entity_types_uri: entity_types_uri, data_format: data_format, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_entity_types({ parent: parent, entity_types: entity_types, entity_types_uri: entity_types_uri, data_format: data_format, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_entity_types(::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest.new(parent: parent, entity_types: entity_types, entity_types_uri: entity_types_uri, data_format: data_format, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_entity_types_client_stub.call_rpc_count
    end
  end

  def test_import_entity_types
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entity_types_uri = "hello world"
    merge_option = :MERGE_OPTION_UNSPECIFIED
    target_entity_type = "hello world"

    import_entity_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_entity_types, name
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::ImportEntityTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entity_types_uri"]
      assert_equal :entity_types_uri, request.entity_types
      assert_equal :MERGE_OPTION_UNSPECIFIED, request["merge_option"]
      assert_equal "hello world", request["target_entity_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_entity_types_client_stub do
      # Create client
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_entity_types({ parent: parent, entity_types_uri: entity_types_uri, merge_option: merge_option, target_entity_type: target_entity_type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_entity_types parent: parent, entity_types_uri: entity_types_uri, merge_option: merge_option, target_entity_type: target_entity_type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_entity_types ::Google::Cloud::Dialogflow::CX::V3::ImportEntityTypesRequest.new(parent: parent, entity_types_uri: entity_types_uri, merge_option: merge_option, target_entity_type: target_entity_type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_entity_types({ parent: parent, entity_types_uri: entity_types_uri, merge_option: merge_option, target_entity_type: target_entity_type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_entity_types(::Google::Cloud::Dialogflow::CX::V3::ImportEntityTypesRequest.new(parent: parent, entity_types_uri: entity_types_uri, merge_option: merge_option, target_entity_type: target_entity_type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_entity_types_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Operations, client.operations_client
  end
end
