# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # Webhooks host the developer's business logic. During a session, webhooks
          # allow the developer to use the data extracted by Dialogflow's natural
          # language processing to generate dynamic responses, validate collected data,
          # or trigger actions on the backend.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the webhook.
          #     Required for the
          #     {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#update_webhook Webhooks.UpdateWebhook}
          #     method.
          #     {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#create_webhook Webhooks.CreateWebhook}
          #     populates the name automatically. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The human-readable name of the webhook, unique within the agent.
          # @!attribute [rw] generic_web_service
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService]
          #     Configuration for a generic web service.
          #
          #     Note: The following fields are mutually exclusive: `generic_web_service`, `service_directory`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] service_directory
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::ServiceDirectoryConfig]
          #     Configuration for a [Service
          #     Directory](https://cloud.google.com/service-directory) service.
          #
          #     Note: The following fields are mutually exclusive: `service_directory`, `generic_web_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] timeout
          #   @return [::Google::Protobuf::Duration]
          #     Webhook execution timeout. Execution is considered failed if Dialogflow
          #     doesn't receive a response from webhook at the end of the timeout period.
          #     Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Indicates whether the webhook is disabled.
          class Webhook
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents configuration for a generic web service.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Required. The webhook URI for receiving POST requests. It must use https
            #     protocol.
            # @!attribute [rw] username
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::String]
            #     The user name for HTTP Basic authentication.
            # @!attribute [rw] password
            #   @deprecated This field is deprecated and may be removed in the next major version update.
            #   @return [::String]
            #     The password for HTTP Basic authentication.
            # @!attribute [rw] request_headers
            #   @return [::Google::Protobuf::Map{::String => ::String}]
            #     The HTTP request headers to send together with webhook requests.
            # @!attribute [rw] allowed_ca_certs
            #   @return [::Array<::String>]
            #     Optional. Specifies a list of allowed custom CA certificates (in DER
            #     format) for HTTPS verification. This overrides the default SSL trust
            #     store. If this is empty or unspecified, Dialogflow will use Google's
            #     default trust store to verify certificates. N.B. Make sure the HTTPS
            #     server certificates are signed with "subject alt name". For instance a
            #     certificate can be self-signed using the following command,
            #     ```
            #        openssl x509 -req -days 200 -in example.com.csr \
            #          -signkey example.com.key \
            #          -out example.com.crt \
            #          -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
            #     ```
            # @!attribute [rw] oauth_config
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService::OAuthConfig]
            #     Optional. The OAuth configuration of the webhook. If specified,
            #     Dialogflow will initiate the OAuth client credential flow to exchange an
            #     access token from the 3rd party platform and put it in the auth header.
            # @!attribute [rw] service_agent_auth
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService::ServiceAgentAuth]
            #     Optional. Indicate the auth token type generated from the [Diglogflow
            #     service
            #     agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
            #     The generated token is sent in the Authorization header.
            # @!attribute [rw] webhook_type
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService::WebhookType]
            #     Optional. Type of the webhook.
            # @!attribute [rw] http_method
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService::HttpMethod]
            #     Optional. HTTP method for the flexible webhook calls. Standard webhook
            #     always uses POST.
            # @!attribute [rw] request_body
            #   @return [::String]
            #     Optional. Defines a custom JSON object as request body to send to
            #     flexible webhook.
            # @!attribute [rw] parameter_mapping
            #   @return [::Google::Protobuf::Map{::String => ::String}]
            #     Optional. Maps the values extracted from specific fields of the flexible
            #     webhook response into session parameters.
            #     - Key: session parameter name
            #     - Value: field path in the webhook response
            class GenericWebService
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Represents configuration of OAuth client credential flow for 3rd party
              # API authentication.
              # @!attribute [rw] client_id
              #   @return [::String]
              #     Required. The client ID provided by the 3rd party platform.
              # @!attribute [rw] client_secret
              #   @return [::String]
              #     Optional. The client secret provided by the 3rd party platform.
              # @!attribute [rw] token_endpoint
              #   @return [::String]
              #     Required. The token endpoint provided by the 3rd party platform to
              #     exchange an access token.
              # @!attribute [rw] scopes
              #   @return [::Array<::String>]
              #     Optional. The OAuth scopes to grant.
              class OAuthConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::String]
              class RequestHeadersEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::String]
              class ParameterMappingEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Indicate the auth token type generated from the [Diglogflow service
              # agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
              module ServiceAgentAuth
                # Service agent auth type unspecified. Default to ID_TOKEN.
                SERVICE_AGENT_AUTH_UNSPECIFIED = 0

                # No token used.
                NONE = 1

                # Use [ID
                # token](https://cloud.google.com/docs/authentication/token-types#id)
                # generated from service agent. This can be used to access Cloud Function
                # and Cloud Run after you grant Invoker role to
                # `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
                ID_TOKEN = 2

                # Use [access
                # token](https://cloud.google.com/docs/authentication/token-types#access)
                # generated from service agent. This can be used to access other Google
                # Cloud APIs after you grant required roles to
                # `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
                ACCESS_TOKEN = 3
              end

              # Represents the type of webhook configuration.
              module WebhookType
                # Default value. This value is unused.
                WEBHOOK_TYPE_UNSPECIFIED = 0

                # Represents a standard webhook.
                STANDARD = 1

                # Represents a flexible webhook.
                FLEXIBLE = 2
              end

              # HTTP method to use when calling webhooks.
              module HttpMethod
                # HTTP method not specified.
                HTTP_METHOD_UNSPECIFIED = 0

                # HTTP POST Method.
                POST = 1

                # HTTP GET Method.
                GET = 2

                # HTTP HEAD Method.
                HEAD = 3

                # HTTP PUT Method.
                PUT = 4

                # HTTP DELETE Method.
                DELETE = 5

                # HTTP PATCH Method.
                PATCH = 6

                # HTTP OPTIONS Method.
                OPTIONS = 7
              end
            end

            # Represents configuration for a [Service
            # Directory](https://cloud.google.com/service-directory) service.
            # @!attribute [rw] service
            #   @return [::String]
            #     Required. The name of [Service
            #     Directory](https://cloud.google.com/service-directory) service.
            #     Format:
            #     `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
            #     `Location ID` of the service directory must be the same as the location
            #     of the agent.
            # @!attribute [rw] generic_web_service
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook::GenericWebService]
            #     Generic Service configuration of this webhook.
            class ServiceDirectoryConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#list_webhooks Webhooks.ListWebhooks}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to list all webhooks for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return in a single page. By default 100 and
          #     at most 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous list request.
          class ListWebhooksRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#list_webhooks Webhooks.ListWebhooks}.
          # @!attribute [rw] webhooks
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::Webhook>]
          #     The list of webhooks. There will be a maximum number of items returned
          #     based on the page_size field in the request.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          class ListWebhooksResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#get_webhook Webhooks.GetWebhook}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the webhook.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
          class GetWebhookRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#create_webhook Webhooks.CreateWebhook}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to create a webhook for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] webhook
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook]
          #     Required. The webhook to create.
          class CreateWebhookRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#update_webhook Webhooks.UpdateWebhook}.
          # @!attribute [rw] webhook
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Webhook]
          #     Required. The webhook to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The mask to control which fields get updated. If the mask is not present,
          #     all fields will be updated.
          class UpdateWebhookRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Client#delete_webhook Webhooks.DeleteWebhook}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the webhook to delete.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     This field has no effect for webhook not being used.
          #     For webhooks that are used by pages/flows/transition route groups:
          #
          #     *  If `force` is set to false, an error will be returned with message
          #        indicating the referenced resources.
          #     *  If `force` is set to true, Dialogflow will remove the webhook, as well
          #        as any references to the webhook (i.e.
          #        {::Google::Cloud::Dialogflow::CX::V3::Fulfillment#webhook Webhook} and
          #        {::Google::Cloud::Dialogflow::CX::V3::Fulfillment#tag tag}in fulfillments that
          #        point to this webhook will be removed).
          class DeleteWebhookRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for a webhook call. The request is sent as a JSON object
          # and the field names will be presented in camel cases.
          #
          # You may see undocumented fields in an actual request. These fields are used
          # internally by Dialogflow and should be ignored.
          # @!attribute [rw] detect_intent_response_id
          #   @return [::String]
          #     Always present. The unique identifier of the
          #     {::Google::Cloud::Dialogflow::CX::V3::DetectIntentResponse DetectIntentResponse}
          #     that will be returned to the API caller.
          # @!attribute [rw] text
          #   @return [::String]
          #     If {::Google::Cloud::Dialogflow::CX::V3::TextInput natural language text} was
          #     provided as input, this field will contain a copy of the text.
          #
          #     Note: The following fields are mutually exclusive: `text`, `trigger_intent`, `transcript`, `trigger_event`, `dtmf_digits`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] trigger_intent
          #   @return [::String]
          #     If an {::Google::Cloud::Dialogflow::CX::V3::IntentInput intent} was provided as
          #     input, this field will contain a copy of the intent identifier. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/intents/<IntentID>`.
          #
          #     Note: The following fields are mutually exclusive: `trigger_intent`, `text`, `transcript`, `trigger_event`, `dtmf_digits`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] transcript
          #   @return [::String]
          #     If [natural language speech
          #     audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
          #     this field will contain the transcript for the audio.
          #
          #     Note: The following fields are mutually exclusive: `transcript`, `text`, `trigger_intent`, `trigger_event`, `dtmf_digits`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] trigger_event
          #   @return [::String]
          #     If an {::Google::Cloud::Dialogflow::CX::V3::EventInput event} was provided as
          #     input, this field will contain the name of the event.
          #
          #     Note: The following fields are mutually exclusive: `trigger_event`, `text`, `trigger_intent`, `transcript`, `dtmf_digits`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] dtmf_digits
          #   @return [::String]
          #     If {::Google::Cloud::Dialogflow::CX::V3::DtmfInput DTMF} was provided as input,
          #     this field will contain the DTMF digits.
          #
          #     Note: The following fields are mutually exclusive: `dtmf_digits`, `text`, `trigger_intent`, `transcript`, `trigger_event`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language code specified in the [original
          #     request][QueryInput.language_code].
          # @!attribute [rw] fulfillment_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookRequest::FulfillmentInfo]
          #     Always present. Information about the fulfillment that triggered this
          #     webhook call.
          # @!attribute [rw] intent_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookRequest::IntentInfo]
          #     Information about the last matched intent.
          # @!attribute [rw] page_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::PageInfo]
          #     Information about page status.
          # @!attribute [rw] session_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::SessionInfo]
          #     Information about session status.
          # @!attribute [rw] messages
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::ResponseMessage>]
          #     The list of rich message responses to present to the user. Webhook can
          #     choose to append or replace this list in
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse#fulfillment_response WebhookResponse.fulfillment_response};
          # @!attribute [rw] payload
          #   @return [::Google::Protobuf::Struct]
          #     Custom data set in
          #     {::Google::Cloud::Dialogflow::CX::V3::QueryParameters#payload QueryParameters.payload}.
          # @!attribute [rw] sentiment_analysis_result
          #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookRequest::SentimentAnalysisResult]
          #     The sentiment analysis result of the current user request. The field is
          #     filled when sentiment analysis is configured to be enabled for the request.
          # @!attribute [rw] language_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::LanguageInfo]
          #     Information about the language of the request.
          class WebhookRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents fulfillment information communicated to the webhook.
            # @!attribute [rw] tag
            #   @return [::String]
            #     Always present.
            #     The value of the
            #     {::Google::Cloud::Dialogflow::CX::V3::Fulfillment#tag Fulfillment.tag} field
            #     will be populated in this field by Dialogflow when the associated webhook
            #     is called. The tag is typically used by the webhook service to identify
            #     which fulfillment is being called, but it could be used for other
            #     purposes.
            class FulfillmentInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represents intent information communicated to the webhook.
            # @!attribute [rw] last_matched_intent
            #   @return [::String]
            #     Always present. The unique identifier of the last matched
            #     {::Google::Cloud::Dialogflow::CX::V3::Intent intent}.
            #     Format:
            #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/intents/<IntentID>`.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Always present. The display name of the last matched
            #     {::Google::Cloud::Dialogflow::CX::V3::Intent intent}.
            # @!attribute [rw] parameters
            #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dialogflow::CX::V3::WebhookRequest::IntentInfo::IntentParameterValue}]
            #     Parameters identified as a result of intent matching. This is a map of
            #     the name of the identified parameter to the value of the parameter
            #     identified from the user's utterance. All parameters defined in the
            #     matched intent that are identified will be surfaced here.
            # @!attribute [rw] confidence
            #   @return [::Float]
            #     The confidence of the matched intent. Values range from 0.0 (completely
            #     uncertain) to 1.0 (completely certain).
            class IntentInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Represents a value for an intent parameter.
              # @!attribute [rw] original_value
              #   @return [::String]
              #     Always present. Original text value extracted from user utterance.
              # @!attribute [rw] resolved_value
              #   @return [::Google::Protobuf::Value]
              #     Always present. Structured value for the parameter extracted from user
              #     utterance.
              class IntentParameterValue
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookRequest::IntentInfo::IntentParameterValue]
              class ParametersEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Represents the result of sentiment analysis.
            # @!attribute [rw] score
            #   @return [::Float]
            #     Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
            #      sentiment).
            # @!attribute [rw] magnitude
            #   @return [::Float]
            #     A non-negative number in the [0, +inf) range, which represents the
            #     absolute magnitude of sentiment, regardless of score (positive or
            #     negative).
            class SentimentAnalysisResult
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The response message for a webhook call.
          # @!attribute [rw] fulfillment_response
          #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookResponse::FulfillmentResponse]
          #     The fulfillment response to send to the user. This field can be omitted by
          #     the webhook if it does not intend to send any response to the user.
          # @!attribute [rw] page_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::PageInfo]
          #     Information about page status. This field can be omitted by the webhook if
          #     it does not intend to modify page status.
          # @!attribute [rw] session_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::SessionInfo]
          #     Information about session status. This field can be omitted by the webhook
          #     if it does not intend to modify session status.
          # @!attribute [rw] payload
          #   @return [::Google::Protobuf::Struct]
          #     Value to append directly to
          #     {::Google::Cloud::Dialogflow::CX::V3::QueryResult#webhook_payloads QueryResult.webhook_payloads}.
          # @!attribute [rw] target_page
          #   @return [::String]
          #     The target page to transition to.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`.
          #
          #     Note: The following fields are mutually exclusive: `target_page`, `target_flow`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] target_flow
          #   @return [::String]
          #     The target flow to transition to.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
          #
          #     Note: The following fields are mutually exclusive: `target_flow`, `target_page`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class WebhookResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents a fulfillment response to the user.
            # @!attribute [rw] messages
            #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::ResponseMessage>]
            #     The list of rich message responses to present to the user.
            # @!attribute [rw] merge_behavior
            #   @return [::Google::Cloud::Dialogflow::CX::V3::WebhookResponse::FulfillmentResponse::MergeBehavior]
            #     Merge behavior for `messages`.
            class FulfillmentResponse
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Defines merge behavior for `messages`.
              module MergeBehavior
                # Not specified. `APPEND` will be used.
                MERGE_BEHAVIOR_UNSPECIFIED = 0

                # `messages` will be appended to the list of messages waiting to be sent
                # to the user.
                APPEND = 1

                # `messages` will replace the list of messages waiting to be sent to the
                # user.
                REPLACE = 2
              end
            end
          end

          # Represents page information communicated to and from the webhook.
          # @!attribute [rw] current_page
          #   @return [::String]
          #     Always present for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}. Ignored for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
          #     unique identifier of the current page. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Always present for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}. Ignored for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
          #     display name of the current page.
          # @!attribute [rw] form_info
          #   @return [::Google::Cloud::Dialogflow::CX::V3::PageInfo::FormInfo]
          #     Optional for both
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest} and
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}.
          #     Information about the form.
          class PageInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents form information.
            # @!attribute [rw] parameter_info
            #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::PageInfo::FormInfo::ParameterInfo>]
            #     Optional for both
            #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest} and
            #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
            #     parameters contained in the form. Note that the webhook cannot add or
            #     remove any form parameter.
            class FormInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Represents parameter information.
              # @!attribute [rw] display_name
              #   @return [::String]
              #     Always present for
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}.
              #     Required for
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}.
              #     The human-readable name of the parameter, unique within the form. This
              #     field cannot be modified by the webhook.
              # @!attribute [rw] required
              #   @return [::Boolean]
              #     Optional for both
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest} and
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}.
              #     Indicates whether the parameter is required. Optional parameters will
              #     not trigger prompts; however, they are filled if the user specifies
              #     them. Required parameters must be filled before form filling concludes.
              # @!attribute [rw] state
              #   @return [::Google::Cloud::Dialogflow::CX::V3::PageInfo::FormInfo::ParameterInfo::ParameterState]
              #     Always present for
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}.
              #     Required for
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
              #     state of the parameter. This field can be set to
              #     {::Google::Cloud::Dialogflow::CX::V3::PageInfo::FormInfo::ParameterInfo::ParameterState::INVALID INVALID}
              #     by the webhook to invalidate the parameter; other values set by the
              #     webhook will be ignored.
              # @!attribute [rw] value
              #   @return [::Google::Protobuf::Value]
              #     Optional for both
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest} and
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
              #     value of the parameter. This field can be set by the webhook to change
              #     the parameter value.
              # @!attribute [rw] just_collected
              #   @return [::Boolean]
              #     Optional for
              #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}. Ignored
              #     for {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}.
              #     Indicates if the parameter value was just collected on the last
              #     conversation turn.
              class ParameterInfo
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Represents the state of a parameter.
                module ParameterState
                  # Not specified. This value should be never used.
                  PARAMETER_STATE_UNSPECIFIED = 0

                  # Indicates that the parameter does not have a value.
                  EMPTY = 1

                  # Indicates that the parameter value is invalid. This field can be used
                  # by the webhook to invalidate the parameter and ask the server to
                  # collect it from the user again.
                  INVALID = 2

                  # Indicates that the parameter has a value.
                  FILLED = 3
                end
              end
            end
          end

          # Represents session information communicated to and from the webhook.
          # @!attribute [rw] session
          #   @return [::String]
          #     Always present for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}. Ignored for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. The
          #     unique identifier of the
          #     {::Google::Cloud::Dialogflow::CX::V3::DetectIntentRequest#session session}. This
          #     field can be used by the webhook to identify a session.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/sessions/<SessionID>`
          #     or
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/sessions/<SessionID>`
          #     if environment is specified.
          # @!attribute [rw] parameters
          #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
          #     Optional for
          #     {::Google::Cloud::Dialogflow::CX::V3::WebhookRequest WebhookRequest}. Optional
          #     for {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}. All
          #     parameters collected from forms and intents during the session. Parameters
          #     can be created, updated, or removed by the webhook. To remove a parameter
          #     from the session, the webhook should explicitly set the parameter value to
          #     null in {::Google::Cloud::Dialogflow::CX::V3::WebhookResponse WebhookResponse}.
          #     The map is keyed by parameters' display names.
          class SessionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            class ParametersEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Represents the language information of the request.
          # @!attribute [rw] input_language_code
          #   @return [::String]
          #     The language code specified in the original
          #     {::Google::Cloud::Dialogflow::CX::V3::QueryInput#language_code request}.
          # @!attribute [rw] resolved_language_code
          #   @return [::String]
          #     The language code detected for this request based on the user
          #     conversation.
          # @!attribute [rw] confidence_score
          #   @return [::Float]
          #     The confidence score of the detected language between 0 and 1.
          class LanguageInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
