# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # Generators contain prompt to be sent to the LLM model to generate text. The
          # prompt can contain parameters which will be resolved before calling the
          # model. It can optionally contain banned phrases to ensure the model responses
          # are safe.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the generator.
          #     Must be set for the
          #     {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#update_generator Generators.UpdateGenerator}
          #     method. [Generators.CreateGenerate][] populates the name automatically.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The human-readable name of the generator, unique within the
          #     agent. The prompt contains pre-defined parameters such as $conversation,
          #     $last-user-utterance, etc. populated by Dialogflow. It can also contain
          #     custom placeholders which will be resolved during fulfillment.
          # @!attribute [rw] prompt_text
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Phrase]
          #     Required. Prompt for the LLM model.
          # @!attribute [rw] placeholders
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::Generator::Placeholder>]
          #     Optional. List of custom placeholders in the prompt text.
          # @!attribute [rw] model_parameter
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Generator::ModelParameter]
          #     Parameters passed to the LLM to configure its behavior.
          class Generator
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents a custom placeholder in the prompt text.
            # @!attribute [rw] id
            #   @return [::String]
            #     Unique ID used to map custom placeholder to parameters in fulfillment.
            # @!attribute [rw] name
            #   @return [::String]
            #     Custom placeholder value in the prompt text.
            class Placeholder
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Parameters to be passed to the LLM. If not set, default values will be
            # used.
            # @!attribute [rw] temperature
            #   @return [::Float]
            #     The temperature used for sampling. Temperature sampling occurs after both
            #     topP and topK have been applied.
            #     Valid range: [0.0, 1.0]
            #     Low temperature = less random. High temperature = more random.
            # @!attribute [rw] max_decode_steps
            #   @return [::Integer]
            #     The maximum number of tokens to generate.
            # @!attribute [rw] top_p
            #   @return [::Float]
            #     If set, only the tokens comprising the top top_p probability mass are
            #     considered. If both top_p and top_k are
            #     set, top_p will be used for further refining candidates selected with
            #     top_k.
            #     Valid range: (0.0, 1.0].
            #     Small topP = less random. Large topP = more random.
            # @!attribute [rw] top_k
            #   @return [::Integer]
            #     If set, the sampling process in each step is limited to the top_k tokens
            #     with highest probabilities.
            #     Valid range: [1, 40] or 1000+.
            #     Small topK = less random. Large topK = more random.
            class ModelParameter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Text input which can be used for prompt or banned phrases.
          # @!attribute [rw] text
          #   @return [::String]
          #     Required. Text input which can be used for prompt or banned phrases.
          class Phrase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#list_generators Generators.ListGenerators}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to list all generators for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to list generators for.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return in a single page. By default 100 and
          #     at most 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous list request.
          class ListGeneratorsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#list_generators Generators.ListGenerators}.
          # @!attribute [rw] generators
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::Generator>]
          #     The list of generators. There will be a maximum number of items returned
          #     based on the page_size field in the request.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          class ListGeneratorsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#get_generator Generators.GetGenerator}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the generator.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to list generators for.
          class GetGeneratorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#create_generator Generators.CreateGenerator}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to create a generator for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] generator
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Generator]
          #     Required. The generator to create.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to create generators for the following fields:
          #     *  `Generator.prompt_text.text`
          #     If not specified, the agent's default language is used.
          class CreateGeneratorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#update_generator Generators.UpdateGenerator}.
          # @!attribute [rw] generator
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Generator]
          #     Required. The generator to update.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to list generators for.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The mask to control which fields get updated. If the mask is not present,
          #     all fields will be updated.
          class UpdateGeneratorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Generators::Client#delete_generator Generators.DeleteGenerator}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the generator to delete.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     This field has no effect for generators not being used.
          #     For generators that are used by pages/flows/transition route groups:
          #
          #     *  If `force` is set to false, an error will be returned with message
          #        indicating the referenced resources.
          #     *  If `force` is set to true, Dialogflow will remove the generator, as well
          #        as any references to the generator (i.e.
          #        [Generator][Fulfillment.generator]) in fulfillments.
          class DeleteGeneratorRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
