# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # Settings for Generative AI.
          # @!attribute [rw] name
          #   @return [::String]
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings`.
          # @!attribute [rw] fallback_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings::FallbackSettings]
          #     Settings for Generative Fallback.
          # @!attribute [rw] generative_safety_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::SafetySettings]
          #     Settings for Generative Safety.
          # @!attribute [rw] knowledge_connector_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings::KnowledgeConnectorSettings]
          #     Settings for knowledge connector.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Language for this settings.
          class GenerativeSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Settings for Generative Fallback.
            # @!attribute [rw] selected_prompt
            #   @return [::String]
            #     Display name of the selected prompt.
            # @!attribute [rw] prompt_templates
            #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings::FallbackSettings::PromptTemplate>]
            #     Stored prompts that can be selected, for example default templates like
            #     "conservative" or "chatty", or user defined ones.
            class FallbackSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Prompt template.
              # @!attribute [rw] display_name
              #   @return [::String]
              #     Prompt name.
              # @!attribute [rw] prompt_text
              #   @return [::String]
              #     Prompt text that is sent to a LLM on no-match default, placeholders are
              #     filled downstream. For example: "Here is a conversation $conversation,
              #     a response is: "
              # @!attribute [rw] frozen
              #   @return [::Boolean]
              #     If the flag is true, the prompt is frozen and cannot be modified by
              #     users.
              class PromptTemplate
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Settings for knowledge connector. These parameters are used for LLM prompt
            # like "You are <agent>. You are a helpful and verbose <agent_identity> at
            # <business>, <business_description>. Your task is to help humans on
            # <agent_scope>".
            # @!attribute [rw] business
            #   @return [::String]
            #     Name of the company, organization or other entity that the agent
            #     represents. Used for knowledge connector LLM prompt and for knowledge
            #     search.
            # @!attribute [rw] agent
            #   @return [::String]
            #     Name of the virtual agent. Used for LLM prompt. Can be left empty.
            # @!attribute [rw] agent_identity
            #   @return [::String]
            #     Identity of the agent, e.g. "virtual agent", "AI assistant".
            # @!attribute [rw] business_description
            #   @return [::String]
            #     Company description, used for LLM prompt, e.g. "a family company selling
            #     freshly roasted coffee beans".
            # @!attribute [rw] agent_scope
            #   @return [::String]
            #     Agent scope, e.g. "Example company website", "internal Example
            #     company website for employees", "manual of car owner".
            # @!attribute [rw] disable_data_store_fallback
            #   @return [::Boolean]
            #     Whether to disable fallback to Data Store search results (in case the LLM
            #     couldn't pick a proper answer). Per default the feature is enabled.
            class KnowledgeConnectorSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
