# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # Entities are extracted from user input and represent parameters that are
          # meaningful to your application. For example, a date range, a proper name
          # such as a geographic location or landmark, and so on. Entities represent
          # actionable data for your application.
          #
          # When you define an entity, you can also include synonyms that all map to
          # that entity. For example, "soft drink", "soda", "pop", and so on.
          #
          # There are three types of entities:
          #
          # *   **System** - entities that are defined by the Dialogflow API for common
          #     data types such as date, time, currency, and so on. A system entity is
          #     represented by the `EntityType` type.
          #
          # *   **Custom** - entities that are defined by you that represent
          #     actionable data that is meaningful to your application. For example,
          #     you could define a `pizza.sauce` entity for red or white pizza sauce,
          #     a `pizza.cheese` entity for the different types of cheese on a pizza,
          #     a `pizza.topping` entity for different toppings, and so on. A custom
          #     entity is represented by the `EntityType` type.
          #
          # *   **User** - entities that are built for an individual user such as
          #     favorites, preferences, playlists, and so on. A user entity is
          #     represented by the
          #     {::Google::Cloud::Dialogflow::CX::V3::SessionEntityType SessionEntityType}
          #     type.
          #
          # For more information about entity types, see the [Dialogflow
          # documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the entity type.
          #     Required for
          #     {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#update_entity_type EntityTypes.UpdateEntityType}.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The human-readable name of the entity type, unique within the
          #     agent.
          # @!attribute [rw] kind
          #   @return [::Google::Cloud::Dialogflow::CX::V3::EntityType::Kind]
          #     Required. Indicates the kind of entity type.
          # @!attribute [rw] auto_expansion_mode
          #   @return [::Google::Cloud::Dialogflow::CX::V3::EntityType::AutoExpansionMode]
          #     Indicates whether the entity type can be automatically expanded.
          # @!attribute [rw] entities
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::EntityType::Entity>]
          #     The collection of entity entries associated with the entity type.
          # @!attribute [rw] excluded_phrases
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::EntityType::ExcludedPhrase>]
          #     Collection of exceptional words and phrases that shouldn't be matched.
          #     For example, if you have a size entity type with entry `giant`(an
          #     adjective), you might consider adding `giants`(a noun) as an exclusion.
          #     If the kind of entity type is `KIND_MAP`, then the phrases specified by
          #     entities and excluded phrases should be mutually exclusive.
          # @!attribute [rw] enable_fuzzy_extraction
          #   @return [::Boolean]
          #     Enables fuzzy entity extraction during classification.
          # @!attribute [rw] redact
          #   @return [::Boolean]
          #     Indicates whether parameters of the entity type should be redacted in log.
          #     If redaction is enabled, page parameters and intent parameters referring to
          #     the entity type will be replaced by parameter name when logging.
          class EntityType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An **entity entry** for an associated entity type.
            # @!attribute [rw] value
            #   @return [::String]
            #     Required. The primary value associated with this entity entry.
            #     For example, if the entity type is *vegetable*, the value could be
            #     *scallions*.
            #
            #     For `KIND_MAP` entity types:
            #
            #     *   A canonical value to be used in place of synonyms.
            #
            #     For `KIND_LIST` entity types:
            #
            #     *   A string that can contain references to other entity types (with or
            #         without aliases).
            # @!attribute [rw] synonyms
            #   @return [::Array<::String>]
            #     Required. A collection of value synonyms. For example, if the entity type
            #     is *vegetable*, and `value` is *scallions*, a synonym could be *green
            #     onions*.
            #
            #     For `KIND_LIST` entity types:
            #
            #     *   This collection must contain exactly one synonym equal to `value`.
            class Entity
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # An excluded entity phrase that should not be matched.
            # @!attribute [rw] value
            #   @return [::String]
            #     Required. The word or phrase to be excluded.
            class ExcludedPhrase
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represents kinds of entities.
            module Kind
              # Not specified. This value should be never used.
              KIND_UNSPECIFIED = 0

              # Map entity types allow mapping of a group of synonyms to a canonical
              # value.
              KIND_MAP = 1

              # List entity types contain a set of entries that do not map to canonical
              # values. However, list entity types can contain references to other entity
              # types (with or without aliases).
              KIND_LIST = 2

              # Regexp entity types allow to specify regular expressions in entries
              # values.
              KIND_REGEXP = 3
            end

            # Represents different entity type expansion modes. Automated expansion
            # allows an agent to recognize values that have not been explicitly listed in
            # the entity (for example, new kinds of shopping list items).
            module AutoExpansionMode
              # Auto expansion disabled for the entity.
              AUTO_EXPANSION_MODE_UNSPECIFIED = 0

              # Allows an agent to recognize values that have not been explicitly
              # listed in the entity.
              AUTO_EXPANSION_MODE_DEFAULT = 1
            end
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#export_entity_types EntityTypes.ExportEntityTypes}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the parent agent to export entity types.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] entity_types
          #   @return [::Array<::String>]
          #     Required. The name of the entity types to export.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
          # @!attribute [rw] entity_types_uri
          #   @return [::String]
          #     Optional. The [Google Cloud
          #     Storage](https://cloud.google.com/storage/docs/) URI to export the entity
          #     types to. The format of this URI must be
          #     `gs://<bucket-name>/<object-name>`.
          #
          #     Dialogflow performs a write operation for the Cloud Storage object
          #     on the caller's behalf, so your request authentication must
          #     have write permissions for the object. For more information, see
          #     [Dialogflow access
          #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
          #
          #     Note: The following fields are mutually exclusive: `entity_types_uri`, `entity_types_content_inline`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] entity_types_content_inline
          #   @return [::Boolean]
          #     Optional. The option to return the serialized entity types inline.
          #
          #     Note: The following fields are mutually exclusive: `entity_types_content_inline`, `entity_types_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_format
          #   @return [::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest::DataFormat]
          #     Optional. The data format of the exported entity types. If not specified,
          #     `BLOB` is assumed.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. The language to retrieve the entity type for. The following
          #     fields are language dependent:
          #
          #     *   `EntityType.entities.value`
          #     *   `EntityType.entities.synonyms`
          #     *   `EntityType.excluded_phrases.value`
          #
          #     If not specified, all language dependent fields will be retrieved.
          #     [Many
          #     languages](https://cloud.google.com/dialogflow/docs/reference/language)
          #     are supported.
          #     Note: languages must be enabled in the agent before they can be used.
          class ExportEntityTypesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Data format of the exported entity types.
            module DataFormat
              # Unspecified format. Treated as `BLOB`.
              DATA_FORMAT_UNSPECIFIED = 0

              # EntityTypes will be exported as raw bytes.
              BLOB = 1

              # EntityTypes will be exported in JSON Package format.
              JSON_PACKAGE = 5
            end
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#export_entity_types EntityTypes.ExportEntityTypes}.
          # @!attribute [rw] entity_types_uri
          #   @return [::String]
          #     The URI to a file containing the exported entity types. This field is
          #     populated only if `entity_types_uri` is specified in
          #     {::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest ExportEntityTypesRequest}.
          #
          #     Note: The following fields are mutually exclusive: `entity_types_uri`, `entity_types_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] entity_types_content
          #   @return [::Google::Cloud::Dialogflow::CX::V3::InlineDestination]
          #     Uncompressed byte content for entity types. This field is populated only
          #     if `entity_types_content_inline` is set to true in
          #     {::Google::Cloud::Dialogflow::CX::V3::ExportEntityTypesRequest ExportEntityTypesRequest}.
          #
          #     Note: The following fields are mutually exclusive: `entity_types_content`, `entity_types_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ExportEntityTypesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata returned for the
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#export_entity_types EntityTypes.ExportEntityTypes}
          # long running operation.
          class ExportEntityTypesMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#import_entity_types EntityTypes.ImportEntityTypes}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to import the entity types into.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] entity_types_uri
          #   @return [::String]
          #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
          #     to import entity types from. The format of this URI must be
          #     `gs://<bucket-name>/<object-name>`.
          #
          #     Dialogflow performs a read operation for the Cloud Storage object
          #     on the caller's behalf, so your request authentication must
          #     have read permissions for the object. For more information, see
          #     [Dialogflow access
          #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
          #
          #     Note: The following fields are mutually exclusive: `entity_types_uri`, `entity_types_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] entity_types_content
          #   @return [::Google::Cloud::Dialogflow::CX::V3::InlineSource]
          #     Uncompressed byte content of entity types.
          #
          #     Note: The following fields are mutually exclusive: `entity_types_content`, `entity_types_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] merge_option
          #   @return [::Google::Cloud::Dialogflow::CX::V3::ImportEntityTypesRequest::MergeOption]
          #     Required. Merge option for importing entity types.
          # @!attribute [rw] target_entity_type
          #   @return [::String]
          #     Optional. The target entity type to import into.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entity_types/<EntityTypeID>`.
          #     If set, there should be only one entity type included in
          #     [entity_types][google.cloud.dialogflow.cx.v3.ImportEntityTypesRequest.entity_types],
          #     of which the type should match the type of the target entity type. All
          #     {::Google::Cloud::Dialogflow::CX::V3::EntityType#entities entities} in the
          #     imported entity type will be added to the target entity type.
          class ImportEntityTypesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Merge option when display name conflicts exist during import.
            module MergeOption
              # Unspecified. If used, system uses REPORT_CONFLICT as default.
              MERGE_OPTION_UNSPECIFIED = 0

              # Replace the original entity type in the agent with the new entity type
              # when display name conflicts exist.
              REPLACE = 1

              # Merge the original entity type with the new entity type when display name
              # conflicts exist.
              MERGE = 2

              # Create new entity types with new display names to differentiate them from
              # the existing entity types when display name conflicts exist.
              RENAME = 3

              # Report conflict information if display names conflict is detected.
              # Otherwise, import entity types.
              REPORT_CONFLICT = 4

              # Keep the original entity type and discard the conflicting new entity type
              # when display name conflicts exist.
              KEEP = 5
            end
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#import_entity_types EntityTypes.ImportEntityTypes}.
          # @!attribute [rw] entity_types
          #   @return [::Array<::String>]
          #     The unique identifier of the imported entity types.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entity_types/<EntityTypeID>`.
          # @!attribute [rw] conflicting_resources
          #   @return [::Google::Cloud::Dialogflow::CX::V3::ImportEntityTypesResponse::ConflictingResources]
          #     Info which resources have conflicts when
          #     [REPORT_CONFLICT][ImportEntityTypesResponse.REPORT_CONFLICT] merge_option
          #     is set in ImportEntityTypesRequest.
          class ImportEntityTypesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Conflicting resources detected during the import process. Only filled when
            # [REPORT_CONFLICT][ImportEntityTypesResponse.REPORT_CONFLICT] is set in the
            # request and there are conflicts in the display names.
            # @!attribute [rw] entity_type_display_names
            #   @return [::Array<::String>]
            #     Display names of conflicting entity types.
            # @!attribute [rw] entity_display_names
            #   @return [::Array<::String>]
            #     Display names of conflicting entities.
            class ConflictingResources
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Metadata returned for the
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#import_entity_types EntityTypes.ImportEntityTypes}
          # long running operation.
          class ImportEntityTypesMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#list_entity_types EntityTypes.ListEntityTypes}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to list all entity types for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to list entity types for. The following fields are language
          #     dependent:
          #
          #     *   `EntityType.entities.value`
          #     *   `EntityType.entities.synonyms`
          #     *   `EntityType.excluded_phrases.value`
          #
          #     If not specified, the agent's default language is used.
          #     [Many
          #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
          #     are supported.
          #     Note: languages must be enabled in the agent before they can be used.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return in a single page. By default 100 and
          #     at most 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous list request.
          class ListEntityTypesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#list_entity_types EntityTypes.ListEntityTypes}.
          # @!attribute [rw] entity_types
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::EntityType>]
          #     The list of entity types. There will be a maximum number of items returned
          #     based on the page_size field in the request.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no
          #     more results in the list.
          class ListEntityTypesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#get_entity_type EntityTypes.GetEntityType}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the entity type.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language to retrieve the entity type for. The following fields are
          #     language dependent:
          #
          #     *   `EntityType.entities.value`
          #     *   `EntityType.entities.synonyms`
          #     *   `EntityType.excluded_phrases.value`
          #
          #     If not specified, the agent's default language is used.
          #     [Many
          #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
          #     are supported.
          #     Note: languages must be enabled in the agent before they can be used.
          class GetEntityTypeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#create_entity_type EntityTypes.CreateEntityType}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent to create a entity type for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] entity_type
          #   @return [::Google::Cloud::Dialogflow::CX::V3::EntityType]
          #     Required. The entity type to create.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language of the following fields in `entity_type`:
          #
          #     *   `EntityType.entities.value`
          #     *   `EntityType.entities.synonyms`
          #     *   `EntityType.excluded_phrases.value`
          #
          #     If not specified, the agent's default language is used.
          #     [Many
          #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
          #     are supported.
          #     Note: languages must be enabled in the agent before they can be used.
          class CreateEntityTypeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#update_entity_type EntityTypes.UpdateEntityType}.
          # @!attribute [rw] entity_type
          #   @return [::Google::Cloud::Dialogflow::CX::V3::EntityType]
          #     Required. The entity type to update.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The language of the following fields in `entity_type`:
          #
          #     *   `EntityType.entities.value`
          #     *   `EntityType.entities.synonyms`
          #     *   `EntityType.excluded_phrases.value`
          #
          #     If not specified, the agent's default language is used.
          #     [Many
          #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
          #     are supported.
          #     Note: languages must be enabled in the agent before they can be used.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The mask to control which fields get updated.
          class UpdateEntityTypeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::EntityTypes::Client#delete_entity_type EntityTypes.DeleteEntityType}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the entity type to delete.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     This field has no effect for entity type not being used.
          #     For entity types that are used by intents or pages:
          #
          #     *  If `force` is set to false, an error will be returned with message
          #        indicating the referencing resources.
          #     *  If `force` is set to true, Dialogflow will remove the entity type, as
          #        well as any references to the entity type (i.e. Page
          #        {::Google::Cloud::Dialogflow::CX::V3::Form::Parameter parameter} of the entity
          #        type will be changed to
          #        '@sys.any' and intent
          #        {::Google::Cloud::Dialogflow::CX::V3::Intent::Parameter parameter} of the
          #        entity type will be removed).
          class DeleteEntityTypeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
