# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Changelogs::Client#list_changelogs Changelogs.ListChangelogs}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The agent containing the changelogs.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter string. Supports filter by user_email, resource, type and
          #     create_time. Some examples:
          #       1. By user email:
          #            user_email = "someone@google.com"
          #       2. By resource name:
          #            resource = "projects/123/locations/global/agents/456/flows/789"
          #       3. By resource display name:
          #            display_name = "my agent"
          #       4. By action:
          #            action = "Create"
          #       5. By type:
          #            type = "flows"
          #       6. By create time. Currently predicates on `create_time` and
          #          `create_time_epoch_seconds` are supported:
          #            create_time_epoch_seconds > 1551790877 AND create_time <=
          #            2017-01-15T01:30:15.01Z
          #       7. Combination of above filters:
          #            resource = "projects/123/locations/global/agents/456/flows/789"
          #              AND user_email = "someone@google.com"
          #              AND create_time <= 2017-01-15T01:30:15.01Z
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return in a single page. By default 100 and
          #     at most 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous list request.
          class ListChangelogsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Changelogs::Client#list_changelogs Changelogs.ListChangelogs}.
          # @!attribute [rw] changelogs
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::Changelog>]
          #     The list of changelogs. There will be a maximum number of items returned
          #     based on the page_size field in the request. The changelogs will be ordered
          #     by timestamp.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          class ListChangelogsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Changelogs::Client#get_changelog Changelogs.GetChangelog}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the changelog to get.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/changelogs/<ChangelogID>`.
          class GetChangelogRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Changelogs represents a change made to a given agent.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the changelog.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/changelogs/<ChangelogID>`.
          # @!attribute [rw] user_email
          #   @return [::String]
          #     Email address of the authenticated user.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The affected resource display name of the change.
          # @!attribute [rw] action
          #   @return [::String]
          #     The action of the change.
          # @!attribute [rw] type
          #   @return [::String]
          #     The affected resource type.
          # @!attribute [rw] resource
          #   @return [::String]
          #     The affected resource name of the change.
          # @!attribute [rw] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp of the change.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The affected language code of the change.
          class Changelog
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
