# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          # Settings related to speech recognition.
          # @!attribute [rw] enable_speech_adaptation
          #   @return [::Boolean]
          #     Whether to use speech adaptation for speech recognition.
          class SpeechToTextSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Agents are best described as Natural Language Understanding (NLU) modules
          # that transform user requests into actionable data. You can include agents
          # in your app, product, or service to determine user intent and respond to the
          # user in a natural way.
          #
          # After you create an agent, you can add
          # {::Google::Cloud::Dialogflow::CX::V3::Intent Intents}, [Entity
          # Types][google.cloud.dialogflow.cx.v3.EntityType],
          # {::Google::Cloud::Dialogflow::CX::V3::Flow Flows},
          # {::Google::Cloud::Dialogflow::CX::V3::Fulfillment Fulfillments},
          # {::Google::Cloud::Dialogflow::CX::V3::Webhook Webhooks},
          # {::Google::Cloud::Dialogflow::CX::V3::TransitionRouteGroup TransitionRouteGroups}
          # and so on to manage the conversation flows.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the agent.
          #     Required for the
          #     {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#update_agent Agents.UpdateAgent}
          #     method.
          #     {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#create_agent Agents.CreateAgent}
          #     populates the name automatically.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The human-readable name of the agent, unique within the location.
          # @!attribute [rw] default_language_code
          #   @return [::String]
          #     Required. Immutable. The default language of the agent as a language tag.
          #     See [Language
          #     Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
          #     for a list of the currently supported language codes.
          #     This field cannot be set by the
          #     {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#update_agent Agents.UpdateAgent}
          #     method.
          # @!attribute [rw] supported_language_codes
          #   @return [::Array<::String>]
          #     The list of all languages supported by the agent (except for the
          #     `default_language_code`).
          # @!attribute [rw] time_zone
          #   @return [::String]
          #     Required. The time zone of the agent from the [time zone
          #     database](https://www.iana.org/time-zones), e.g., America/New_York,
          #     Europe/Paris.
          # @!attribute [rw] description
          #   @return [::String]
          #     The description of the agent. The maximum length is 500 characters. If
          #     exceeded, the request is rejected.
          # @!attribute [rw] avatar_uri
          #   @return [::String]
          #     The URI of the agent's avatar. Avatars are used throughout the Dialogflow
          #     console and in the self-hosted [Web
          #     Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
          #     integration.
          # @!attribute [rw] speech_to_text_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::SpeechToTextSettings]
          #     Speech recognition related settings.
          # @!attribute [rw] start_flow
          #   @return [::String]
          #     Immutable. Name of the start flow in this agent. A start flow will be
          #     automatically created when the agent is created, and can only be deleted by
          #     deleting the agent. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
          # @!attribute [rw] security_settings
          #   @return [::String]
          #     Name of the
          #     {::Google::Cloud::Dialogflow::CX::V3::SecuritySettings SecuritySettings}
          #     reference for the agent. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/securitySettings/<SecuritySettingsID>`.
          # @!attribute [rw] enable_stackdriver_logging
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Indicates if stackdriver logging is enabled for the agent.
          #     Please use
          #     {::Google::Cloud::Dialogflow::CX::V3::AdvancedSettings::LoggingSettings agent.advanced_settings}
          #     instead.
          # @!attribute [rw] enable_spell_correction
          #   @return [::Boolean]
          #     Indicates if automatic spell correction is enabled in detect intent
          #     requests.
          # @!attribute [rw] enable_multi_language_training
          #   @return [::Boolean]
          #     Optional. Enable training multi-lingual models for this agent. These models
          #     will be trained on all the languages supported by the agent.
          # @!attribute [rw] locked
          #   @return [::Boolean]
          #     Indicates whether the agent is locked for changes. If the agent is locked,
          #     modifications to the agent will be rejected except for [RestoreAgent][].
          # @!attribute [rw] advanced_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::AdvancedSettings]
          #     Hierarchical advanced settings for this agent. The settings exposed at the
          #     lower level overrides the settings exposed at the higher level.
          # @!attribute [rw] git_integration_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::GitIntegrationSettings]
          #     Git integration settings for this agent.
          # @!attribute [rw] text_to_speech_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::TextToSpeechSettings]
          #     Settings on instructing the speech synthesizer on how to generate the
          #     output audio content.
          # @!attribute [rw] gen_app_builder_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::GenAppBuilderSettings]
          #     Gen App Builder-related agent-level settings.
          # @!attribute [rw] answer_feedback_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::AnswerFeedbackSettings]
          #     Optional. Answer feedback collection settings.
          # @!attribute [rw] personalization_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::PersonalizationSettings]
          #     Optional. Settings for end user personalization.
          # @!attribute [rw] client_certificate_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::ClientCertificateSettings]
          #     Optional. Settings for custom client certificates.
          # @!attribute [r] satisfies_pzs
          #   @return [::Boolean]
          #     Optional. Output only. A read only boolean field reflecting Zone Separation
          #     status of the agent.
          # @!attribute [r] satisfies_pzi
          #   @return [::Boolean]
          #     Optional. Output only. A read only boolean field reflecting Zone Isolation
          #     status of the agent.
          class Agent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Settings for connecting to Git repository for an agent.
            # @!attribute [rw] github_settings
            #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent::GitIntegrationSettings::GithubSettings]
            #     GitHub settings.
            class GitIntegrationSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Settings of integration with GitHub.
              # @!attribute [rw] display_name
              #   @return [::String]
              #     The unique repository display name for the GitHub repository.
              # @!attribute [rw] repository_uri
              #   @return [::String]
              #     The GitHub repository URI related to the agent.
              # @!attribute [rw] tracking_branch
              #   @return [::String]
              #     The branch of the GitHub repository tracked for this agent.
              # @!attribute [rw] access_token
              #   @return [::String]
              #     The access token used to authenticate the access to the GitHub
              #     repository.
              # @!attribute [rw] branches
              #   @return [::Array<::String>]
              #     A list of branches configured to be used from Dialogflow.
              class GithubSettings
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Settings for Gen App Builder.
            # @!attribute [rw] engine
            #   @return [::String]
            #     Required. The full name of the Gen App Builder engine related to this
            #     agent if there is one. Format: `projects/{Project ID}/locations/{Location
            #     ID}/collections/\\{Collection ID}/engines/\\{Engine ID}`
            class GenAppBuilderSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Settings for answer feedback collection.
            # @!attribute [rw] enable_answer_feedback
            #   @return [::Boolean]
            #     Optional. If enabled, end users will be able to provide
            #     {::Google::Cloud::Dialogflow::CX::V3::AnswerFeedback answer feedback} to
            #     Dialogflow responses. Feature works only if interaction logging is
            #     enabled in the Dialogflow agent.
            class AnswerFeedbackSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Settings for end user personalization.
            # @!attribute [rw] default_end_user_metadata
            #   @return [::Google::Protobuf::Struct]
            #     Optional. Default end user metadata, used when processing DetectIntent
            #     requests. Recommended to be filled as a template instead of hard-coded
            #     value, for example { "age": "$session.params.age" }. The data will be
            #     merged with the
            #     {::Google::Cloud::Dialogflow::CX::V3::QueryParameters#end_user_metadata QueryParameters.end_user_metadata}
            #     in
            #     {::Google::Cloud::Dialogflow::CX::V3::DetectIntentRequest#query_params DetectIntentRequest.query_params}
            #     during query processing.
            class PersonalizationSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Settings for custom client certificates.
            # @!attribute [rw] ssl_certificate
            #   @return [::String]
            #     Required. The ssl certificate encoded in PEM format. This string must
            #     include the begin header and end footer lines.
            # @!attribute [rw] private_key
            #   @return [::String]
            #     Required. The name of the SecretManager secret version resource storing
            #     the private key encoded in PEM format. Format:
            #     `projects/{project}/secrets/{secret}/versions/{version}`
            # @!attribute [rw] passphrase
            #   @return [::String]
            #     Optional. The name of the SecretManager secret version resource storing
            #     the passphrase. 'passphrase' should be left unset if the private key is
            #     not encrypted.
            #     Format: `projects/{project}/secrets/{secret}/versions/{version}`
            class ClientCertificateSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#list_agents Agents.ListAgents}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The location to list all agents for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return in a single page. By default 100 and
          #     at most 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous list request.
          class ListAgentsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#list_agents Agents.ListAgents}.
          # @!attribute [rw] agents
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::Agent>]
          #     The list of agents. There will be a maximum number of items returned based
          #     on the page_size field in the request.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          class ListAgentsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#get_agent Agents.GetAgent}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the agent.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          class GetAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#create_agent Agents.CreateAgent}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The location to create a agent for.
          #     Format: `projects/<ProjectID>/locations/<LocationID>`.
          # @!attribute [rw] agent
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent]
          #     Required. The agent to create.
          class CreateAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#update_agent Agents.UpdateAgent}.
          # @!attribute [rw] agent
          #   @return [::Google::Cloud::Dialogflow::CX::V3::Agent]
          #     Required. The agent to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The mask to control which fields get updated. If the mask is not present,
          #     all fields will be updated.
          class UpdateAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#delete_agent Agents.DeleteAgent}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the agent to delete.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          class DeleteAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#export_agent Agents.ExportAgent}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the agent to export.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] agent_uri
          #   @return [::String]
          #     Optional. The [Google Cloud
          #     Storage](https://cloud.google.com/storage/docs/) URI to export the agent
          #     to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
          #     left unspecified, the serialized agent is returned inline.
          #
          #     Dialogflow performs a write operation for the Cloud Storage object
          #     on the caller's behalf, so your request authentication must
          #     have write permissions for the object. For more information, see
          #     [Dialogflow access
          #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
          # @!attribute [rw] data_format
          #   @return [::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest::DataFormat]
          #     Optional. The data format of the exported agent. If not specified, `BLOB`
          #     is assumed.
          # @!attribute [rw] environment
          #   @return [::String]
          #     Optional. Environment name. If not set, draft environment is assumed.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>`.
          # @!attribute [rw] git_destination
          #   @return [::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest::GitDestination]
          #     Optional. The Git branch to export the agent to.
          # @!attribute [rw] include_bigquery_export_settings
          #   @return [::Boolean]
          #     Optional. Whether to include BigQuery Export setting.
          class ExportAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Settings for exporting to a git branch.
            # @!attribute [rw] tracking_branch
            #   @return [::String]
            #     Tracking branch for the git push.
            # @!attribute [rw] commit_message
            #   @return [::String]
            #     Commit message for the git push.
            class GitDestination
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Data format of the exported agent.
            module DataFormat
              # Unspecified format.
              DATA_FORMAT_UNSPECIFIED = 0

              # Agent content will be exported as raw bytes.
              BLOB = 1

              # Agent content will be exported in JSON Package format.
              JSON_PACKAGE = 4
            end
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#export_agent Agents.ExportAgent}.
          # @!attribute [rw] agent_uri
          #   @return [::String]
          #     The URI to a file containing the exported agent. This field is populated
          #     if `agent_uri` is specified in
          #     {::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest ExportAgentRequest}.
          #
          #     Note: The following fields are mutually exclusive: `agent_uri`, `agent_content`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_content
          #   @return [::String]
          #     Uncompressed raw byte content for agent. This field is populated
          #     if none of `agent_uri` and `git_destination` are specified in
          #     {::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest ExportAgentRequest}.
          #
          #     Note: The following fields are mutually exclusive: `agent_content`, `agent_uri`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] commit_sha
          #   @return [::String]
          #     Commit SHA of the git push. This field is populated if
          #     `git_destination` is specified in
          #     {::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest ExportAgentRequest}.
          #
          #     Note: The following fields are mutually exclusive: `commit_sha`, `agent_uri`, `agent_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ExportAgentResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#restore_agent Agents.RestoreAgent}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the agent to restore into.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] agent_uri
          #   @return [::String]
          #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
          #     to restore agent from. The format of this URI must be
          #     `gs://<bucket-name>/<object-name>`.
          #
          #     Dialogflow performs a read operation for the Cloud Storage object
          #     on the caller's behalf, so your request authentication must
          #     have read permissions for the object. For more information, see
          #     [Dialogflow access
          #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
          #
          #     Note: The following fields are mutually exclusive: `agent_uri`, `agent_content`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] agent_content
          #   @return [::String]
          #     Uncompressed raw byte content for agent.
          #
          #     Note: The following fields are mutually exclusive: `agent_content`, `agent_uri`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] git_source
          #   @return [::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest::GitSource]
          #     Setting for restoring from a git branch
          #
          #     Note: The following fields are mutually exclusive: `git_source`, `agent_uri`, `agent_content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] restore_option
          #   @return [::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest::RestoreOption]
          #     Agent restore mode. If not specified, `KEEP` is assumed.
          class RestoreAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Settings for restoring from a git branch
            # @!attribute [rw] tracking_branch
            #   @return [::String]
            #     tracking branch for the git pull
            class GitSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Restore option.
            module RestoreOption
              # Unspecified. Treated as KEEP.
              RESTORE_OPTION_UNSPECIFIED = 0

              # Always respect the settings from the exported agent file. It may cause
              # a restoration failure if some settings (e.g. model type) are not
              # supported in the target agent.
              KEEP = 1

              # Fallback to default settings if some settings are not supported in the
              # target agent.
              FALLBACK = 2
            end
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#validate_agent Agents.ValidateAgent}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The agent to validate.
          #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     If not specified, the agent's default language is used.
          class ValidateAgentRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#get_agent_validation_result Agents.GetAgentValidationResult}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The agent name.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/validationResult`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     If not specified, the agent's default language is used.
          class GetAgentValidationResultRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response message for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#get_agent_validation_result Agents.GetAgentValidationResult}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique identifier of the agent validation result.
          #     Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/validationResult`.
          # @!attribute [rw] flow_validation_results
          #   @return [::Array<::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult>]
          #     Contains all flow validation results.
          class AgentValidationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#get_generative_settings GetGenerativeSettings}
          # RPC.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Format:
          #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Required. Language code of the generative settings.
          class GetGenerativeSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request for
          # {::Google::Cloud::Dialogflow::CX::V3::Agents::Client#update_generative_settings UpdateGenerativeSettings}
          # RPC.
          # @!attribute [rw] generative_settings
          #   @return [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings]
          #     Required. Generative settings to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The mask to control which fields get updated. If the mask is not
          #     present, all fields will be updated.
          class UpdateGenerativeSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
