# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/cx/v3/webhook_pb"
require "google/cloud/dialogflow/cx/v3/webhooks/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          module Webhooks
            module Rest
              ##
              # REST client for the Webhooks service.
              #
              # Service for managing {::Google::Cloud::Dialogflow::CX::V3::Webhook Webhooks}.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :webhooks_stub

                ##
                # Configure the Webhooks Client class.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all Webhooks clients
                #   ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Dialogflow", "CX", "V3"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0
                    default_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the Webhooks Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @webhooks_stub.universe_domain
                end

                ##
                # Create a new Webhooks REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Webhooks client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @webhooks_stub = ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @webhooks_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @webhooks_stub.endpoint
                    config.universe_domain = @webhooks_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @webhooks_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @webhooks_stub.logger
                end

                # Service calls

                ##
                # Returns the list of all webhooks in the specified agent.
                #
                # @overload list_webhooks(request, options = nil)
                #   Pass arguments to `list_webhooks` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ListWebhooksRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ListWebhooksRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_webhooks(parent: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_webhooks` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The agent to list all webhooks for.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param page_size [::Integer]
                #     The maximum number of items to return in a single page. By default 100 and
                #     at most 1000.
                #   @param page_token [::String]
                #     The next_page_token value returned from a previous list request.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Webhook>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Webhook>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ListWebhooksRequest.new
                #
                #   # Call the list_webhooks method.
                #   result = client.list_webhooks request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Dialogflow::CX::V3::Webhook.
                #     p item
                #   end
                #
                def list_webhooks request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ListWebhooksRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_webhooks.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_webhooks.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_webhooks.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @webhooks_stub.list_webhooks request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @webhooks_stub, :list_webhooks, "webhooks", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieves the specified webhook.
                #
                # @overload get_webhook(request, options = nil)
                #   Pass arguments to `get_webhook` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetWebhookRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetWebhookRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_webhook(name: nil)
                #   Pass arguments to `get_webhook` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the webhook.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetWebhookRequest.new
                #
                #   # Call the get_webhook method.
                #   result = client.get_webhook request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Webhook.
                #   p result
                #
                def get_webhook request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetWebhookRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_webhook.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_webhook.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_webhook.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @webhooks_stub.get_webhook request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates a webhook in the specified agent.
                #
                # @overload create_webhook(request, options = nil)
                #   Pass arguments to `create_webhook` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::CreateWebhookRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::CreateWebhookRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_webhook(parent: nil, webhook: nil)
                #   Pass arguments to `create_webhook` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The agent to create a webhook for.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param webhook [::Google::Cloud::Dialogflow::CX::V3::Webhook, ::Hash]
                #     Required. The webhook to create.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::CreateWebhookRequest.new
                #
                #   # Call the create_webhook method.
                #   result = client.create_webhook request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Webhook.
                #   p result
                #
                def create_webhook request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::CreateWebhookRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_webhook.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_webhook.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_webhook.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @webhooks_stub.create_webhook request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the specified webhook.
                #
                # @overload update_webhook(request, options = nil)
                #   Pass arguments to `update_webhook` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::UpdateWebhookRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::UpdateWebhookRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_webhook(webhook: nil, update_mask: nil)
                #   Pass arguments to `update_webhook` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param webhook [::Google::Cloud::Dialogflow::CX::V3::Webhook, ::Hash]
                #     Required. The webhook to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The mask to control which fields get updated. If the mask is not present,
                #     all fields will be updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Webhook]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::UpdateWebhookRequest.new
                #
                #   # Call the update_webhook method.
                #   result = client.update_webhook request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Webhook.
                #   p result
                #
                def update_webhook request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::UpdateWebhookRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_webhook.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_webhook.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_webhook.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @webhooks_stub.update_webhook request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes the specified webhook.
                #
                # @overload delete_webhook(request, options = nil)
                #   Pass arguments to `delete_webhook` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::DeleteWebhookRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::DeleteWebhookRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_webhook(name: nil, force: nil)
                #   Pass arguments to `delete_webhook` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the webhook to delete.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
                #   @param force [::Boolean]
                #     This field has no effect for webhook not being used.
                #     For webhooks that are used by pages/flows/transition route groups:
                #
                #     *  If `force` is set to false, an error will be returned with message
                #        indicating the referenced resources.
                #     *  If `force` is set to true, Dialogflow will remove the webhook, as well
                #        as any references to the webhook (i.e.
                #        {::Google::Cloud::Dialogflow::CX::V3::Fulfillment#webhook Webhook} and
                #        {::Google::Cloud::Dialogflow::CX::V3::Fulfillment#tag tag}in fulfillments that
                #        point to this webhook will be removed).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::DeleteWebhookRequest.new
                #
                #   # Call the delete_webhook method.
                #   result = client.delete_webhook request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_webhook request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::DeleteWebhookRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_webhook.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_webhook.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_webhook.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @webhooks_stub.delete_webhook request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the Webhooks REST API.
                #
                # This class represents the configuration for Webhooks REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # list_webhooks to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_webhooks.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Webhooks::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_webhooks.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the Webhooks API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `list_webhooks`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_webhooks
                    ##
                    # RPC-specific configuration for `get_webhook`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_webhook
                    ##
                    # RPC-specific configuration for `create_webhook`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_webhook
                    ##
                    # RPC-specific configuration for `update_webhook`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_webhook
                    ##
                    # RPC-specific configuration for `delete_webhook`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_webhook

                    # @private
                    def initialize parent_rpcs = nil
                      list_webhooks_config = parent_rpcs.list_webhooks if parent_rpcs.respond_to? :list_webhooks
                      @list_webhooks = ::Gapic::Config::Method.new list_webhooks_config
                      get_webhook_config = parent_rpcs.get_webhook if parent_rpcs.respond_to? :get_webhook
                      @get_webhook = ::Gapic::Config::Method.new get_webhook_config
                      create_webhook_config = parent_rpcs.create_webhook if parent_rpcs.respond_to? :create_webhook
                      @create_webhook = ::Gapic::Config::Method.new create_webhook_config
                      update_webhook_config = parent_rpcs.update_webhook if parent_rpcs.respond_to? :update_webhook
                      @update_webhook = ::Gapic::Config::Method.new update_webhook_config
                      delete_webhook_config = parent_rpcs.delete_webhook if parent_rpcs.respond_to? :delete_webhook
                      @delete_webhook = ::Gapic::Config::Method.new delete_webhook_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
