# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/dialogflow/cx/v3/version"

require "google/cloud/dialogflow/cx/v3/test_cases/credentials"
require "google/cloud/dialogflow/cx/v3/test_cases/paths"
require "google/cloud/dialogflow/cx/v3/test_cases/operations"
require "google/cloud/dialogflow/cx/v3/test_cases/client"
require "google/cloud/dialogflow/cx/v3/test_cases/rest"

module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          ##
          # Service for managing {::Google::Cloud::Dialogflow::CX::V3::TestCase Test Cases} and
          # {::Google::Cloud::Dialogflow::CX::V3::TestCaseResult Test Case Results}.
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/cloud/dialogflow/cx/v3/test_cases"
          #     client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Client.new
          #
          # @example Load this service and instantiate a REST client
          #
          #     require "google/cloud/dialogflow/cx/v3/test_cases/rest"
          #     client = ::Google::Cloud::Dialogflow::CX::V3::TestCases::Rest::Client.new
          #
          module TestCases
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "test_cases", "helpers.rb"
require "google/cloud/dialogflow/cx/v3/test_cases/helpers" if ::File.file? helper_path
