# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          module Sessions
            # Path helper methods for the Sessions API.
            module Paths
              ##
              # Create a fully-qualified DataStore resource string.
              #
              # @overload data_store_path(project:, location:, data_store:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/dataStores/{data_store}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param data_store [String]
              #
              # @overload data_store_path(project:, location:, collection:, data_store:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param collection [String]
              #   @param data_store [String]
              #
              # @return [::String]
              def data_store_path **args
                resources = {
                  "data_store:location:project" => (proc do |project:, location:, data_store:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/dataStores/#{data_store}"
                  end),
                  "collection:data_store:location:project" => (proc do |project:, location:, collection:, data_store:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "collection cannot contain /" if collection.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/collections/#{collection}/dataStores/#{data_store}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified EntityType resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/agents/{agent}/entityTypes/{entity_type}`
              #
              # @param project [String]
              # @param location [String]
              # @param agent [String]
              # @param entity_type [String]
              #
              # @return [::String]
              def entity_type_path project:, location:, agent:, entity_type:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"

                "projects/#{project}/locations/#{location}/agents/#{agent}/entityTypes/#{entity_type}"
              end

              ##
              # Create a fully-qualified Intent resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/agents/{agent}/intents/{intent}`
              #
              # @param project [String]
              # @param location [String]
              # @param agent [String]
              # @param intent [String]
              #
              # @return [::String]
              def intent_path project:, location:, agent:, intent:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"

                "projects/#{project}/locations/#{location}/agents/#{agent}/intents/#{intent}"
              end

              ##
              # Create a fully-qualified Page resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/pages/{page}`
              #
              # @param project [String]
              # @param location [String]
              # @param agent [String]
              # @param flow [String]
              # @param page [String]
              #
              # @return [::String]
              def page_path project:, location:, agent:, flow:, page:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"
                raise ::ArgumentError, "flow cannot contain /" if flow.to_s.include? "/"

                "projects/#{project}/locations/#{location}/agents/#{agent}/flows/#{flow}/pages/#{page}"
              end

              ##
              # Create a fully-qualified Session resource string.
              #
              # @overload session_path(project:, location:, agent:, session:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/agents/{agent}/sessions/{session}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param agent [String]
              #   @param session [String]
              #
              # @overload session_path(project:, location:, agent:, environment:, session:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param agent [String]
              #   @param environment [String]
              #   @param session [String]
              #
              # @return [::String]
              def session_path **args
                resources = {
                  "agent:location:project:session" => (proc do |project:, location:, agent:, session:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/agents/#{agent}/sessions/#{session}"
                  end),
                  "agent:environment:location:project:session" => (proc do |project:, location:, agent:, environment:, session:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"
                    raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/agents/#{agent}/environments/#{environment}/sessions/#{session}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified SessionEntityType resource string.
              #
              # @overload session_entity_type_path(project:, location:, agent:, session:, entity_type:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param agent [String]
              #   @param session [String]
              #   @param entity_type [String]
              #
              # @overload session_entity_type_path(project:, location:, agent:, environment:, session:, entity_type:)
              #   The resource will be in the following format:
              #
              #   `projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}/entityTypes/{entity_type}`
              #
              #   @param project [String]
              #   @param location [String]
              #   @param agent [String]
              #   @param environment [String]
              #   @param session [String]
              #   @param entity_type [String]
              #
              # @return [::String]
              def session_entity_type_path **args
                resources = {
                  "agent:entity_type:location:project:session" => (proc do |project:, location:, agent:, session:, entity_type:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"
                    raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/agents/#{agent}/sessions/#{session}/entityTypes/#{entity_type}"
                  end),
                  "agent:entity_type:environment:location:project:session" => (proc do |project:, location:, agent:, environment:, session:, entity_type:|
                    raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                    raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                    raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"
                    raise ::ArgumentError, "environment cannot contain /" if environment.to_s.include? "/"
                    raise ::ArgumentError, "session cannot contain /" if session.to_s.include? "/"

                    "projects/#{project}/locations/#{location}/agents/#{agent}/environments/#{environment}/sessions/#{session}/entityTypes/#{entity_type}"
                  end)
                }

                resource = resources[args.keys.sort.join(":")]
                raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
                resource.call(**args)
              end

              ##
              # Create a fully-qualified Version resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}`
              #
              # @param project [String]
              # @param location [String]
              # @param agent [String]
              # @param flow [String]
              # @param version [String]
              #
              # @return [::String]
              def version_path project:, location:, agent:, flow:, version:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "agent cannot contain /" if agent.to_s.include? "/"
                raise ::ArgumentError, "flow cannot contain /" if flow.to_s.include? "/"

                "projects/#{project}/locations/#{location}/agents/#{agent}/flows/#{flow}/versions/#{version}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
