# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/cx/v3/flow_pb"
require "google/cloud/dialogflow/cx/v3/flows/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          module Flows
            module Rest
              ##
              # REST client for the Flows service.
              #
              # Service for managing {::Google::Cloud::Dialogflow::CX::V3::Flow Flows}.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :flows_stub

                ##
                # Configure the Flows Client class.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all Flows clients
                #   ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Dialogflow", "CX", "V3"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0
                    default_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the Flows Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @flows_stub.universe_domain
                end

                ##
                # Create a new Flows REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Flows client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @flows_stub = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @flows_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @flows_stub.endpoint
                    config.universe_domain = @flows_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @flows_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @flows_stub.logger
                end

                # Service calls

                ##
                # Creates a flow in the specified agent.
                #
                # Note: You should always train a flow prior to sending it queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload create_flow(request, options = nil)
                #   Pass arguments to `create_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_flow(parent: nil, flow: nil, language_code: nil)
                #   Pass arguments to `create_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The agent to create a flow for.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param flow [::Google::Cloud::Dialogflow::CX::V3::Flow, ::Hash]
                #     Required. The flow to create.
                #   @param language_code [::String]
                #     The language of the following fields in `flow`:
                #
                #     *  `Flow.event_handlers.trigger_fulfillment.messages`
                #     *  `Flow.event_handlers.trigger_fulfillment.conditional_cases`
                #     *  `Flow.transition_routes.trigger_fulfillment.messages`
                #     *  `Flow.transition_routes.trigger_fulfillment.conditional_cases`
                #
                #     If not specified, the agent's default language is used.
                #     [Many
                #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
                #     are supported.
                #     Note: languages must be enabled in the agent before they can be used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Flow]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Flow]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest.new
                #
                #   # Call the create_flow method.
                #   result = client.create_flow request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Flow.
                #   p result
                #
                def create_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::CreateFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.create_flow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a specified flow.
                #
                # @overload delete_flow(request, options = nil)
                #   Pass arguments to `delete_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_flow(name: nil, force: nil)
                #   Pass arguments to `delete_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the flow to delete.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
                #   @param force [::Boolean]
                #     This field has no effect for flows with no incoming transitions.
                #     For flows with incoming transitions:
                #
                #     *  If `force` is set to false, an error will be returned with message
                #        indicating the incoming transitions.
                #     *  If `force` is set to true, Dialogflow will remove the flow, as well as
                #        any transitions to the flow (i.e. [Target
                #        flow][EventHandler.target_flow] in event handlers or [Target
                #        flow][TransitionRoute.target_flow] in transition routes that point to
                #        this flow will be cleared).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest.new
                #
                #   # Call the delete_flow method.
                #   result = client.delete_flow request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::DeleteFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.delete_flow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the list of all flows in the specified agent.
                #
                # @overload list_flows(request, options = nil)
                #   Pass arguments to `list_flows` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_flows(parent: nil, page_size: nil, page_token: nil, language_code: nil)
                #   Pass arguments to `list_flows` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The agent containing the flows.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param page_size [::Integer]
                #     The maximum number of items to return in a single page. By default 100 and
                #     at most 1000.
                #   @param page_token [::String]
                #     The next_page_token value returned from a previous list request.
                #   @param language_code [::String]
                #     The language to list flows for. The following fields are language
                #     dependent:
                #
                #     *  `Flow.event_handlers.trigger_fulfillment.messages`
                #     *  `Flow.event_handlers.trigger_fulfillment.conditional_cases`
                #     *  `Flow.transition_routes.trigger_fulfillment.messages`
                #     *  `Flow.transition_routes.trigger_fulfillment.conditional_cases`
                #
                #     If not specified, the agent's default language is used.
                #     [Many
                #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
                #     are supported.
                #     Note: languages must be enabled in the agent before they can be used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Flow>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Flow>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest.new
                #
                #   # Call the list_flows method.
                #   result = client.list_flows request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Dialogflow::CX::V3::Flow.
                #     p item
                #   end
                #
                def list_flows request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ListFlowsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_flows.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_flows.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_flows.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.list_flows request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @flows_stub, :list_flows, "flows", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieves the specified flow.
                #
                # @overload get_flow(request, options = nil)
                #   Pass arguments to `get_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_flow(name: nil, language_code: nil)
                #   Pass arguments to `get_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the flow to get.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
                #   @param language_code [::String]
                #     The language to retrieve the flow for. The following fields are language
                #     dependent:
                #
                #     *  `Flow.event_handlers.trigger_fulfillment.messages`
                #     *  `Flow.event_handlers.trigger_fulfillment.conditional_cases`
                #     *  `Flow.transition_routes.trigger_fulfillment.messages`
                #     *  `Flow.transition_routes.trigger_fulfillment.conditional_cases`
                #
                #     If not specified, the agent's default language is used.
                #     [Many
                #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
                #     are supported.
                #     Note: languages must be enabled in the agent before they can be used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Flow]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Flow]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetFlowRequest.new
                #
                #   # Call the get_flow method.
                #   result = client.get_flow request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Flow.
                #   p result
                #
                def get_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.get_flow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the specified flow.
                #
                # Note: You should always train a flow prior to sending it queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload update_flow(request, options = nil)
                #   Pass arguments to `update_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_flow(flow: nil, update_mask: nil, language_code: nil)
                #   Pass arguments to `update_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param flow [::Google::Cloud::Dialogflow::CX::V3::Flow, ::Hash]
                #     Required. The flow to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The mask to control which fields get updated. If the mask is not present,
                #     all fields will be updated.
                #   @param language_code [::String]
                #     The language of the following fields in `flow`:
                #
                #     *  `Flow.event_handlers.trigger_fulfillment.messages`
                #     *  `Flow.event_handlers.trigger_fulfillment.conditional_cases`
                #     *  `Flow.transition_routes.trigger_fulfillment.messages`
                #     *  `Flow.transition_routes.trigger_fulfillment.conditional_cases`
                #
                #     If not specified, the agent's default language is used.
                #     [Many
                #     languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
                #     are supported.
                #     Note: languages must be enabled in the agent before they can be used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Flow]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Flow]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest.new
                #
                #   # Call the update_flow method.
                #   result = client.update_flow request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Flow.
                #   p result
                #
                def update_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::UpdateFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.update_flow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Trains the specified flow. Note that only the flow in 'draft' environment
                # is trained.
                #
                # This method is a [long-running
                # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
                # The returned `Operation` type has the following method-specific fields:
                #
                # - `metadata`: An empty [Struct
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
                # - `response`: An [Empty
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
                #
                # Note: You should always train a flow prior to sending it queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload train_flow(request, options = nil)
                #   Pass arguments to `train_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload train_flow(name: nil)
                #   Pass arguments to `train_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The flow to train.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest.new
                #
                #   # Call the train_flow method.
                #   result = client.train_flow request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def train_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::TrainFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.train_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.train_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.train_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.train_flow request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Validates the specified flow and creates or updates validation results.
                # Please call this API after the training is completed to get the complete
                # validation results.
                #
                # @overload validate_flow(request, options = nil)
                #   Pass arguments to `validate_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload validate_flow(name: nil, language_code: nil)
                #   Pass arguments to `validate_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The flow to validate.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
                #   @param language_code [::String]
                #     If not specified, the agent's default language is used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest.new
                #
                #   # Call the validate_flow method.
                #   result = client.validate_flow request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::FlowValidationResult.
                #   p result
                #
                def validate_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ValidateFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.validate_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.validate_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.validate_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.validate_flow request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets the latest flow validation result. Flow validation is performed
                # when ValidateFlow is called.
                #
                # @overload get_flow_validation_result(request, options = nil)
                #   Pass arguments to `get_flow_validation_result` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_flow_validation_result(name: nil, language_code: nil)
                #   Pass arguments to `get_flow_validation_result` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The flow name.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/validationResult`.
                #   @param language_code [::String]
                #     If not specified, the agent's default language is used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::FlowValidationResult]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest.new
                #
                #   # Call the get_flow_validation_result method.
                #   result = client.get_flow_validation_result request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::FlowValidationResult.
                #   p result
                #
                def get_flow_validation_result request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetFlowValidationResultRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_flow_validation_result.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_flow_validation_result.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_flow_validation_result.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.get_flow_validation_result request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Imports the specified flow to the specified agent from a binary file.
                #
                # This method is a [long-running
                # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
                # The returned `Operation` type has the following method-specific fields:
                #
                # - `metadata`: An empty [Struct
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
                # - `response`:
                # {::Google::Cloud::Dialogflow::CX::V3::ImportFlowResponse ImportFlowResponse}
                #
                # Note: You should always train a flow prior to sending it queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload import_flow(request, options = nil)
                #   Pass arguments to `import_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload import_flow(parent: nil, flow_uri: nil, flow_content: nil, import_option: nil, flow_import_strategy: nil)
                #   Pass arguments to `import_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The agent to import the flow into.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param flow_uri [::String]
                #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
                #     to import flow from. The format of this URI must be
                #     `gs://<bucket-name>/<object-name>`.
                #
                #     Dialogflow performs a read operation for the Cloud Storage object
                #     on the caller's behalf, so your request authentication must
                #     have read permissions for the object. For more information, see
                #     [Dialogflow access
                #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
                #
                #     Note: The following parameters are mutually exclusive: `flow_uri`, `flow_content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param flow_content [::String]
                #     Uncompressed raw byte content for flow.
                #
                #     Note: The following parameters are mutually exclusive: `flow_content`, `flow_uri`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param import_option [::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest::ImportOption]
                #     Flow import mode. If not specified, `KEEP` is assumed.
                #   @param flow_import_strategy [::Google::Cloud::Dialogflow::CX::V3::FlowImportStrategy, ::Hash]
                #     Optional. Specifies the import strategy used when resolving resource
                #     conflicts.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest.new
                #
                #   # Call the import_flow method.
                #   result = client.import_flow request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def import_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ImportFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.import_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.import_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.import_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.import_flow request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Exports the specified flow to a binary file.
                #
                # This method is a [long-running
                # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
                # The returned `Operation` type has the following method-specific fields:
                #
                # - `metadata`: An empty [Struct
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
                # - `response`:
                # {::Google::Cloud::Dialogflow::CX::V3::ExportFlowResponse ExportFlowResponse}
                #
                # Note that resources (e.g. intents, entities, webhooks) that the flow
                # references will also be exported.
                #
                # @overload export_flow(request, options = nil)
                #   Pass arguments to `export_flow` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload export_flow(name: nil, flow_uri: nil, include_referenced_flows: nil)
                #   Pass arguments to `export_flow` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the flow to export.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
                #   @param flow_uri [::String]
                #     Optional. The [Google Cloud
                #     Storage](https://cloud.google.com/storage/docs/) URI to export the flow to.
                #     The format of this URI must be `gs://<bucket-name>/<object-name>`. If left
                #     unspecified, the serialized flow is returned inline.
                #
                #     Dialogflow performs a write operation for the Cloud Storage object
                #     on the caller's behalf, so your request authentication must
                #     have write permissions for the object. For more information, see
                #     [Dialogflow access
                #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
                #   @param include_referenced_flows [::Boolean]
                #     Optional. Whether to export flows referenced by the specified flow.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest.new
                #
                #   # Call the export_flow method.
                #   result = client.export_flow request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def export_flow request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ExportFlowRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.export_flow.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.export_flow.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.export_flow.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @flows_stub.export_flow request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the Flows REST API.
                #
                # This class represents the configuration for Flows REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_flow to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_flow.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Flows::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_flow.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the Flows API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_flow
                    ##
                    # RPC-specific configuration for `delete_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_flow
                    ##
                    # RPC-specific configuration for `list_flows`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_flows
                    ##
                    # RPC-specific configuration for `get_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_flow
                    ##
                    # RPC-specific configuration for `update_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_flow
                    ##
                    # RPC-specific configuration for `train_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :train_flow
                    ##
                    # RPC-specific configuration for `validate_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :validate_flow
                    ##
                    # RPC-specific configuration for `get_flow_validation_result`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_flow_validation_result
                    ##
                    # RPC-specific configuration for `import_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :import_flow
                    ##
                    # RPC-specific configuration for `export_flow`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :export_flow

                    # @private
                    def initialize parent_rpcs = nil
                      create_flow_config = parent_rpcs.create_flow if parent_rpcs.respond_to? :create_flow
                      @create_flow = ::Gapic::Config::Method.new create_flow_config
                      delete_flow_config = parent_rpcs.delete_flow if parent_rpcs.respond_to? :delete_flow
                      @delete_flow = ::Gapic::Config::Method.new delete_flow_config
                      list_flows_config = parent_rpcs.list_flows if parent_rpcs.respond_to? :list_flows
                      @list_flows = ::Gapic::Config::Method.new list_flows_config
                      get_flow_config = parent_rpcs.get_flow if parent_rpcs.respond_to? :get_flow
                      @get_flow = ::Gapic::Config::Method.new get_flow_config
                      update_flow_config = parent_rpcs.update_flow if parent_rpcs.respond_to? :update_flow
                      @update_flow = ::Gapic::Config::Method.new update_flow_config
                      train_flow_config = parent_rpcs.train_flow if parent_rpcs.respond_to? :train_flow
                      @train_flow = ::Gapic::Config::Method.new train_flow_config
                      validate_flow_config = parent_rpcs.validate_flow if parent_rpcs.respond_to? :validate_flow
                      @validate_flow = ::Gapic::Config::Method.new validate_flow_config
                      get_flow_validation_result_config = parent_rpcs.get_flow_validation_result if parent_rpcs.respond_to? :get_flow_validation_result
                      @get_flow_validation_result = ::Gapic::Config::Method.new get_flow_validation_result_config
                      import_flow_config = parent_rpcs.import_flow if parent_rpcs.respond_to? :import_flow
                      @import_flow = ::Gapic::Config::Method.new import_flow_config
                      export_flow_config = parent_rpcs.export_flow if parent_rpcs.respond_to? :export_flow
                      @export_flow = ::Gapic::Config::Method.new export_flow_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
