# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dialogflow/cx/v3/agent_pb"
require "google/cloud/dialogflow/cx/v3/agents/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dialogflow
      module CX
        module V3
          module Agents
            module Rest
              ##
              # REST client for the Agents service.
              #
              # Service for managing {::Google::Cloud::Dialogflow::CX::V3::Agent Agents}.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "dialogflow.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :agents_stub

                ##
                # Configure the Agents Client class.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all Agents clients
                #   ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Dialogflow", "CX", "V3"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0
                    default_config.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_agent.timeout = 180.0
                    default_config.rpcs.create_agent.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the Agents Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @agents_stub.universe_domain
                end

                ##
                # Create a new Agents REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Agents client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @agents_stub = ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @agents_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @agents_stub.endpoint
                    config.universe_domain = @agents_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @agents_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @agents_stub.logger
                end

                # Service calls

                ##
                # Returns the list of all agents in the specified location.
                #
                # @overload list_agents(request, options = nil)
                #   Pass arguments to `list_agents` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ListAgentsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ListAgentsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_agents(parent: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_agents` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The location to list all agents for.
                #     Format: `projects/<ProjectID>/locations/<LocationID>`.
                #   @param page_size [::Integer]
                #     The maximum number of items to return in a single page. By default 100 and
                #     at most 1000.
                #   @param page_token [::String]
                #     The next_page_token value returned from a previous list request.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Agent>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dialogflow::CX::V3::Agent>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ListAgentsRequest.new
                #
                #   # Call the list_agents method.
                #   result = client.list_agents request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Dialogflow::CX::V3::Agent.
                #     p item
                #   end
                #
                def list_agents request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ListAgentsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_agents.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_agents.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_agents.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.list_agents request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @agents_stub, :list_agents, "agents", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieves the specified agent.
                #
                # @overload get_agent(request, options = nil)
                #   Pass arguments to `get_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_agent(name: nil)
                #   Pass arguments to `get_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the agent.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Agent]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Agent]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetAgentRequest.new
                #
                #   # Call the get_agent method.
                #   result = client.get_agent request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Agent.
                #   p result
                #
                def get_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.get_agent request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates an agent in the specified location.
                #
                # Note: You should always train flows prior to sending them queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload create_agent(request, options = nil)
                #   Pass arguments to `create_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::CreateAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::CreateAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_agent(parent: nil, agent: nil)
                #   Pass arguments to `create_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The location to create a agent for.
                #     Format: `projects/<ProjectID>/locations/<LocationID>`.
                #   @param agent [::Google::Cloud::Dialogflow::CX::V3::Agent, ::Hash]
                #     Required. The agent to create.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Agent]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Agent]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::CreateAgentRequest.new
                #
                #   # Call the create_agent method.
                #   result = client.create_agent request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Agent.
                #   p result
                #
                def create_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::CreateAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.create_agent request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the specified agent.
                #
                # Note: You should always train flows prior to sending them queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload update_agent(request, options = nil)
                #   Pass arguments to `update_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::UpdateAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::UpdateAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_agent(agent: nil, update_mask: nil)
                #   Pass arguments to `update_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param agent [::Google::Cloud::Dialogflow::CX::V3::Agent, ::Hash]
                #     Required. The agent to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     The mask to control which fields get updated. If the mask is not present,
                #     all fields will be updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::Agent]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::Agent]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::UpdateAgentRequest.new
                #
                #   # Call the update_agent method.
                #   result = client.update_agent request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::Agent.
                #   p result
                #
                def update_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::UpdateAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.update_agent request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes the specified agent.
                #
                # @overload delete_agent(request, options = nil)
                #   Pass arguments to `delete_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::DeleteAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::DeleteAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_agent(name: nil)
                #   Pass arguments to `delete_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the agent to delete.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::DeleteAgentRequest.new
                #
                #   # Call the delete_agent method.
                #   result = client.delete_agent request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::DeleteAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.delete_agent request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Exports the specified agent to a binary file.
                #
                # This method is a [long-running
                # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
                # The returned `Operation` type has the following method-specific fields:
                #
                # - `metadata`: An empty [Struct
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
                # - `response`:
                # {::Google::Cloud::Dialogflow::CX::V3::ExportAgentResponse ExportAgentResponse}
                #
                # @overload export_agent(request, options = nil)
                #   Pass arguments to `export_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload export_agent(name: nil, agent_uri: nil, data_format: nil, environment: nil, git_destination: nil, include_bigquery_export_settings: nil)
                #   Pass arguments to `export_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the agent to export.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param agent_uri [::String]
                #     Optional. The [Google Cloud
                #     Storage](https://cloud.google.com/storage/docs/) URI to export the agent
                #     to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
                #     left unspecified, the serialized agent is returned inline.
                #
                #     Dialogflow performs a write operation for the Cloud Storage object
                #     on the caller's behalf, so your request authentication must
                #     have write permissions for the object. For more information, see
                #     [Dialogflow access
                #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
                #   @param data_format [::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest::DataFormat]
                #     Optional. The data format of the exported agent. If not specified, `BLOB`
                #     is assumed.
                #   @param environment [::String]
                #     Optional. Environment name. If not set, draft environment is assumed.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>`.
                #   @param git_destination [::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest::GitDestination, ::Hash]
                #     Optional. The Git branch to export the agent to.
                #   @param include_bigquery_export_settings [::Boolean]
                #     Optional. Whether to include BigQuery Export setting.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest.new
                #
                #   # Call the export_agent method.
                #   result = client.export_agent request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def export_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ExportAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.export_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.export_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.export_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.export_agent request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Restores the specified agent from a binary file.
                #
                # Replaces the current agent with a new one. Note that all existing resources
                # in agent (e.g. intents, entity types, flows) will be removed.
                #
                # This method is a [long-running
                # operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
                # The returned `Operation` type has the following method-specific fields:
                #
                # - `metadata`: An empty [Struct
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
                # - `response`: An [Empty
                #   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
                #
                # Note: You should always train flows prior to sending them queries. See the
                # [training
                # documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
                #
                # @overload restore_agent(request, options = nil)
                #   Pass arguments to `restore_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload restore_agent(name: nil, agent_uri: nil, agent_content: nil, git_source: nil, restore_option: nil)
                #   Pass arguments to `restore_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the agent to restore into.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param agent_uri [::String]
                #     The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
                #     to restore agent from. The format of this URI must be
                #     `gs://<bucket-name>/<object-name>`.
                #
                #     Dialogflow performs a read operation for the Cloud Storage object
                #     on the caller's behalf, so your request authentication must
                #     have read permissions for the object. For more information, see
                #     [Dialogflow access
                #     control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
                #
                #     Note: The following parameters are mutually exclusive: `agent_uri`, `agent_content`, `git_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param agent_content [::String]
                #     Uncompressed raw byte content for agent.
                #
                #     Note: The following parameters are mutually exclusive: `agent_content`, `agent_uri`, `git_source`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param git_source [::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest::GitSource, ::Hash]
                #     Setting for restoring from a git branch
                #
                #     Note: The following parameters are mutually exclusive: `git_source`, `agent_uri`, `agent_content`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
                #   @param restore_option [::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest::RestoreOption]
                #     Agent restore mode. If not specified, `KEEP` is assumed.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest.new
                #
                #   # Call the restore_agent method.
                #   result = client.restore_agent request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def restore_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::RestoreAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.restore_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.restore_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.restore_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.restore_agent request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Validates the specified agent and creates or updates validation results.
                # The agent in draft version is validated. Please call this API after the
                # training is completed to get the complete validation results.
                #
                # @overload validate_agent(request, options = nil)
                #   Pass arguments to `validate_agent` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::ValidateAgentRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::ValidateAgentRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload validate_agent(name: nil, language_code: nil)
                #   Pass arguments to `validate_agent` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The agent to validate.
                #     Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
                #   @param language_code [::String]
                #     If not specified, the agent's default language is used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::AgentValidationResult]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::AgentValidationResult]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::ValidateAgentRequest.new
                #
                #   # Call the validate_agent method.
                #   result = client.validate_agent request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::AgentValidationResult.
                #   p result
                #
                def validate_agent request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::ValidateAgentRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.validate_agent.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.validate_agent.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.validate_agent.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.validate_agent request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets the latest agent validation result. Agent validation is performed
                # when ValidateAgent is called.
                #
                # @overload get_agent_validation_result(request, options = nil)
                #   Pass arguments to `get_agent_validation_result` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetAgentValidationResultRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetAgentValidationResultRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_agent_validation_result(name: nil, language_code: nil)
                #   Pass arguments to `get_agent_validation_result` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The agent name.
                #     Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/validationResult`.
                #   @param language_code [::String]
                #     If not specified, the agent's default language is used.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::AgentValidationResult]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::AgentValidationResult]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetAgentValidationResultRequest.new
                #
                #   # Call the get_agent_validation_result method.
                #   result = client.get_agent_validation_result request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::AgentValidationResult.
                #   p result
                #
                def get_agent_validation_result request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetAgentValidationResultRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_agent_validation_result.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_agent_validation_result.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_agent_validation_result.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.get_agent_validation_result request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets the generative settings for the agent.
                #
                # @overload get_generative_settings(request, options = nil)
                #   Pass arguments to `get_generative_settings` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::GetGenerativeSettingsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::GetGenerativeSettingsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_generative_settings(name: nil, language_code: nil)
                #   Pass arguments to `get_generative_settings` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. Format:
                #     `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings`.
                #   @param language_code [::String]
                #     Required. Language code of the generative settings.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::GetGenerativeSettingsRequest.new
                #
                #   # Call the get_generative_settings method.
                #   result = client.get_generative_settings request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::GenerativeSettings.
                #   p result
                #
                def get_generative_settings request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::GetGenerativeSettingsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_generative_settings.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_generative_settings.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_generative_settings.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.get_generative_settings request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates the generative settings for the agent.
                #
                # @overload update_generative_settings(request, options = nil)
                #   Pass arguments to `update_generative_settings` via a request object, either of type
                #   {::Google::Cloud::Dialogflow::CX::V3::UpdateGenerativeSettingsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Dialogflow::CX::V3::UpdateGenerativeSettingsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_generative_settings(generative_settings: nil, update_mask: nil)
                #   Pass arguments to `update_generative_settings` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param generative_settings [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings, ::Hash]
                #     Required. Generative settings to update.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Optional. The mask to control which fields get updated. If the mask is not
                #     present, all fields will be updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Dialogflow::CX::V3::GenerativeSettings]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/dialogflow/cx/v3"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Dialogflow::CX::V3::UpdateGenerativeSettingsRequest.new
                #
                #   # Call the update_generative_settings method.
                #   result = client.update_generative_settings request
                #
                #   # The returned object is of type Google::Cloud::Dialogflow::CX::V3::GenerativeSettings.
                #   p result
                #
                def update_generative_settings request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dialogflow::CX::V3::UpdateGenerativeSettingsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_generative_settings.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Dialogflow::CX::V3::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_generative_settings.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_generative_settings.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @agents_stub.update_generative_settings request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the Agents REST API.
                #
                # This class represents the configuration for Agents REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # list_agents to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_agents.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Dialogflow::CX::V3::Agents::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_agents.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "dialogflow.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the Agents API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `list_agents`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_agents
                    ##
                    # RPC-specific configuration for `get_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_agent
                    ##
                    # RPC-specific configuration for `create_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_agent
                    ##
                    # RPC-specific configuration for `update_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_agent
                    ##
                    # RPC-specific configuration for `delete_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_agent
                    ##
                    # RPC-specific configuration for `export_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :export_agent
                    ##
                    # RPC-specific configuration for `restore_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :restore_agent
                    ##
                    # RPC-specific configuration for `validate_agent`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :validate_agent
                    ##
                    # RPC-specific configuration for `get_agent_validation_result`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_agent_validation_result
                    ##
                    # RPC-specific configuration for `get_generative_settings`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_generative_settings
                    ##
                    # RPC-specific configuration for `update_generative_settings`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_generative_settings

                    # @private
                    def initialize parent_rpcs = nil
                      list_agents_config = parent_rpcs.list_agents if parent_rpcs.respond_to? :list_agents
                      @list_agents = ::Gapic::Config::Method.new list_agents_config
                      get_agent_config = parent_rpcs.get_agent if parent_rpcs.respond_to? :get_agent
                      @get_agent = ::Gapic::Config::Method.new get_agent_config
                      create_agent_config = parent_rpcs.create_agent if parent_rpcs.respond_to? :create_agent
                      @create_agent = ::Gapic::Config::Method.new create_agent_config
                      update_agent_config = parent_rpcs.update_agent if parent_rpcs.respond_to? :update_agent
                      @update_agent = ::Gapic::Config::Method.new update_agent_config
                      delete_agent_config = parent_rpcs.delete_agent if parent_rpcs.respond_to? :delete_agent
                      @delete_agent = ::Gapic::Config::Method.new delete_agent_config
                      export_agent_config = parent_rpcs.export_agent if parent_rpcs.respond_to? :export_agent
                      @export_agent = ::Gapic::Config::Method.new export_agent_config
                      restore_agent_config = parent_rpcs.restore_agent if parent_rpcs.respond_to? :restore_agent
                      @restore_agent = ::Gapic::Config::Method.new restore_agent_config
                      validate_agent_config = parent_rpcs.validate_agent if parent_rpcs.respond_to? :validate_agent
                      @validate_agent = ::Gapic::Config::Method.new validate_agent_config
                      get_agent_validation_result_config = parent_rpcs.get_agent_validation_result if parent_rpcs.respond_to? :get_agent_validation_result
                      @get_agent_validation_result = ::Gapic::Config::Method.new get_agent_validation_result_config
                      get_generative_settings_config = parent_rpcs.get_generative_settings if parent_rpcs.respond_to? :get_generative_settings
                      @get_generative_settings = ::Gapic::Config::Method.new get_generative_settings_config
                      update_generative_settings_config = parent_rpcs.update_generative_settings if parent_rpcs.respond_to? :update_generative_settings
                      @update_generative_settings = ::Gapic::Config::Method.new update_generative_settings_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
