# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/devicestreaming/v1/service_pb"
require "google/cloud/device_streaming/v1/direct_access_service"

class ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_device_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    device_session = {}
    device_session_id = "hello world"

    create_device_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_device_session, name
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeviceStreaming::V1::DeviceSession), request["device_session"]
      assert_equal "hello world", request["device_session_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_device_session_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_device_session({ parent: parent, device_session: device_session, device_session_id: device_session_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_device_session parent: parent, device_session: device_session, device_session_id: device_session_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_device_session ::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest.new(parent: parent, device_session: device_session, device_session_id: device_session_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_device_session({ parent: parent, device_session: device_session, device_session_id: device_session_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_device_session(::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest.new(parent: parent, device_session: device_session, device_session_id: device_session_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_device_session_client_stub.call_rpc_count
    end
  end

  def test_list_device_sessions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_device_sessions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_device_sessions, name
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_device_sessions_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_device_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_device_sessions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_device_sessions ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_device_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_device_sessions(::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_device_sessions_client_stub.call_rpc_count
    end
  end

  def test_get_device_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_device_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_device_session, name
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_device_session_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_device_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_device_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_device_session ::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_device_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_device_session(::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_device_session_client_stub.call_rpc_count
    end
  end

  def test_cancel_device_session
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_device_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_device_session, name
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_device_session_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_device_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_device_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_device_session ::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_device_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_device_session(::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_device_session_client_stub.call_rpc_count
    end
  end

  def test_update_device_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    device_session = {}
    update_mask = {}

    update_device_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_device_session, name
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeviceStreaming::V1::DeviceSession), request["device_session"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_device_session_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_device_session({ device_session: device_session, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_device_session device_session: device_session, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_device_session ::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest.new(device_session: device_session, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_device_session({ device_session: device_session, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_device_session(::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest.new(device_session: device_session, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_device_session_client_stub.call_rpc_count
    end
  end

  def test_adb_connect
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeviceStreaming::V1::DeviceMessage.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    open = {}

    adb_connect_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :adb_connect, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, adb_connect_client_stub do
      # Create client
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { open: open }
      request_proto = ::Google::Cloud::DeviceStreaming::V1::AdbMessage.new open: open
      enum_input = [request_hash, request_proto].to_enum
      client.adb_connect enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DeviceMessage, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { open: open }
      request_proto = ::Google::Cloud::DeviceStreaming::V1::AdbMessage.new open: open
      stream_input = Gapic::StreamInput.new
      client.adb_connect stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DeviceMessage, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { open: open }
      request_proto = ::Google::Cloud::DeviceStreaming::V1::AdbMessage.new open: open
      enum_input = [request_hash, request_proto].to_enum
      client.adb_connect enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DeviceMessage, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { open: open }
      request_proto = ::Google::Cloud::DeviceStreaming::V1::AdbMessage.new open: open
      stream_input = Gapic::StreamInput.new
      client.adb_connect stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DeviceMessage, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, adb_connect_client_stub.call_rpc_count
      adb_connect_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::DeviceStreaming::V1::AdbMessage, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeviceStreaming::V1::Open), r["open"]
          assert_equal :open, r.contents
        end
      end
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
