# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/devicestreaming/v1/service_pb"
require "google/cloud/device_streaming/v1/direct_access_service/rest"


class ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_device_session
    # Create test objects.
    client_result = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    device_session = {}
    device_session_id = "hello world"

    create_device_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ServiceStub.stub :transcode_create_device_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_device_session_client_stub do
        # Create client
        client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_device_session({ parent: parent, device_session: device_session, device_session_id: device_session_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_device_session parent: parent, device_session: device_session, device_session_id: device_session_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_device_session ::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest.new(parent: parent, device_session: device_session, device_session_id: device_session_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_device_session({ parent: parent, device_session: device_session, device_session_id: device_session_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_device_session(::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest.new(parent: parent, device_session: device_session, device_session_id: device_session_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_device_session_client_stub.call_count
      end
    end
  end

  def test_list_device_sessions
    # Create test objects.
    client_result = ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_device_sessions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ServiceStub.stub :transcode_list_device_sessions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_device_sessions_client_stub do
        # Create client
        client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_device_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_device_sessions parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_device_sessions ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_device_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_device_sessions(::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_device_sessions_client_stub.call_count
      end
    end
  end

  def test_get_device_session
    # Create test objects.
    client_result = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_device_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ServiceStub.stub :transcode_get_device_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_device_session_client_stub do
        # Create client
        client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_device_session({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_device_session name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_device_session ::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_device_session({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_device_session(::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_device_session_client_stub.call_count
      end
    end
  end

  def test_cancel_device_session
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_device_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ServiceStub.stub :transcode_cancel_device_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_device_session_client_stub do
        # Create client
        client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_device_session({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_device_session name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_device_session ::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_device_session({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_device_session(::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_device_session_client_stub.call_count
      end
    end
  end

  def test_update_device_session
    # Create test objects.
    client_result = ::Google::Cloud::DeviceStreaming::V1::DeviceSession.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    device_session = {}
    update_mask = {}

    update_device_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::ServiceStub.stub :transcode_update_device_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_device_session_client_stub do
        # Create client
        client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_device_session({ device_session: device_session, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_device_session device_session: device_session, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_device_session ::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest.new(device_session: device_session, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_device_session({ device_session: device_session, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_device_session(::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest.new(device_session: device_session, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_device_session_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client::Configuration, config
  end
end
