# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DeviceStreaming
      module V1
        # Request message for DirectAccessService.CreateDeviceSession.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Compute Engine project under which this device will be
        #     allocated. "projects/\\{project_id}"
        # @!attribute [rw] device_session
        #   @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
        #     Required. A DeviceSession to create.
        # @!attribute [rw] device_session_id
        #   @return [::String]
        #     Optional. The ID to use for the DeviceSession, which will become the final
        #     component of the DeviceSession's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        class CreateDeviceSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DirectAccessService.ListDeviceSessions.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent to request, e.g. "projects/\\{project_id}"
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of DeviceSessions to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A continuation token for paging.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. If specified, responses will be filtered by the given filter.
        #     Allowed fields are: session_state.
        class ListDeviceSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for DirectAccessService.ListDeviceSessions.
        # @!attribute [rw] device_sessions
        #   @return [::Array<::Google::Cloud::DeviceStreaming::V1::DeviceSession>]
        #     The sessions matching the specified filter in the given cloud project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDeviceSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DirectAccessService.GetDeviceSession.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the DeviceSession, e.g.
        #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
        class GetDeviceSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DirectAccessService.CancelDeviceSession.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the DeviceSession, e.g.
        #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
        class CancelDeviceSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DirectAccessService.UpdateDeviceSession.
        # @!attribute [rw] device_session
        #   @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
        #     Required. DeviceSession to update.
        #     The DeviceSession's `name` field is used to identify the session to update
        #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateDeviceSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Protobuf message describing the device message, used from several RPCs.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. Name of the DeviceSession, e.g.
        #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The title of the DeviceSession to be presented in the UI.
        # @!attribute [r] state
        #   @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession::SessionState]
        #     Output only. Current state of the DeviceSession.
        # @!attribute [r] state_histories
        #   @return [::Array<::Google::Cloud::DeviceStreaming::V1::DeviceSession::SessionStateEvent>]
        #     Output only. The historical state transitions of the session_state message
        #     including the current session state.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The amount of time that a device will be initially allocated
        #     for. This can eventually be extended with the UpdateDeviceSession RPC.
        #     Default: 15 minutes.
        #
        #     Note: The following fields are mutually exclusive: `ttl`, `expire_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. If the device is still in use at this time, any connections
        #     will be ended and the SessionState will transition from ACTIVE to
        #     FINISHED.
        #
        #     Note: The following fields are mutually exclusive: `expire_time`, `ttl`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] inactivity_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Output only. The interval of time that this device must be interacted with
        #     before it transitions from ACTIVE to TIMEOUT_INACTIVITY.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time that the Session was created.
        # @!attribute [r] active_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp that the session first became ACTIVE.
        # @!attribute [rw] android_device
        #   @return [::Google::Cloud::DeviceStreaming::V1::AndroidDevice]
        #     Required. The requested device
        class DeviceSession
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A message encapsulating a series of Session states and the time that the
          # DeviceSession first entered those states.
          # @!attribute [r] session_state
          #   @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession::SessionState]
          #     Output only. The session_state tracked by this event
          # @!attribute [r] event_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time that the session_state first encountered that
          #     state.
          # @!attribute [r] state_message
          #   @return [::String]
          #     Output only. A human-readable message to explain the state.
          class SessionStateEvent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state that the DeviceSession resides.
          module SessionState
            # Default value. This value is unused.
            SESSION_STATE_UNSPECIFIED = 0

            # Initial state of a session request. The session is being validated for
            # correctness and a device is not yet requested.
            REQUESTED = 1

            # The session has been validated and is in the queue for a device.
            PENDING = 2

            # The session has been granted and the device is accepting
            # connections.
            ACTIVE = 3

            # The session duration exceeded the device's reservation time period and
            # timed out automatically.
            EXPIRED = 4

            # The user is finished with the session and it was canceled by the user
            # while the request was still getting allocated or after allocation and
            # during device usage period.
            FINISHED = 5

            # Unable to complete the session because the device was unavailable and
            # it failed to allocate through the scheduler. For example, a device not
            # in the catalog was requested or the request expired in the allocation
            # queue.
            UNAVAILABLE = 6

            # Unable to complete the session for an internal reason, such as an
            # infrastructure failure.
            ERROR = 7
          end
        end

        # A single Android device.
        # @!attribute [rw] android_model_id
        #   @return [::String]
        #     Required. The id of the Android device to be used.
        #     Use the TestEnvironmentDiscoveryService to get supported options.
        # @!attribute [rw] android_version_id
        #   @return [::String]
        #     Required. The id of the Android OS version to be used.
        #     Use the TestEnvironmentDiscoveryService to get supported options.
        # @!attribute [rw] locale
        #   @return [::String]
        #     Optional. The locale the test device used for testing.
        #     Use the TestEnvironmentDiscoveryService to get supported options.
        # @!attribute [rw] orientation
        #   @return [::String]
        #     Optional. How the device is oriented during the test.
        #     Use the TestEnvironmentDiscoveryService to get supported options.
        class AndroidDevice
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
