# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DeviceStreaming
      module V1
        # A message returned from a device.
        # @!attribute [rw] status_update
        #   @return [::Google::Cloud::DeviceStreaming::V1::StatusUpdate]
        #     Information about the device's state.
        #
        #     Note: The following fields are mutually exclusive: `status_update`, `stream_status`, `stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stream_status
        #   @return [::Google::Cloud::DeviceStreaming::V1::StreamStatus]
        #     The result of a device stream from ADB.
        #
        #     Note: The following fields are mutually exclusive: `stream_status`, `status_update`, `stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stream_data
        #   @return [::Google::Cloud::DeviceStreaming::V1::StreamData]
        #     Data from an open stream.
        #
        #     Note: The following fields are mutually exclusive: `stream_data`, `status_update`, `stream_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DeviceMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message to an ADB server.
        # @!attribute [rw] open
        #   @return [::Google::Cloud::DeviceStreaming::V1::Open]
        #     Open a new stream.
        #
        #     Note: The following fields are mutually exclusive: `open`, `stream_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stream_data
        #   @return [::Google::Cloud::DeviceStreaming::V1::StreamData]
        #     Send data to a stream.
        #
        #     Note: The following fields are mutually exclusive: `stream_data`, `open`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AdbMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A StatusUpdate message given over the ADB protocol for the device state.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DeviceStreaming::V1::StatusUpdate::DeviceState]
        #     The device's state
        # @!attribute [rw] properties
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map of properties with information about this device.
        # @!attribute [rw] features
        #   @return [::String]
        #     A comma-separated list of "features" that this device supports.
        class StatusUpdate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class PropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state displayed with the ADB Device when running "adb devices"
          module DeviceState
            # The device state is unknown.
            DEVICE_STATE_UNSPECIFIED = 0

            # The ADB device is in the "device" status.
            DEVICE = 1

            # The ADB device is in the "recovery" status.
            RECOVERY = 2

            # The ADB device is in the "rescue" status.
            RESCUE = 3

            # The ADB device is in the "sideload" status.
            SIDELOAD = 4

            # The ADB device is in the "missing" status.
            MISSING = 10

            # The ADB device is in the "offline" status.
            OFFLINE = 11

            # The ADB device is in the "unauthorized" status.
            UNAUTHORIZED = 12

            # The ADB device is in the "authorizing" status.
            AUTHORIZING = 13

            # The ADB device is in the "connecting" status.
            CONNECTING = 14
          end
        end

        # The result of a stream.
        # @!attribute [rw] stream_id
        #   @return [::Integer]
        #     The unique ID of this stream, assigned by the client.
        # @!attribute [rw] okay
        #   @return [::Google::Cloud::DeviceStreaming::V1::Okay]
        #     Okay for success.
        #
        #     Note: The following fields are mutually exclusive: `okay`, `fail`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fail
        #   @return [::Google::Cloud::DeviceStreaming::V1::Fail]
        #     Fail for failure.
        #
        #     Note: The following fields are mutually exclusive: `fail`, `okay`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class StreamStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for opening a new stream.
        # @!attribute [rw] stream_id
        #   @return [::Integer]
        #     Required. The unique ID that will be used to talk to this stream. This
        #     should probably just be a number that increments for each new Open request.
        # @!attribute [rw] service
        #   @return [::String]
        #     Optional. An ADB service to use in the new stream.
        class Open
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data for a stream.
        # @!attribute [rw] stream_id
        #   @return [::Integer]
        #     Required. The unique ID of this stream, assigned by the client.
        # @!attribute [rw] data
        #   @return [::String]
        #     Data in the stream.
        #
        #     Note: The following fields are mutually exclusive: `data`, `close`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] close
        #   @return [::Google::Cloud::DeviceStreaming::V1::Close]
        #     The stream is closing. EOF.
        #
        #     Note: The following fields are mutually exclusive: `close`, `data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class StreamData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message signifying that the stream is open
        class Okay
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message signifying that the stream failed to open
        # @!attribute [rw] reason
        #   @return [::String]
        #     A user-displayable failure reason.
        class Fail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message signifying that the stream closed.
        class Close
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
