# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/devicestreaming/v1/service.proto for package 'Google.Cloud.DeviceStreaming.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/devicestreaming/v1/service_pb'

module Google
  module Cloud
    module DeviceStreaming
      module V1
        module DirectAccessService
          # A service for allocating Android devices and interacting with the
          # live-allocated devices.
          #
          # Each Session will wait for available capacity, at a higher
          # priority over Test Execution. When allocated, the session will be exposed
          # through a stream for integration.
          #
          # DirectAccessService is currently available as a preview to select developers.
          # You can register today on behalf of you and your team at
          # https://developer.android.com/studio/preview/android-device-streaming
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.devicestreaming.v1.DirectAccessService'

            # Creates a DeviceSession.
            rpc :CreateDeviceSession, ::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest, ::Google::Cloud::DeviceStreaming::V1::DeviceSession
            # Lists DeviceSessions owned by the project user.
            rpc :ListDeviceSessions, ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest, ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsResponse
            # Gets a DeviceSession, which documents the allocation status and
            # whether the device is allocated. Clients making requests from this API
            # must poll GetDeviceSession.
            rpc :GetDeviceSession, ::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest, ::Google::Cloud::DeviceStreaming::V1::DeviceSession
            # Cancel a DeviceSession.
            # This RPC changes the DeviceSession to state FINISHED and terminates all
            # connections.
            # Canceled sessions are not deleted and can be retrieved or
            # listed by the user until they expire based on the 28 day deletion policy.
            rpc :CancelDeviceSession, ::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest, ::Google::Protobuf::Empty
            # Updates the current DeviceSession to the fields described by the
            # update_mask.
            rpc :UpdateDeviceSession, ::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest, ::Google::Cloud::DeviceStreaming::V1::DeviceSession
            # Exposes an ADB connection if the device supports ADB.
            # gRPC headers are used to authenticate the Connect RPC, as well as
            # associate to a particular DeviceSession.
            # In particular, the user must specify the "X-Omnilab-Session-Name" header.
            rpc :AdbConnect, stream(::Google::Cloud::DeviceStreaming::V1::AdbMessage), stream(::Google::Cloud::DeviceStreaming::V1::DeviceMessage)
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
