# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/device_streaming/v1/version"

require "google/cloud/device_streaming/v1/direct_access_service/credentials"
require "google/cloud/device_streaming/v1/direct_access_service/paths"
require "google/cloud/device_streaming/v1/direct_access_service/rest/client"

module Google
  module Cloud
    module DeviceStreaming
      module V1
        ##
        # A service for allocating Android devices and interacting with the
        # live-allocated devices.
        #
        # Each Session will wait for available capacity, at a higher
        # priority over Test Execution. When allocated, the session will be exposed
        # through a stream for integration.
        #
        # DirectAccessService is currently available as a preview to select developers.
        # You can register today on behalf of you and your team at
        # https://developer.android.com/studio/preview/android-device-streaming
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/device_streaming/v1/direct_access_service/rest"
        #     client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Rest::Client.new
        #
        module DirectAccessService
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/device_streaming/v1/direct_access_service/rest/helpers" if ::File.file? helper_path
