# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/devicestreaming/v1/service_pb"

module Google
  module Cloud
    module DeviceStreaming
      module V1
        module DirectAccessService
          ##
          # Client for the DirectAccessService service.
          #
          # A service for allocating Android devices and interacting with the
          # live-allocated devices.
          #
          # Each Session will wait for available capacity, at a higher
          # priority over Test Execution. When allocated, the session will be exposed
          # through a stream for integration.
          #
          # DirectAccessService is currently available as a preview to select developers.
          # You can register today on behalf of you and your team at
          # https://developer.android.com/studio/preview/android-device-streaming
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "devicestreaming.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :direct_access_service_stub

            ##
            # Configure the DirectAccessService Client class.
            #
            # See {::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DirectAccessService clients
            #   ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DeviceStreaming", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_device_session.timeout = 20.0

                default_config.rpcs.list_device_sessions.timeout = 20.0
                default_config.rpcs.list_device_sessions.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_device_session.timeout = 20.0
                default_config.rpcs.get_device_session.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.cancel_device_session.timeout = 20.0
                default_config.rpcs.cancel_device_session.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_device_session.timeout = 20.0

                default_config.rpcs.adb_connect.timeout = 1800.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DirectAccessService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @direct_access_service_stub.universe_domain
            end

            ##
            # Create a new DirectAccessService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DirectAccessService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/devicestreaming/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @direct_access_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @direct_access_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @direct_access_service_stub.logger
            end

            # Service calls

            ##
            # Creates a DeviceSession.
            #
            # @overload create_device_session(request, options = nil)
            #   Pass arguments to `create_device_session` via a request object, either of type
            #   {::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_device_session(parent: nil, device_session: nil, device_session_id: nil)
            #   Pass arguments to `create_device_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Compute Engine project under which this device will be
            #     allocated. "projects/\\{project_id}"
            #   @param device_session [::Google::Cloud::DeviceStreaming::V1::DeviceSession, ::Hash]
            #     Required. A DeviceSession to create.
            #   @param device_session_id [::String]
            #     Optional. The ID to use for the DeviceSession, which will become the final
            #     component of the DeviceSession's resource name.
            #
            #     This value should be 4-63 characters, and valid characters
            #     are /[a-z][0-9]-/.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest.new
            #
            #   # Call the create_device_session method.
            #   result = client.create_device_session request
            #
            #   # The returned object is of type Google::Cloud::DeviceStreaming::V1::DeviceSession.
            #   p result
            #
            def create_device_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeviceStreaming::V1::CreateDeviceSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_device_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_device_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_device_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :create_device_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DeviceSessions owned by the project user.
            #
            # @overload list_device_sessions(request, options = nil)
            #   Pass arguments to `list_device_sessions` via a request object, either of type
            #   {::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_device_sessions(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_device_sessions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent to request, e.g. "projects/\\{project_id}"
            #   @param page_size [::Integer]
            #     Optional. The maximum number of DeviceSessions to return.
            #   @param page_token [::String]
            #     Optional. A continuation token for paging.
            #   @param filter [::String]
            #     Optional. If specified, responses will be filtered by the given filter.
            #     Allowed fields are: session_state.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeviceStreaming::V1::DeviceSession>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeviceStreaming::V1::DeviceSession>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest.new
            #
            #   # Call the list_device_sessions method.
            #   result = client.list_device_sessions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeviceStreaming::V1::DeviceSession.
            #     p item
            #   end
            #
            def list_device_sessions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeviceStreaming::V1::ListDeviceSessionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_device_sessions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_device_sessions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_device_sessions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :list_device_sessions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @direct_access_service_stub, :list_device_sessions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a DeviceSession, which documents the allocation status and
            # whether the device is allocated. Clients making requests from this API
            # must poll GetDeviceSession.
            #
            # @overload get_device_session(request, options = nil)
            #   Pass arguments to `get_device_session` via a request object, either of type
            #   {::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_device_session(name: nil)
            #   Pass arguments to `get_device_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the DeviceSession, e.g.
            #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest.new
            #
            #   # Call the get_device_session method.
            #   result = client.get_device_session request
            #
            #   # The returned object is of type Google::Cloud::DeviceStreaming::V1::DeviceSession.
            #   p result
            #
            def get_device_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeviceStreaming::V1::GetDeviceSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_device_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_device_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_device_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :get_device_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancel a DeviceSession.
            # This RPC changes the DeviceSession to state FINISHED and terminates all
            # connections.
            # Canceled sessions are not deleted and can be retrieved or
            # listed by the user until they expire based on the 28 day deletion policy.
            #
            # @overload cancel_device_session(request, options = nil)
            #   Pass arguments to `cancel_device_session` via a request object, either of type
            #   {::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_device_session(name: nil)
            #   Pass arguments to `cancel_device_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the DeviceSession, e.g.
            #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest.new
            #
            #   # Call the cancel_device_session method.
            #   result = client.cancel_device_session request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_device_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeviceStreaming::V1::CancelDeviceSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_device_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_device_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_device_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :cancel_device_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the current DeviceSession to the fields described by the
            # update_mask.
            #
            # @overload update_device_session(request, options = nil)
            #   Pass arguments to `update_device_session` via a request object, either of type
            #   {::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_device_session(device_session: nil, update_mask: nil)
            #   Pass arguments to `update_device_session` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param device_session [::Google::Cloud::DeviceStreaming::V1::DeviceSession, ::Hash]
            #     Required. DeviceSession to update.
            #     The DeviceSession's `name` field is used to identify the session to update
            #     "projects/\\{project_id}/deviceSessions/\\{session_id}"
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The list of fields to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeviceStreaming::V1::DeviceSession]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest.new
            #
            #   # Call the update_device_session method.
            #   result = client.update_device_session request
            #
            #   # The returned object is of type Google::Cloud::DeviceStreaming::V1::DeviceSession.
            #   p result
            #
            def update_device_session request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeviceStreaming::V1::UpdateDeviceSessionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_device_session.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.device_session&.name
                header_params["device_session.name"] = request.device_session.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_device_session.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_device_session.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :update_device_session, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exposes an ADB connection if the device supports ADB.
            # gRPC headers are used to authenticate the Connect RPC, as well as
            # associate to a particular DeviceSession.
            # In particular, the user must specify the "X-Omnilab-Session-Name" header.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::DeviceStreaming::V1::AdbMessage, ::Hash>]
            #   An enumerable of {::Google::Cloud::DeviceStreaming::V1::AdbMessage} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::DeviceStreaming::V1::DeviceMessage>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::DeviceStreaming::V1::DeviceMessage>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/device_streaming/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the adb_connect method to start streaming.
            #   output = client.adb_connect input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::DeviceStreaming::V1::AdbMessage.new
            #   input << Google::Cloud::DeviceStreaming::V1::AdbMessage.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::DeviceStreaming::V1::DeviceMessage
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def adb_connect request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::DeviceStreaming::V1::AdbMessage
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.adb_connect.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeviceStreaming::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.adb_connect.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.adb_connect.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @direct_access_service_stub.call_rpc :adb_connect, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DirectAccessService API.
            #
            # This class represents the configuration for DirectAccessService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_device_session to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_device_session.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_device_session.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DeviceStreaming::V1::DirectAccessService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "devicestreaming.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DirectAccessService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_device_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_device_session
                ##
                # RPC-specific configuration for `list_device_sessions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_device_sessions
                ##
                # RPC-specific configuration for `get_device_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_device_session
                ##
                # RPC-specific configuration for `cancel_device_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_device_session
                ##
                # RPC-specific configuration for `update_device_session`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_device_session
                ##
                # RPC-specific configuration for `adb_connect`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :adb_connect

                # @private
                def initialize parent_rpcs = nil
                  create_device_session_config = parent_rpcs.create_device_session if parent_rpcs.respond_to? :create_device_session
                  @create_device_session = ::Gapic::Config::Method.new create_device_session_config
                  list_device_sessions_config = parent_rpcs.list_device_sessions if parent_rpcs.respond_to? :list_device_sessions
                  @list_device_sessions = ::Gapic::Config::Method.new list_device_sessions_config
                  get_device_session_config = parent_rpcs.get_device_session if parent_rpcs.respond_to? :get_device_session
                  @get_device_session = ::Gapic::Config::Method.new get_device_session_config
                  cancel_device_session_config = parent_rpcs.cancel_device_session if parent_rpcs.respond_to? :cancel_device_session
                  @cancel_device_session = ::Gapic::Config::Method.new cancel_device_session_config
                  update_device_session_config = parent_rpcs.update_device_session if parent_rpcs.respond_to? :update_device_session
                  @update_device_session = ::Gapic::Config::Method.new update_device_session_config
                  adb_connect_config = parent_rpcs.adb_connect if parent_rpcs.respond_to? :adb_connect
                  @adb_connect = ::Gapic::Config::Method.new adb_connect_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
