# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/developerconnect/v1/developer_connect_pb"
require "google/cloud/developer_connect/v1/developer_connect"

class ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::ListConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connections, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connections_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connections ::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connections(::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connections_client_stub.call_rpc_count
    end
  end

  def test_get_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::Connection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection ::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection(::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_client_stub.call_rpc_count
    end
  end

  def test_create_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_id = "hello world"
    connection = {}
    request_id = "hello world"
    validate_only = true

    create_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connection, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeveloperConnect::V1::Connection), request["connection"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connection_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connection({ parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connection parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connection ::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connection({ parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connection(::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connection_client_stub.call_rpc_count
    end
  end

  def test_update_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connection = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connection, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeveloperConnect::V1::Connection), request["connection"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connection_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connection({ update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connection update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connection ::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest.new(update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connection({ update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connection(::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest.new(update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connection_client_stub.call_rpc_count
    end
  end

  def test_delete_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connection, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connection_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connection({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connection name: name, request_id: request_id, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connection ::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connection({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connection(::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connection_client_stub.call_rpc_count
    end
  end

  def test_create_git_repository_link
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    git_repository_link = {}
    git_repository_link_id = "hello world"
    request_id = "hello world"
    validate_only = true

    create_git_repository_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_git_repository_link, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink), request["git_repository_link"]
      assert_equal "hello world", request["git_repository_link_id"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_git_repository_link_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_git_repository_link({ parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_git_repository_link parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_git_repository_link ::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest.new(parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_git_repository_link({ parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_git_repository_link(::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest.new(parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_git_repository_link_client_stub.call_rpc_count
    end
  end

  def test_delete_git_repository_link
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_git_repository_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_git_repository_link, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_git_repository_link_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_git_repository_link({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_git_repository_link name: name, request_id: request_id, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_git_repository_link ::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_git_repository_link({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_git_repository_link(::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_git_repository_link_client_stub.call_rpc_count
    end
  end

  def test_list_git_repository_links
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_git_repository_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_git_repository_links, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_git_repository_links_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_git_repository_links({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_git_repository_links parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_git_repository_links ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_git_repository_links({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_git_repository_links(::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_git_repository_links_client_stub.call_rpc_count
    end
  end

  def test_get_git_repository_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_git_repository_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_git_repository_link, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_git_repository_link_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_git_repository_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_git_repository_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_git_repository_link ::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_git_repository_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_git_repository_link(::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_git_repository_link_client_stub.call_rpc_count
    end
  end

  def test_fetch_read_write_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"

    fetch_read_write_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_read_write_token, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest, request
      assert_equal "hello world", request["git_repository_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_read_write_token_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_read_write_token({ git_repository_link: git_repository_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_read_write_token git_repository_link: git_repository_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_read_write_token ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest.new(git_repository_link: git_repository_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_read_write_token({ git_repository_link: git_repository_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_read_write_token(::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest.new(git_repository_link: git_repository_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_read_write_token_client_stub.call_rpc_count
    end
  end

  def test_fetch_read_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"

    fetch_read_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_read_token, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest, request
      assert_equal "hello world", request["git_repository_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_read_token_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_read_token({ git_repository_link: git_repository_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_read_token git_repository_link: git_repository_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_read_token ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest.new(git_repository_link: git_repository_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_read_token({ git_repository_link: git_repository_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_read_token(::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest.new(git_repository_link: git_repository_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_read_token_client_stub.call_rpc_count
    end
  end

  def test_fetch_linkable_git_repositories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    connection = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_linkable_git_repositories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_linkable_git_repositories, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest, request
      assert_equal "hello world", request["connection"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_linkable_git_repositories_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_linkable_git_repositories({ connection: connection, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_linkable_git_repositories connection: connection, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_linkable_git_repositories ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest.new(connection: connection, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_linkable_git_repositories({ connection: connection, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_linkable_git_repositories(::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest.new(connection: connection, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_linkable_git_repositories_client_stub.call_rpc_count
    end
  end

  def test_fetch_git_hub_installations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    connection = "hello world"

    fetch_git_hub_installations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_git_hub_installations, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest, request
      assert_equal "hello world", request["connection"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_git_hub_installations_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_git_hub_installations({ connection: connection }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_git_hub_installations connection: connection do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_git_hub_installations ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest.new(connection: connection) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_git_hub_installations({ connection: connection }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_git_hub_installations(::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest.new(connection: connection), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_git_hub_installations_client_stub.call_rpc_count
    end
  end

  def test_fetch_git_refs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"
    ref_type = :REF_TYPE_UNSPECIFIED
    page_size = 42
    page_token = "hello world"

    fetch_git_refs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_git_refs, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest, request
      assert_equal "hello world", request["git_repository_link"]
      assert_equal :REF_TYPE_UNSPECIFIED, request["ref_type"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_git_refs_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_git_refs({ git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_git_refs git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_git_refs ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest.new(git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_git_refs({ git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_git_refs(::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest.new(git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_git_refs_client_stub.call_rpc_count
    end
  end

  def test_list_account_connectors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_account_connectors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_account_connectors, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_account_connectors_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_account_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_account_connectors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_account_connectors ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_account_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_account_connectors(::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_account_connectors_client_stub.call_rpc_count
    end
  end

  def test_get_account_connector
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::AccountConnector.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_account_connector, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_account_connector_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_account_connector({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_account_connector name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_account_connector ::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_account_connector({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_account_connector(::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_account_connector_client_stub.call_rpc_count
    end
  end

  def test_create_account_connector
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    account_connector_id = "hello world"
    account_connector = {}
    request_id = "hello world"
    validate_only = true

    create_account_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_account_connector, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["account_connector_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeveloperConnect::V1::AccountConnector), request["account_connector"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_account_connector_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_account_connector({ parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_account_connector parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_account_connector ::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest.new(parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_account_connector({ parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_account_connector(::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest.new(parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_account_connector_client_stub.call_rpc_count
    end
  end

  def test_update_account_connector
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    account_connector = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_account_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_account_connector, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DeveloperConnect::V1::AccountConnector), request["account_connector"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_account_connector_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_account_connector({ update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_account_connector update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_account_connector ::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest.new(update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_account_connector({ update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_account_connector(::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest.new(update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_account_connector_client_stub.call_rpc_count
    end
  end

  def test_delete_account_connector
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_account_connector_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_account_connector, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_account_connector_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_account_connector({ name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_account_connector name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_account_connector ::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_account_connector({ name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_account_connector(::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_account_connector_client_stub.call_rpc_count
    end
  end

  def test_fetch_access_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account_connector = "hello world"

    fetch_access_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_access_token, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest, request
      assert_equal "hello world", request["account_connector"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_access_token_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_access_token({ account_connector: account_connector }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_access_token account_connector: account_connector do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_access_token ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest.new(account_connector: account_connector) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_access_token({ account_connector: account_connector }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_access_token(::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest.new(account_connector: account_connector), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_access_token_client_stub.call_rpc_count
    end
  end

  def test_list_users
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::ListUsersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_users_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_users, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::ListUsersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_users_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_users parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_users ::Google::Cloud::DeveloperConnect::V1::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_users(::Google::Cloud::DeveloperConnect::V1::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_users_client_stub.call_rpc_count
    end
  end

  def test_delete_user
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_user_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_user, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_user_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_user({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_user name: name, request_id: request_id, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_user ::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_user({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_user(::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_user_client_stub.call_rpc_count
    end
  end

  def test_fetch_self
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DeveloperConnect::V1::User.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_self_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_self, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_self_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_self({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_self name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_self ::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_self({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_self(::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_self_client_stub.call_rpc_count
    end
  end

  def test_delete_self
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_self_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_self, name
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_self_client_stub do
      # Create client
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_self({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_self name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_self ::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_self({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_self(::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_self_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Operations, client.operations_client
  end
end
