# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/developerconnect/v1/developer_connect_pb"
require "google/cloud/developer_connect/v1/developer_connect/rest"


class ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connections
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::ListConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_list_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connections_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connections ::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connections(::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connections_client_stub.call_count
      end
    end
  end

  def test_get_connection
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::Connection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_get_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connection_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connection ::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connection(::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connection_client_stub.call_count
      end
    end
  end

  def test_create_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_id = "hello world"
    connection = {}
    request_id = "hello world"
    validate_only = true

    create_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_create_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_connection_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_connection({ parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_connection parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_connection ::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_connection({ parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_connection(::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest.new(parent: parent, connection_id: connection_id, connection: connection, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_connection_client_stub.call_count
      end
    end
  end

  def test_update_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connection = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_update_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_connection_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_connection({ update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_connection update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_connection ::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest.new(update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_connection({ update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_connection(::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest.new(update_mask: update_mask, connection: connection, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_connection_client_stub.call_count
      end
    end
  end

  def test_delete_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_delete_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_connection_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_connection({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_connection name: name, request_id: request_id, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_connection ::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_connection({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_connection(::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_connection_client_stub.call_count
      end
    end
  end

  def test_create_git_repository_link
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    git_repository_link = {}
    git_repository_link_id = "hello world"
    request_id = "hello world"
    validate_only = true

    create_git_repository_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_create_git_repository_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_git_repository_link_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_git_repository_link({ parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_git_repository_link parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_git_repository_link ::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest.new(parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_git_repository_link({ parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_git_repository_link(::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest.new(parent: parent, git_repository_link: git_repository_link, git_repository_link_id: git_repository_link_id, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_git_repository_link_client_stub.call_count
      end
    end
  end

  def test_delete_git_repository_link
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_git_repository_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_delete_git_repository_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_git_repository_link_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_git_repository_link({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_git_repository_link name: name, request_id: request_id, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_git_repository_link ::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_git_repository_link({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_git_repository_link(::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_git_repository_link_client_stub.call_count
      end
    end
  end

  def test_list_git_repository_links
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_git_repository_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_list_git_repository_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_git_repository_links_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_git_repository_links({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_git_repository_links parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_git_repository_links ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_git_repository_links({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_git_repository_links(::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_git_repository_links_client_stub.call_count
      end
    end
  end

  def test_get_git_repository_link
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_git_repository_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_get_git_repository_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_git_repository_link_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_git_repository_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_git_repository_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_git_repository_link ::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_git_repository_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_git_repository_link(::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_git_repository_link_client_stub.call_count
      end
    end
  end

  def test_fetch_read_write_token
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"

    fetch_read_write_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_read_write_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_read_write_token_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_read_write_token({ git_repository_link: git_repository_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_read_write_token git_repository_link: git_repository_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_read_write_token ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest.new(git_repository_link: git_repository_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_read_write_token({ git_repository_link: git_repository_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_read_write_token(::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest.new(git_repository_link: git_repository_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_read_write_token_client_stub.call_count
      end
    end
  end

  def test_fetch_read_token
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"

    fetch_read_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_read_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_read_token_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_read_token({ git_repository_link: git_repository_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_read_token git_repository_link: git_repository_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_read_token ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest.new(git_repository_link: git_repository_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_read_token({ git_repository_link: git_repository_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_read_token(::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest.new(git_repository_link: git_repository_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_read_token_client_stub.call_count
      end
    end
  end

  def test_fetch_linkable_git_repositories
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    connection = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_linkable_git_repositories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_linkable_git_repositories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_linkable_git_repositories_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_linkable_git_repositories({ connection: connection, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_linkable_git_repositories connection: connection, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_linkable_git_repositories ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest.new(connection: connection, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_linkable_git_repositories({ connection: connection, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_linkable_git_repositories(::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest.new(connection: connection, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_linkable_git_repositories_client_stub.call_count
      end
    end
  end

  def test_fetch_git_hub_installations
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    connection = "hello world"

    fetch_git_hub_installations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_git_hub_installations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_git_hub_installations_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_git_hub_installations({ connection: connection }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_git_hub_installations connection: connection do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_git_hub_installations ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest.new(connection: connection) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_git_hub_installations({ connection: connection }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_git_hub_installations(::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest.new(connection: connection), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_git_hub_installations_client_stub.call_count
      end
    end
  end

  def test_fetch_git_refs
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    git_repository_link = "hello world"
    ref_type = :REF_TYPE_UNSPECIFIED
    page_size = 42
    page_token = "hello world"

    fetch_git_refs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_git_refs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_git_refs_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_git_refs({ git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_git_refs git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_git_refs ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest.new(git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_git_refs({ git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_git_refs(::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest.new(git_repository_link: git_repository_link, ref_type: ref_type, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_git_refs_client_stub.call_count
      end
    end
  end

  def test_list_account_connectors
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_account_connectors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_list_account_connectors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_account_connectors_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_account_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_account_connectors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_account_connectors ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_account_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_account_connectors(::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_account_connectors_client_stub.call_count
      end
    end
  end

  def test_get_account_connector
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::AccountConnector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_get_account_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_account_connector_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_account_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_account_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_account_connector ::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_account_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_account_connector(::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_account_connector_client_stub.call_count
      end
    end
  end

  def test_create_account_connector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    account_connector_id = "hello world"
    account_connector = {}
    request_id = "hello world"
    validate_only = true

    create_account_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_create_account_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_account_connector_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_account_connector({ parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_account_connector parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_account_connector ::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest.new(parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_account_connector({ parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_account_connector(::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest.new(parent: parent, account_connector_id: account_connector_id, account_connector: account_connector, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_account_connector_client_stub.call_count
      end
    end
  end

  def test_update_account_connector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    account_connector = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_account_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_update_account_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_account_connector_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_account_connector({ update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_account_connector update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_account_connector ::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest.new(update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_account_connector({ update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_account_connector(::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest.new(update_mask: update_mask, account_connector: account_connector, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_account_connector_client_stub.call_count
      end
    end
  end

  def test_delete_account_connector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_account_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_delete_account_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_account_connector_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_account_connector({ name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_account_connector name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_account_connector ::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_account_connector({ name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_account_connector(::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_account_connector_client_stub.call_count
      end
    end
  end

  def test_fetch_access_token
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account_connector = "hello world"

    fetch_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_access_token({ account_connector: account_connector }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_access_token account_connector: account_connector do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_access_token ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest.new(account_connector: account_connector) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_access_token({ account_connector: account_connector }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_access_token(::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest.new(account_connector: account_connector), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_access_token_client_stub.call_count
      end
    end
  end

  def test_list_users
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::ListUsersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_users_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_list_users_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_users_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_users parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_users ::Google::Cloud::DeveloperConnect::V1::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_users({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_users(::Google::Cloud::DeveloperConnect::V1::ListUsersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_users_client_stub.call_count
      end
    end
  end

  def test_delete_user
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    validate_only = true
    etag = "hello world"

    delete_user_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_delete_user_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_user_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_user({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_user name: name, request_id: request_id, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_user ::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_user({ name: name, request_id: request_id, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_user(::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest.new(name: name, request_id: request_id, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_user_client_stub.call_count
      end
    end
  end

  def test_fetch_self
    # Create test objects.
    client_result = ::Google::Cloud::DeveloperConnect::V1::User.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_self_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_fetch_self_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_self_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_self({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_self name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_self ::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_self({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_self(::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_self_client_stub.call_count
      end
    end
  end

  def test_delete_self
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_self_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::ServiceStub.stub :transcode_delete_self_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_self_client_stub do
        # Create client
        client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_self({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_self name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_self ::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_self({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_self(::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_self_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Rest::Client::Configuration, config
  end
end
