# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Developerconnect
      module V1
        # The InsightsConfig resource is the core configuration object to capture
        # events from your Software Development Lifecycle. It acts as the central hub
        # for managing how Developer connect understands your application, its runtime
        # environments, and the artifacts deployed within them.
        # @!attribute [rw] app_hub_application
        #   @return [::String]
        #     Optional. The name of the App Hub Application.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/applications/\\{application}
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the InsightsConfig.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/insightsConfigs/\\{insightsConfig}
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp
        # @!attribute [r] runtime_configs
        #   @return [::Array<::Google::Cloud::Developerconnect::V1::RuntimeConfig>]
        #     Output only. The runtime configurations where the application is deployed.
        # @!attribute [rw] artifact_configs
        #   @return [::Array<::Google::Cloud::Developerconnect::V1::ArtifactConfig>]
        #     Optional. The artifact configurations of the artifacts that are deployed.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Developerconnect::V1::InsightsConfig::State]
        #     Optional. Output only. The state of the InsightsConfig.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User specified annotations. See
        #     https://google.aip.dev/148#annotations for more details such as format and
        #     size limitations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of labels associated with an InsightsConfig.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Reconciling (https://google.aip.dev/128#reconciliation).
        #     Set to true if the current state of InsightsConfig does not match the
        #     user's intended state, and the service is actively updating the resource to
        #     reconcile them. This can happen due to user-triggered updates or
        #     system actions like failover or maintenance.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Any errors that occurred while setting up the InsightsConfig.
        #     Each error will be in the format: `field_name: error_message`, e.g.
        #     GetAppHubApplication: Permission denied while getting App Hub
        #     application. Please grant permissions to the P4SA.
        class InsightsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the InsightsConfig.
          module State
            # No state specified.
            STATE_UNSPECIFIED = 0

            # The InsightsConfig is pending application discovery/runtime discovery.
            PENDING = 5

            # The initial discovery process is complete.
            COMPLETE = 3

            # The InsightsConfig is in an error state.
            ERROR = 4
          end
        end

        # RuntimeConfig represents the runtimes where the application is
        # deployed.
        # @!attribute [r] gke_workload
        #   @return [::Google::Cloud::Developerconnect::V1::GKEWorkload]
        #     Output only. Google Kubernetes Engine runtime.
        # @!attribute [r] app_hub_workload
        #   @return [::Google::Cloud::Developerconnect::V1::AppHubWorkload]
        #     Output only. App Hub Workload.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. Immutable. The URI of the runtime configuration.
        #     For GKE, this is the cluster name.
        #     For Cloud Run, this is the service name.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Developerconnect::V1::RuntimeConfig::State]
        #     Output only. The state of the Runtime.
        class RuntimeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state of the runtime in the InsightsConfig.
          # Whether the runtime is linked to the InsightsConfig.
          module State
            # No state specified.
            STATE_UNSPECIFIED = 0

            # The runtime configuration has been linked to the InsightsConfig.
            LINKED = 1

            # The runtime configuration has been unlinked to the InsightsConfig.
            UNLINKED = 2
          end
        end

        # GKEWorkload represents the Google Kubernetes Engine runtime.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Required. Immutable. The name of the GKE cluster.
        #     Format:
        #     `projects/{project}/locations/{location}/clusters/{cluster}`.
        # @!attribute [r] deployment
        #   @return [::String]
        #     Output only. The name of the GKE deployment.
        #     Format:
        #     `projects/{project}/locations/{location}/clusters/{cluster}/namespaces/{namespace}/deployments/{deployment}`.
        class GKEWorkload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AppHubWorkload represents the App Hub Workload.
        # @!attribute [r] workload
        #   @return [::String]
        #     Required. Output only. Immutable. The name of the App Hub Workload.
        #     Format:
        #     `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
        # @!attribute [r] criticality
        #   @return [::String]
        #     Output only. The criticality of the App Hub Workload.
        # @!attribute [r] environment
        #   @return [::String]
        #     Output only. The environment of the App Hub Workload.
        class AppHubWorkload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The artifact config of the artifact that is deployed.
        # @!attribute [rw] google_artifact_registry
        #   @return [::Google::Cloud::Developerconnect::V1::GoogleArtifactRegistry]
        #     Optional. Set if the artifact is stored in Artifact regsitry.
        # @!attribute [rw] google_artifact_analysis
        #   @return [::Google::Cloud::Developerconnect::V1::GoogleArtifactAnalysis]
        #     Optional. Set if the artifact metadata is stored in Artifact analysis.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. Immutable. The URI of the artifact that is deployed.
        #     e.g. `us-docker.pkg.dev/my-project/my-repo/image`.
        #     The URI does not include the tag / digest because it captures a lineage of
        #     artifacts.
        class ArtifactConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Google Artifact Analysis configurations.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The project id of the project where the provenance is stored.
        class GoogleArtifactAnalysis
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Google Artifact Registry configurations.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. The host project of Artifact Registry.
        # @!attribute [rw] artifact_registry_package
        #   @return [::String]
        #     Required. Immutable. The name of the artifact registry package.
        class GoogleArtifactRegistry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for creating an InsightsConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] insights_config_id
        #   @return [::String]
        #     Required. ID of the requesting InsightsConfig.
        # @!attribute [rw] insights_config
        #   @return [::Google::Cloud::Developerconnect::V1::InsightsConfig]
        #     Required. The resource being created.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class CreateInsightsConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting an InsightsConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetInsightsConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for requesting list of InsightsConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListInsightsConfigsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results. See https://google.aip.dev/160 for more
        #     details. Filter string, adhering to the rules in
        #     https://google.aip.dev/160. List only InsightsConfigs matching the filter.
        #     If filter is empty, all InsightsConfigs are listed.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results.
        class ListInsightsConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for response to listing InsightsConfigs.
        # @!attribute [rw] insights_configs
        #   @return [::Array<::Google::Cloud::Developerconnect::V1::InsightsConfig>]
        #     The list of InsightsConfigs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInsightsConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting an InsightsConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteInsightsConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating an InsightsConfig.
        # @!attribute [rw] insights_config
        #   @return [::Google::Cloud::Developerconnect::V1::InsightsConfig]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and the insightsConfig is not found a new
        #     insightsConfig will be created. In this situation `update_mask` is ignored.
        #     The creation will succeed only if the input insightsConfig has all the
        #     necessary information (e.g a github_config with both  user_oauth_token and
        #     installation_id properties).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class UpdateInsightsConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
