# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DeveloperConnect
      module V1
        # Message for requesting a list of Users
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListUsersRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListUsersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Users
        # @!attribute [rw] users
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::User>]
        #     The list of Users
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListUsersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Connection object
        # @!attribute [rw] github_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitHubConfig]
        #     Configuration for connections to github.com.
        #
        #     Note: The following fields are mutually exclusive: `github_config`, `github_enterprise_config`, `gitlab_config`, `gitlab_enterprise_config`, `bitbucket_data_center_config`, `bitbucket_cloud_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] github_enterprise_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitHubEnterpriseConfig]
        #     Configuration for connections to an instance of GitHub Enterprise.
        #
        #     Note: The following fields are mutually exclusive: `github_enterprise_config`, `github_config`, `gitlab_config`, `gitlab_enterprise_config`, `bitbucket_data_center_config`, `bitbucket_cloud_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gitlab_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitLabConfig]
        #     Configuration for connections to gitlab.com.
        #
        #     Note: The following fields are mutually exclusive: `gitlab_config`, `github_config`, `github_enterprise_config`, `gitlab_enterprise_config`, `bitbucket_data_center_config`, `bitbucket_cloud_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gitlab_enterprise_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitLabEnterpriseConfig]
        #     Configuration for connections to an instance of GitLab Enterprise.
        #
        #     Note: The following fields are mutually exclusive: `gitlab_enterprise_config`, `github_config`, `github_enterprise_config`, `gitlab_config`, `bitbucket_data_center_config`, `bitbucket_cloud_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bitbucket_data_center_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::BitbucketDataCenterConfig]
        #     Configuration for connections to an instance of Bitbucket Data Center.
        #
        #     Note: The following fields are mutually exclusive: `bitbucket_data_center_config`, `github_config`, `github_enterprise_config`, `gitlab_config`, `gitlab_enterprise_config`, `bitbucket_cloud_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bitbucket_cloud_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::BitbucketCloudConfig]
        #     Configuration for connections to an instance of Bitbucket Clouds.
        #
        #     Note: The following fields are mutually exclusive: `bitbucket_cloud_config`, `github_config`, `github_enterprise_config`, `gitlab_config`, `gitlab_enterprise_config`, `bitbucket_data_center_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the connection, in the format
        #     `projects/{project}/locations/{location}/connections/{connection_id}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Delete timestamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [r] installation_state
        #   @return [::Google::Cloud::DeveloperConnect::V1::InstallationState]
        #     Output only. Installation state of the Connection.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. If disabled is set to true, functionality is disabled for this
        #     connection. Repository based API methods and webhooks processing for
        #     repositories in this connection will be disabled.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Set to true when the connection is being set up or updated in
        #     the background.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Allows clients to store small amounts of arbitrary data.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-assigned unique identifier for the Connection.
        # @!attribute [rw] crypto_key_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::CryptoKeyConfig]
        #     Optional. The crypto key configuration. This field is used by the
        #     Customer-Managed Encryption Keys (CMEK) feature.
        # @!attribute [rw] git_proxy_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitProxyConfig]
        #     Optional. Configuration for the git proxy feature. Enabling the git proxy
        #     allows clients to perform git operations on the repositories linked in the
        #     connection.
        class Connection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The crypto key configuration. This field is used by the Customer-managed
        # encryption keys (CMEK) feature.
        # @!attribute [rw] key_reference
        #   @return [::String]
        #     Required. The name of the key which is used to encrypt/decrypt customer
        #     data. For key in Cloud KMS, the key should be in the format of
        #     `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        class CryptoKeyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The git proxy configuration.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     Optional. Setting this to true allows the git proxy to be used for
        #     performing git operations on the repositories linked in the connection.
        class GitProxyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes stage and necessary actions to be taken by the
        # user to complete the installation. Used for GitHub and GitHub Enterprise
        # based connections.
        # @!attribute [r] stage
        #   @return [::Google::Cloud::DeveloperConnect::V1::InstallationState::Stage]
        #     Output only. Current step of the installation process.
        # @!attribute [r] message
        #   @return [::String]
        #     Output only. Message of what the user should do next to continue the
        #     installation. Empty string if the installation is already complete.
        # @!attribute [r] action_uri
        #   @return [::String]
        #     Output only. Link to follow for next action. Empty string if the
        #     installation is already complete.
        class InstallationState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Stage of the installation process.
          module Stage
            # No stage specified.
            STAGE_UNSPECIFIED = 0

            # Only for GitHub Enterprise. An App creation has been requested.
            # The user needs to confirm the creation in their GitHub enterprise host.
            PENDING_CREATE_APP = 1

            # User needs to authorize the GitHub (or Enterprise) App via OAuth.
            PENDING_USER_OAUTH = 2

            # User needs to follow the link to install the GitHub (or Enterprise) App.
            PENDING_INSTALL_APP = 3

            # Installation process has been completed.
            COMPLETE = 10
          end
        end

        # Configuration for connections to github.com.
        # @!attribute [rw] github_app
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitHubConfig::GitHubApp]
        #     Required. Immutable. The GitHub Application that was installed to the
        #     GitHub user or organization.
        # @!attribute [rw] authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::OAuthCredential]
        #     Optional. OAuth credential of the account that authorized the GitHub App.
        #     It is recommended to use a robot account instead of a human user account.
        #     The OAuth token must be tied to the GitHub App of this config.
        # @!attribute [rw] app_installation_id
        #   @return [::Integer]
        #     Optional. GitHub App installation id.
        # @!attribute [r] installation_uri
        #   @return [::String]
        #     Output only. The URI to navigate to in order to manage the installation
        #     associated with this GitHubConfig.
        class GitHubConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the various GitHub Applications that can be installed to a
          # GitHub user or organization and used with Developer Connect.
          module GitHubApp
            # GitHub App not specified.
            GIT_HUB_APP_UNSPECIFIED = 0

            # The Developer Connect GitHub Application.
            DEVELOPER_CONNECT = 1

            # The Firebase GitHub Application.
            FIREBASE = 2
          end
        end

        # Configuration for connections to an instance of GitHub Enterprise.
        # @!attribute [rw] host_uri
        #   @return [::String]
        #     Required. The URI of the GitHub Enterprise host this connection is for.
        # @!attribute [rw] app_id
        #   @return [::Integer]
        #     Optional. ID of the GitHub App created from the manifest.
        # @!attribute [r] app_slug
        #   @return [::String]
        #     Output only. The URL-friendly name of the GitHub App.
        # @!attribute [rw] private_key_secret_version
        #   @return [::String]
        #     Optional. SecretManager resource containing the private key of the GitHub
        #     App, formatted as `projects/*/secrets/*/versions/*`.
        # @!attribute [rw] webhook_secret_secret_version
        #   @return [::String]
        #     Optional. SecretManager resource containing the webhook secret of the
        #     GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        # @!attribute [rw] app_installation_id
        #   @return [::Integer]
        #     Optional. ID of the installation of the GitHub App.
        # @!attribute [r] installation_uri
        #   @return [::String]
        #     Output only. The URI to navigate to in order to manage the installation
        #     associated with this GitHubEnterpriseConfig.
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::ServiceDirectoryConfig]
        #     Optional. Configuration for using Service Directory to privately connect to
        #     a GitHub Enterprise server. This should only be set if the GitHub
        #     Enterprise server is hosted on-premises and not reachable by public
        #     internet. If this field is left empty, calls to the GitHub Enterprise
        #     server will be made over the public internet.
        # @!attribute [r] server_version
        #   @return [::String]
        #     Output only. GitHub Enterprise version installed at the host_uri.
        # @!attribute [rw] ssl_ca_certificate
        #   @return [::String]
        #     Optional. SSL certificate to use for requests to GitHub Enterprise.
        class GitHubEnterpriseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ServiceDirectoryConfig represents Service Directory configuration for a
        # connection.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The Service Directory service name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/namespaces/\\{namespace}/services/\\{service}.
        class ServiceDirectoryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an OAuth token of the account that authorized the Connection,
        # and associated metadata.
        # @!attribute [rw] oauth_token_secret_version
        #   @return [::String]
        #     Required. A SecretManager resource containing the OAuth token that
        #     authorizes the connection. Format: `projects/*/secrets/*/versions/*`.
        # @!attribute [r] username
        #   @return [::String]
        #     Output only. The username associated with this token.
        class OAuthCredential
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for connections to gitlab.com.
        # @!attribute [rw] webhook_secret_secret_version
        #   @return [::String]
        #     Required. Immutable. SecretManager resource containing the webhook secret
        #     of a GitLab project, formatted as `projects/*/secrets/*/versions/*`. This
        #     is used to validate webhooks.
        # @!attribute [rw] read_authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. A GitLab personal access token with the minimum `read_api` scope
        #     access and a minimum role of `reporter`. The GitLab Projects visible to
        #     this Personal Access Token will control which Projects Developer Connect
        #     has access to.
        # @!attribute [rw] authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. A GitLab personal access token with the minimum `api` scope
        #     access and a minimum role of `maintainer`. The GitLab Projects visible to
        #     this Personal Access Token will control which Projects Developer Connect
        #     has access to.
        class GitLabConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a personal access token that authorized the Connection,
        # and associated metadata.
        # @!attribute [rw] user_token_secret_version
        #   @return [::String]
        #     Required. A SecretManager resource containing the user token that
        #     authorizes the Developer Connect connection. Format:
        #     `projects/*/secrets/*/versions/*`.
        # @!attribute [r] username
        #   @return [::String]
        #     Output only. The username associated with this token.
        class UserCredential
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for connections to an instance of GitLab Enterprise.
        # @!attribute [rw] host_uri
        #   @return [::String]
        #     Required. The URI of the GitLab Enterprise host this connection is for.
        # @!attribute [rw] webhook_secret_secret_version
        #   @return [::String]
        #     Required. Immutable. SecretManager resource containing the webhook secret
        #     of a GitLab project, formatted as `projects/*/secrets/*/versions/*`. This
        #     is used to validate webhooks.
        # @!attribute [rw] read_authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. A GitLab personal access token with the minimum `read_api` scope
        #     access and a minimum role of `reporter`. The GitLab Projects visible to
        #     this Personal Access Token will control which Projects Developer Connect
        #     has access to.
        # @!attribute [rw] authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. A GitLab personal access token with the minimum `api` scope
        #     access and a minimum role of `maintainer`. The GitLab Projects visible to
        #     this Personal Access Token will control which Projects Developer Connect
        #     has access to.
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::ServiceDirectoryConfig]
        #     Optional. Configuration for using Service Directory to privately connect to
        #     a GitLab Enterprise instance. This should only be set if the GitLab
        #     Enterprise server is hosted on-premises and not reachable by public
        #     internet. If this field is left empty, calls to the GitLab Enterprise
        #     server will be made over the public internet.
        # @!attribute [rw] ssl_ca_certificate
        #   @return [::String]
        #     Optional. SSL Certificate Authority certificate to use for requests to
        #     GitLab Enterprise instance.
        # @!attribute [r] server_version
        #   @return [::String]
        #     Output only. Version of the GitLab Enterprise server running on the
        #     `host_uri`.
        class GitLabEnterpriseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for connections to an instance of Bitbucket Data Center.
        # @!attribute [rw] host_uri
        #   @return [::String]
        #     Required. The URI of the Bitbucket Data Center host this connection is for.
        # @!attribute [rw] webhook_secret_secret_version
        #   @return [::String]
        #     Required. Immutable. SecretManager resource containing the webhook secret
        #     used to verify webhook events, formatted as
        #     `projects/*/secrets/*/versions/*`. This is used to validate webhooks.
        # @!attribute [rw] read_authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. An http access token with the minimum `Repository read` access.
        #     It's recommended to use a system account to generate the credentials.
        # @!attribute [rw] authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. An http access token with the minimum `Repository admin` scope
        #     access. This is needed to create webhooks. It's recommended to use a system
        #     account to generate these credentials.
        # @!attribute [rw] service_directory_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::ServiceDirectoryConfig]
        #     Optional. Configuration for using Service Directory to privately connect to
        #     a Bitbucket Data Center instance. This should only be set if the Bitbucket
        #     Data Center is hosted on-premises and not reachable by public internet. If
        #     this field is left empty, calls to the Bitbucket Data Center will be made
        #     over the public internet.
        # @!attribute [rw] ssl_ca_certificate
        #   @return [::String]
        #     Optional. SSL certificate authority to trust when making requests to
        #     Bitbucket Data Center.
        # @!attribute [r] server_version
        #   @return [::String]
        #     Output only. Version of the Bitbucket Data Center server running on the
        #     `host_uri`.
        class BitbucketDataCenterConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for connections to an instance of Bitbucket Cloud.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud
        #     Platform.
        # @!attribute [rw] webhook_secret_secret_version
        #   @return [::String]
        #     Required. Immutable. SecretManager resource containing the webhook secret
        #     used to verify webhook events, formatted as
        #     `projects/*/secrets/*/versions/*`. This is used to validate and create
        #     webhooks.
        # @!attribute [rw] read_authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. An access token with the minimum `repository` access.
        #     It can either be a workspace, project or repository access token.
        #     It's recommended to use a system account to generate the credentials.
        # @!attribute [rw] authorizer_credential
        #   @return [::Google::Cloud::DeveloperConnect::V1::UserCredential]
        #     Required. An access token with the minimum `repository`, `pullrequest` and
        #     `webhook` scope access. It can either be a workspace, project or repository
        #     access token. This is needed to create webhooks. It's recommended to use a
        #     system account to generate these credentials.
        class BitbucketCloudConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Connections
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListConnectionsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Connections
        # @!attribute [rw] connections
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::Connection>]
        #     The list of Connection
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Connection
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Connection
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] connection_id
        #   @return [::String]
        #     Required. Id of the requesting object
        #     If auto-generating Id server-side, remove this field and
        #     connection_id from the method_signature of Create RPC
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::DeveloperConnect::V1::Connection]
        #     Required. The resource being created
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class CreateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Connection
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Connection resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::DeveloperConnect::V1::Connection]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and the connection is not found a new connection
        #     will be created. In this situation `update_mask` is ignored.
        #     The creation will succeed only if the input connection has all the
        #     necessary information (e.g a github_config with both  user_oauth_token and
        #     installation_id properties).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class UpdateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Connection
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the Connection.
        #     If an etag is provided and does not match the current etag of the
        #     Connection, deletion will be blocked and an ABORTED error will be returned.
        class DeleteConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of AccountConnectors
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListAccountConnectorsRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListAccountConnectorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing AccountConnectors
        # @!attribute [rw] account_connectors
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::AccountConnector>]
        #     The list of AccountConnectors
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAccountConnectorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a AccountConnector
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetAccountConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Location resource name as the account_connector’s parent.
        # @!attribute [rw] account_connector_id
        #   @return [::String]
        #     Required. The ID to use for the AccountConnector, which will become the
        #     final component of the AccountConnector's resource name. Its format should
        #     adhere to https://google.aip.dev/122#resource-id-segments Names must be
        #     unique per-project per-location.
        # @!attribute [rw] account_connector
        #   @return [::Google::Cloud::DeveloperConnect::V1::AccountConnector]
        #     Required. The AccountConnector to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class CreateAccountConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a AccountConnector
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to be updated.
        # @!attribute [rw] account_connector
        #   @return [::Google::Cloud::DeveloperConnect::V1::AccountConnector]
        #     Required. The AccountConnector to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and the accountConnector is not found a new
        #     accountConnector will be created. In this situation `update_mask` is
        #     ignored. The creation will succeed only if the input accountConnector has
        #     all the necessary
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class UpdateAccountConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a AccountConnector
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The current etag of the AccountConnectorn.
        #     If an etag is provided and does not match the current etag of the
        #     AccountConnector, deletion will be blocked and an ABORTED error will be
        #     returned.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any Users from this AccountConnector will also
        #     be deleted. (Otherwise, the request will only work if the AccountConnector
        #     has no Users.)
        class DeleteAccountConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a User
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteUserRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have been cancelled successfully
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for fetching a User of the user themselves.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the AccountConnector resource
        class FetchSelfRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a User of the user themselves.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the AccountConnector resource
        class DeleteSelfRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for fetching an OAuth access token.
        # @!attribute [rw] account_connector
        #   @return [::String]
        #     Required. The resource name of the AccountConnector in the format
        #     `projects/*/locations/*/accountConnectors/*`.
        class FetchAccessTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for responding to getting an OAuth access token.
        # @!attribute [rw] token
        #   @return [::String]
        #     The token content.
        # @!attribute [rw] expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Expiration timestamp. Can be empty if unknown or non-expiring.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     The scopes of the access token.
        # @!attribute [rw] exchange_error
        #   @return [::Google::Cloud::DeveloperConnect::V1::ExchangeError]
        #     The error resulted from exchanging OAuth tokens from the service provider.
        class FetchAccessTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for representing an error from exchanging OAuth tokens.
        # @!attribute [rw] code
        #   @return [::String]
        #     https://datatracker.ietf.org/doc/html/rfc6749#section-5.2 - error
        # @!attribute [rw] description
        #   @return [::String]
        #     https://datatracker.ietf.org/doc/html/rfc6749#section-5.2 -
        #     error_description
        class ExchangeError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing the GitRepositoryLink object
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the repository, in the format
        #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        # @!attribute [rw] clone_uri
        #   @return [::String]
        #     Required. Git Clone URI.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Delete timestamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Set to true when the connection is being set up or updated in
        #     the background.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Allows clients to store small amounts of arbitrary data.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-assigned unique identifier for the GitRepositoryLink.
        # @!attribute [r] webhook_id
        #   @return [::String]
        #     Output only. External ID of the webhook created for the repository.
        # @!attribute [r] git_proxy_uri
        #   @return [::String]
        #     Output only. URI to access the linked repository through the Git Proxy.
        #     This field is only populated if the git proxy is enabled for the
        #     connection.
        class GitRepositoryLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for creating a GitRepositoryLink
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] git_repository_link
        #   @return [::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink]
        #     Required. The resource being created
        # @!attribute [rw] git_repository_link_id
        #   @return [::String]
        #     Required. The ID to use for the repository, which will become the final
        #     component of the repository's resource name. This ID should be unique in
        #     the connection. Allows alphanumeric characters and any of
        #     -._~%!$&'()*+,;=@.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        class CreateGitRepositoryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a GitRepositoryLink
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteGitRepositoryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting a list of GitRepositoryLinks
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListGitRepositoryLinksRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListGitRepositoryLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing GitRepositoryLinks
        # @!attribute [rw] git_repository_links
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink>]
        #     The list of GitRepositoryLinks
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListGitRepositoryLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a GitRepositoryLink
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        class GetGitRepositoryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for fetching SCM read/write token.
        # @!attribute [rw] git_repository_link
        #   @return [::String]
        #     Required. The resource name of the gitRepositoryLink in the format
        #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        class FetchReadWriteTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for fetching SCM read token.
        # @!attribute [rw] git_repository_link
        #   @return [::String]
        #     Required. The resource name of the gitRepositoryLink in the format
        #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        class FetchReadTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for responding to get read token.
        # @!attribute [rw] token
        #   @return [::String]
        #     The token content.
        # @!attribute [rw] expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Expiration timestamp. Can be empty if unknown or non-expiring.
        # @!attribute [rw] git_username
        #   @return [::String]
        #     The git_username to specify when making a git clone with the
        #     token. For example, for GitHub GitRepositoryLinks, this would be
        #     "x-access-token"
        class FetchReadTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for responding to get read/write token.
        # @!attribute [rw] token
        #   @return [::String]
        #     The token content.
        # @!attribute [rw] expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Expiration timestamp. Can be empty if unknown or non-expiring.
        # @!attribute [rw] git_username
        #   @return [::String]
        #     The git_username to specify when making a git clone with the
        #     token. For example, for GitHub GitRepositoryLinks, this would be
        #     "x-access-token"
        class FetchReadWriteTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for FetchLinkableGitRepositoriesRequest.
        # @!attribute [rw] connection
        #   @return [::String]
        #     Required. The name of the Connection.
        #     Format: `projects/*/locations/*/connections/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of results to return in the list. Defaults to 20.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page start.
        class FetchLinkableGitRepositoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for FetchLinkableGitRepositories.
        # @!attribute [rw] linkable_git_repositories
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::LinkableGitRepository>]
        #     The git repositories that can be linked to the connection.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class FetchLinkableGitRepositoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LinkableGitRepository represents a git repository that can be linked to a
        # connection.
        # @!attribute [rw] clone_uri
        #   @return [::String]
        #     The clone uri of the repository.
        class LinkableGitRepository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for fetching github installations.
        # @!attribute [rw] connection
        #   @return [::String]
        #     Required. The resource name of the connection in the format
        #     `projects/*/locations/*/connections/*`.
        class FetchGitHubInstallationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of fetching github installations.
        # @!attribute [rw] installations
        #   @return [::Array<::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse::Installation>]
        #     List of installations available to the OAuth user (for github.com)
        #     or all the installations (for GitHub enterprise).
        class FetchGitHubInstallationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents an installation of the GitHub App.
          # @!attribute [rw] id
          #   @return [::Integer]
          #     ID of the installation in GitHub.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the GitHub user or organization that owns this installation.
          # @!attribute [rw] type
          #   @return [::String]
          #     Either "user" or "organization".
          class Installation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for fetching git refs.
        # @!attribute [rw] git_repository_link
        #   @return [::String]
        #     Required. The resource name of GitRepositoryLink in the format
        #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
        # @!attribute [rw] ref_type
        #   @return [::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest::RefType]
        #     Required. Type of refs to fetch.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of results to return in the list. Default to 20.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page start.
        class FetchGitRefsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of refs.
          module RefType
            # No type specified.
            REF_TYPE_UNSPECIFIED = 0

            # To fetch tags.
            TAG = 1

            # To fetch branches.
            BRANCH = 2
          end
        end

        # Response for fetching git refs.
        # @!attribute [rw] ref_names
        #   @return [::Array<::String>]
        #     Name of the refs fetched.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class FetchGitRefsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AccountConnector encapsulates what a platform administrator needs to
        # configure for users to connect to the service providers, which includes,
        # among other fields, the OAuth client ID, client secret, and authorization and
        # token endpoints.
        # @!attribute [rw] provider_oauth_config
        #   @return [::Google::Cloud::DeveloperConnect::V1::ProviderOAuthConfig]
        #     Provider OAuth config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the accountConnector, in the format
        #     `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the accountConnector was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the accountConnector was updated.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Allows users to store small amounts of arbitrary data.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [r] oauth_start_uri
        #   @return [::String]
        #     Output only. Start OAuth flow by clicking on this URL.
        class AccountConnector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # User represents a user connected to the service providers through
        # a AccountConnector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the user, in the format
        #     `projects/*/locations/*/accountConnectors/*/users/*`.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Developer Connect automatically converts user identity
        #     to some human readable description, e.g., email address.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the user was created.
        # @!attribute [r] last_token_request_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the token was last requested.
        class User
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ProviderOAuthConfig is the OAuth config for a provider.
        # @!attribute [rw] system_provider_id
        #   @return [::Google::Cloud::DeveloperConnect::V1::SystemProvider]
        #     Immutable. Developer Connect provided OAuth.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     Required. User selected scopes to apply to the Oauth config
        #     In the event of changing scopes, user records under AccountConnector will
        #     be deleted and users will re-auth again.
        class ProviderOAuthConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SystemProvider is a list of providers that are owned by Developer Connect.
        module SystemProvider
          # No system provider specified.
          SYSTEM_PROVIDER_UNSPECIFIED = 0

          # GitHub provider.
          # Scopes can be found at
          # https://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes
          GITHUB = 1

          # GitLab provider.
          # Scopes can be found at
          # https://docs.gitlab.com/user/profile/personal_access_tokens/#personal-access-token-scopes
          GITLAB = 2

          # Google provider.
          # Recommended scopes:
          #   "https://www.googleapis.com/auth/drive.readonly",
          #   "https://www.googleapis.com/auth/documents.readonly"
          GOOGLE = 3

          # Sentry provider.
          # Scopes can be found at
          # https://docs.sentry.io/api/permissions/
          SENTRY = 4

          # Rovo provider.
          # Must select the "rovo" scope.
          ROVO = 5

          # New Relic provider.
          # No scopes are allowed.
          NEW_RELIC = 6

          # Datastax provider.
          # No scopes are allowed.
          DATASTAX = 7

          # Dynatrace provider.
          DYNATRACE = 8
        end
      end
    end
  end
end
