# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/developer_connect/v1/version"

require "google/cloud/developerconnect/v1/insights_config_service/credentials"
require "google/cloud/developerconnect/v1/insights_config_service/paths"
require "google/cloud/developerconnect/v1/insights_config_service/operations"
require "google/cloud/developerconnect/v1/insights_config_service/client"
require "google/cloud/developerconnect/v1/insights_config_service/rest"

module Google
  module Cloud
    module Developerconnect
      module V1
        ##
        # Creates and manages InsightsConfigs.
        #
        # The InsightsConfig resource is the core configuration object to capture
        # events from your Software Development Lifecycle. It acts as the central hub
        # for managing how Developer connect understands your application, its runtime
        # environments, and the artifacts deployed within them.
        # A user can create an InsightsConfig, list previously-requested
        # InsightsConfigs or get InsightsConfigs by their ID to determine the status of
        # the InsightsConfig.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/developerconnect/v1/insights_config_service"
        #     client = ::Google::Cloud::Developerconnect::V1::InsightsConfigService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/developerconnect/v1/insights_config_service/rest"
        #     client = ::Google::Cloud::Developerconnect::V1::InsightsConfigService::Rest::Client.new
        #
        module InsightsConfigService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "insights_config_service", "helpers.rb"
require "google/cloud/developerconnect/v1/insights_config_service/helpers" if ::File.file? helper_path
